SET foreign_key_checks = 0;
#
# TABLE STRUCTURE FOR: ac_accounts
#

DROP TABLE IF EXISTS `ac_accounts`;

CREATE TABLE `ac_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `sort_code` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  `account_name` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `account_code` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `balance` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1,
  `created_by` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `delete_bit` int(11) DEFAULT '0',
  `account_selection_name` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `paymenttypes_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `expense_id` int(11) DEFAULT NULL,
  `warehouse_id` int(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `paymenttypes_id` (`paymenttypes_id`),
  KEY `customer_id` (`customer_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `expense_id` (`expense_id`),
  CONSTRAINT `ac_accounts_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_2` FOREIGN KEY (`paymenttypes_id`) REFERENCES `db_paymenttypes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_4` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_5` FOREIGN KEY (`expense_id`) REFERENCES `db_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`, `warehouse_id`) VALUES (1, 1, 2, 0, '1', 'Current Account', 'AC/02/0001', '44.0000', '', 'Liwa', '2025-08-20', '09:27:34 am', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', 1, 0, NULL, NULL, NULL, NULL, NULL, 3);
INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`, `warehouse_id`) VALUES (2, 2, 2, 0, '2', 'Treasury account', 'AC/02/0002', '0.0000', '', 'Liwa', '2025-08-20', '09:29:09 am', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', 1, 0, NULL, NULL, NULL, NULL, NULL, 3);


#
# TABLE STRUCTURE FOR: ac_moneydeposits
#

DROP TABLE IF EXISTS `ac_moneydeposits`;

CREATE TABLE `ac_moneydeposits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `debit_account_id` int(11) DEFAULT NULL,
  `credit_account_id` int(11) DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneydeposits_ibfk_3` (`store_id`),
  CONSTRAINT `ac_moneydeposits_ibfk_1` FOREIGN KEY (`debit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneydeposits_ibfk_2` FOREIGN KEY (`credit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneydeposits_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `ac_moneydeposits` (`id`, `store_id`, `deposit_date`, `reference_no`, `debit_account_id`, `credit_account_id`, `amount`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`) VALUES (1, 2, '2025-08-20', '', NULL, 1, '44.0000', '', 'manager2', '2025-08-20', '10:14:33 am', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', 1);


#
# TABLE STRUCTURE FOR: ac_moneytransfer
#

DROP TABLE IF EXISTS `ac_moneytransfer`;

CREATE TABLE `ac_moneytransfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL,
  `transfer_code` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `debit_account_id` int(11) DEFAULT NULL,
  `credit_account_id` int(11) DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneytransfer_ibfk_3` (`store_id`),
  CONSTRAINT `ac_moneytransfer_ibfk_1` FOREIGN KEY (`debit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneytransfer_ibfk_2` FOREIGN KEY (`credit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneytransfer_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_transactions
#

DROP TABLE IF EXISTS `ac_transactions`;

CREATE TABLE `ac_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `transaction_date` date DEFAULT NULL,
  `transaction_type` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  `debit_account_id` int(11) DEFAULT NULL,
  `credit_account_id` int(11) DEFAULT NULL,
  `debit_amt` double(20,4) DEFAULT NULL,
  `credit_amt` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1,
  `created_by` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `ref_accounts_id` int(11) DEFAULT NULL COMMENT 'reference table',
  `ref_moneytransfer_id` int(11) DEFAULT NULL COMMENT 'reference table',
  `ref_moneydeposits_id` int(11) DEFAULT NULL COMMENT 'reference table',
  `ref_salespayments_id` int(11) DEFAULT NULL,
  `ref_salespaymentsreturn_id` int(11) DEFAULT NULL,
  `ref_purchasepayments_id` int(11) DEFAULT NULL,
  `ref_purchasepaymentsreturn_id` int(11) DEFAULT NULL,
  `ref_expense_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_id` (`transaction_type`),
  KEY `account_id` (`debit_account_id`),
  KEY `store_id` (`store_id`),
  KEY `ac_accounts_id` (`ref_accounts_id`),
  KEY `ac_moneytransfer_id` (`ref_moneytransfer_id`),
  KEY `ac_moneydeposits_id` (`ref_moneydeposits_id`),
  KEY `customer_id` (`customer_id`),
  KEY `ref_salespayments_id` (`ref_salespayments_id`),
  KEY `ref_purchasepayments_id` (`ref_purchasepayments_id`),
  KEY `ref_purchasepaymentsreturn_id` (`ref_purchasepaymentsreturn_id`),
  KEY `ac_transactions_ibfk_9` (`ref_salespaymentsreturn_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `ref_expense_id` (`ref_expense_id`),
  CONSTRAINT `ac_transactions_ibfk_10` FOREIGN KEY (`ref_purchasepayments_id`) REFERENCES `db_purchasepayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_11` FOREIGN KEY (`ref_purchasepaymentsreturn_id`) REFERENCES `db_purchasepaymentsreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_12` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_13` FOREIGN KEY (`ref_expense_id`) REFERENCES `db_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_4` FOREIGN KEY (`ref_accounts_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_5` FOREIGN KEY (`ref_moneytransfer_id`) REFERENCES `ac_moneytransfer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_6` FOREIGN KEY (`ref_moneydeposits_id`) REFERENCES `ac_moneydeposits` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_7` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_8` FOREIGN KEY (`ref_salespayments_id`) REFERENCES `db_salespayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_9` FOREIGN KEY (`ref_salespaymentsreturn_id`) REFERENCES `db_salespaymentsreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (12, 2, '', '2025-08-20', 'OPENING BALANCE', NULL, 1, NULL, '0.0000', '', 'Liwa', '2025-08-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (13, 2, '', '2025-08-20', 'OPENING BALANCE', NULL, 2, NULL, '0.0000', '', 'Liwa', '2025-08-20', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (19, 2, '', '2025-08-20', 'DEPOSIT', NULL, 1, '44.0000', '44.0000', '', 'manager2', '2025-08-20', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) CHARACTER SET utf8 NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8 NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2be515f845d27ba93031afbcdb16593b77d31326', '5.37.109.80', 1759151763, '__ci_last_regenerate|i:1759151763;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:5:\"sohar\";user_lname|s:5:\"sales\";inv_userid|s:2:\"13\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:15:\"sohar@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ebb5486dd986a40d410880bdc5a48c1d978be313', '5.37.109.80', 1759151658, '__ci_last_regenerate|i:1759151658;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c7ff4e971faf4a5046f89ddaa2455b0aa923bca3', '5.37.109.80', 1759152055, '__ci_last_regenerate|i:1759152055;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";success|s:36:\"Success!! Record Saved Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4664c06482102ae9adfc46a356cb8db4c3d36838', '5.37.109.80', 1759152073, '__ci_last_regenerate|i:1759152073;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:5:\"sohar\";user_lname|s:5:\"sales\";inv_userid|s:2:\"13\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:15:\"sohar@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('95643490968a740e0f2f421444e3e7c6a4ce242a', '5.37.109.80', 1759152536, '__ci_last_regenerate|i:1759152536;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";success|s:36:\"Success!! Record Saved Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5b4aa7ee0979a73c4cd47bc1151b0cdc01bf8325', '5.37.109.80', 1759156574, '__ci_last_regenerate|i:1759152073;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:5:\"sohar\";user_lname|s:5:\"sales\";inv_userid|s:2:\"13\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:15:\"sohar@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a1a8cf04b46082c4d65d2a501b4b11157bdfa2be', '5.37.109.80', 1759153211, '__ci_last_regenerate|i:1759153211;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";success|s:36:\"Success!! Record Saved Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1f83505aeca7d2514d42714262fd68341fd68f03', '5.37.109.80', 1759153752, '__ci_last_regenerate|i:1759153752;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";success|s:36:\"Success!! Record Saved Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e2876c2ba885221697d019386b673292c5549d32', '5.37.109.80', 1759154206, '__ci_last_regenerate|i:1759154206;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a9ab9b03240777053c18dff0b84ba88293a02125', '37.28.67.43', 1759154669, '__ci_last_regenerate|i:1759154669;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:4:\"Liwa\";user_lname|s:5:\"Sales\";inv_userid|s:1:\"4\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:14:\"liwa@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4edc348526362e1c1535985d9c988a91ac9161be', '37.28.67.43', 1759154306, '__ci_last_regenerate|i:1759154306;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:4:\"Liwa\";user_lname|s:5:\"Sales\";inv_userid|s:1:\"4\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:14:\"liwa@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a2544bacb9d55af047e9d56b64f17eff888c420e', '5.37.109.80', 1759154566, '__ci_last_regenerate|i:1759154566;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";success|s:36:\"Success!! Record Saved Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aae35e33ba8e42c6eff3106c4caa0098f2bcc552', '37.28.67.43', 1759154548, '__ci_last_regenerate|i:1759154306;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:4:\"Liwa\";user_lname|s:5:\"Sales\";inv_userid|s:1:\"4\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:14:\"liwa@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('43dc64198341e0434bc2ed996d5357d9987ec615', '5.37.109.80', 1759155282, '__ci_last_regenerate|i:1759155282;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";success|s:36:\"Success!! Record Saved Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1ab869ed1ad94e35fb1e5217be5cb7e8ac27969e', '37.28.67.43', 1759154912, '__ci_last_regenerate|i:1759154669;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:4:\"Liwa\";user_lname|s:5:\"Sales\";inv_userid|s:1:\"4\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:14:\"liwa@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bf411010c0ec18461747253d37b0d0a1d8ab412d', '5.37.109.80', 1759155725, '__ci_last_regenerate|i:1759155725;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";success|s:36:\"Success!! Record Saved Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6550836d9739a19dfb1d52fdbf5c06aa30cab899', '5.37.109.80', 1759156319, '__ci_last_regenerate|i:1759156319;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";success|s:36:\"Success!! Record Saved Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4382a8e63620d7b8ce8de5b6ad8376cdc5a8c4d9', '5.37.109.80', 1759156621, '__ci_last_regenerate|i:1759156621;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";success|s:36:\"Success!! Record Saved Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8cdf3cb481806290ecef05d49330d025374e8079', '5.37.109.80', 1759158384, '__ci_last_regenerate|i:1759158384;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:8:\"manager2\";user_lname|s:1:\" \";inv_userid|s:2:\"21\";logged_in|b:1;role_id|s:1:\"4\";role_name|s:7:\"Manager\";store_id|s:1:\"2\";email|s:18:\"manager2@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2cca4bf888a6c0d55b7f019ca6c593f8bd79ee93', '5.37.109.80', 1759158396, '__ci_last_regenerate|i:1759158384;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:5:\"sohar\";user_lname|s:5:\"sales\";inv_userid|s:2:\"13\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:15:\"sohar@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');


#
# TABLE STRUCTURE FOR: db_brands
#

DROP TABLE IF EXISTS `db_brands`;

CREATE TABLE `db_brands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `brand_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_brands_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_brands_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (1, 2, NULL, 'JP', 'Jeery Pine', 1);


#
# TABLE STRUCTURE FOR: db_category
#

DROP TABLE IF EXISTS `db_category`;

CREATE TABLE `db_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create category Code',
  `category_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_category_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (53, 2, 1, 'CT/02/0001', 'General', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (54, 2, 54, 'CT/02/0054', 'Shoes', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (55, 2, 55, 'CT/02/0055', 'BAG', '', NULL, 1);


#
# TABLE STRUCTURE FOR: db_cobpayments
#

DROP TABLE IF EXISTS `db_cobpayments`;

CREATE TABLE `db_cobpayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` mediumtext COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_company
#

DROP TABLE IF EXISTS `db_company`;

CREATE TABLE `db_company` (
  `id` double DEFAULT NULL,
  `company_code` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_website` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `website` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_logo` text COLLATE utf8_unicode_ci,
  `logo` mediumtext COLLATE utf8_unicode_ci,
  `upi_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `upi_code` text COLLATE utf8_unicode_ci,
  `country` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gst_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vat_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pan_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bank_details` mediumtext COLLATE utf8_unicode_ci,
  `cid` int(11) DEFAULT NULL,
  `category_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `supplier_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_return_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_return_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expense_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `invoice_view` int(11) DEFAULT NULL COMMENT '1=Standard,2=Indian GST',
  `status` int(11) DEFAULT NULL,
  `sms_status` int(11) DEFAULT NULL COMMENT '1=Enable 0=Disable',
  `sales_terms_and_conditions` text COLLATE utf8_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_company` (`id`, `company_code`, `company_name`, `company_website`, `mobile`, `phone`, `email`, `website`, `company_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `invoice_view`, `status`, `sms_status`, `sales_terms_and_conditions`) VALUES ('1', '', 'Company Name', NULL, '9999999999', '', 'admin@example.com', '', 'company_logo.png', 'logo-0.png', NULL, NULL, 'India', 'Karnataka', 'Belgaum', 'Address Details', '', '', '', '', '', 1, 'CT', 'IT', 'SP', 'PU', 'PR', 'CU', 'SL', 'PR', 'EX', 1, 1, 0, NULL);


#
# TABLE STRUCTURE FOR: db_country
#

DROP TABLE IF EXISTS `db_country`;

CREATE TABLE `db_country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country` varchar(4050) COLLATE utf8_unicode_ci DEFAULT NULL,
  `added_on` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=207 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (1, 'Abkhazia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (2, 'Afghanistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (3, 'Albania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (4, 'Algeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (5, 'Andorra', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (6, 'Angola', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (7, 'Antigua and Barbuda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (8, 'Argentina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (9, 'Armenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (10, 'Australia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (11, 'Austria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (12, 'Azerbaijan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (13, 'Bahamas', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (14, 'Bahrain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (15, 'Bangladesh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (16, 'Barbados', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (17, 'Belarus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (18, 'Belgium', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (19, 'Belize', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (20, 'Benin', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (21, 'Bhutan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (22, 'Bolivia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (23, 'Bosnia and Herzegovina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (24, 'Botswana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (25, 'Brazil', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (26, 'Brunei', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (27, 'Bulgaria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (28, 'Burkina Faso', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (29, 'Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (30, 'Burundi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (31, 'Cambodia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (32, 'Cameroon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (33, 'Canada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (34, 'Cape Verde', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (35, 'Central African Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (36, 'Chad', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (37, 'Chile', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (38, 'China', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (39, 'Colombia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (40, 'Comoros', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (41, 'Congo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (42, 'Cook Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (43, 'Costa Rica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (44, 'Croatia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (45, 'Cuba', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (46, 'Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (47, 'Czech Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (48, 'C?te d\'Ivoire', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (49, 'Denmark', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (50, 'Djibouti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (51, 'Dominica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (52, 'Dominican Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (53, 'East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (54, 'Ecuador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (55, 'Egypt', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (56, 'El Salvador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (57, 'Equatorial Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (58, 'Eritrea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (59, 'Estonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (60, 'Ethiopia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (61, 'Fiji', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (62, 'Finland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (63, 'France', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (64, 'Gabon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (65, 'Gambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (66, 'Georgia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (67, 'Germany', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (68, 'Ghana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (69, 'Greece', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (70, 'Grenada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (71, 'Guatemala', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (72, 'Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (73, 'Guinea-Bissau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (74, 'Guyana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (75, 'Haiti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (76, 'Honduras', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (77, 'Hungary', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (78, 'Iceland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (79, 'India', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (80, 'Indonesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (81, 'Iran', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (82, 'Iraq', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (83, 'Ireland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (84, 'Israel', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (85, 'Italy', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (86, 'Ivory Coast', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (87, 'Jamaica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (88, 'Japan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (89, 'Jordan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (90, 'Kazakhstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (91, 'Kenya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (92, 'Kiribati', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (93, 'Korea, North', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (94, 'Korea, South', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (95, 'Kosovo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (96, 'Kuwait', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (97, 'Kyrgyzstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (98, 'Laos', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (99, 'Latvia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (100, 'Lebanon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (101, 'Lesotho', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (102, 'Liberia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (103, 'Libya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (104, 'Liechtenstein', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (105, 'Lithuania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (106, 'Luxembourg', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (107, 'Macedonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (108, 'Madagascar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (109, 'Malawi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (110, 'Malaysia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (111, 'Maldives', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (112, 'Mali', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (113, 'Malta', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (114, 'Marshall Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (115, 'Mauritania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (116, 'Mauritius', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (117, 'Mexico', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (118, 'Micronesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (119, 'Moldova', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (120, 'Monaco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (121, 'Mongolia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (122, 'Montenegro', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (123, 'Morocco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (124, 'Mozambique', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (125, 'Myanmar / Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (126, 'Nagorno-Karabakh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (127, 'Namibia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (128, 'Nauru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (129, 'Nepal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (130, 'Netherlands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (131, 'New Zealand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (132, 'Nicaragua', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (133, 'Niger', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (134, 'Nigeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (135, 'Niue', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (136, 'Northern Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (137, 'Norway', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (138, 'Oman', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (139, 'Pakistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (140, 'Palau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (141, 'Palestine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (142, 'Panama', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (143, 'Papua New Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (144, 'Paraguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (145, 'Peru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (146, 'Philippines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (147, 'Poland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (148, 'Portugal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (149, 'Qatar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (150, 'Romania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (151, 'Russia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (152, 'Rwanda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (153, 'Sahrawi Arab Democratic Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (154, 'Saint Kitts and Nevis', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (155, 'Saint Lucia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (156, 'Saint Vincent and the Grenadines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (157, 'Samoa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (158, 'San Marino', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (159, 'Saudi Arabia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (160, 'Senegal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (161, 'Serbia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (162, 'Seychelles', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (163, 'Sierra Leone', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (164, 'Singapore', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (165, 'Slovakia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (166, 'Slovenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (167, 'Solomon Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (168, 'Somalia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (169, 'Somaliland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (170, 'South Africa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (171, 'South Ossetia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (172, 'Spain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (173, 'Sri Lanka', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (174, 'Sudan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (175, 'Suriname', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (176, 'Swaziland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (177, 'Sweden', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (178, 'Switzerland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (179, 'Syria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (180, 'S?o Tom? and Pr?ncipe', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (181, 'Taiwan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (182, 'Tajikistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (183, 'Tanzania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (184, 'Thailand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (185, 'Timor-Leste / East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (186, 'Togo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (187, 'Tonga', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (188, 'Trinidad and Tobago', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (189, 'Tunisia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (190, 'Turkey', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (191, 'Turkmenistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (192, 'Tuvalu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (193, 'Uganda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (194, 'Ukraine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (195, 'United Arab Emirates', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (196, 'United Kingdom', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (197, 'United States', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (198, 'Uruguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (199, 'Uzbekistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (200, 'Vanuatu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (201, 'Vatican City', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (202, 'Venezuela', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (203, 'Vietnam', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (204, 'Yemen', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (205, 'Zambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (206, 'Zimbabwe', '2020-11-03', 1);


#
# TABLE STRUCTURE FOR: db_currency
#

DROP TABLE IF EXISTS `db_currency`;

CREATE TABLE `db_currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` blob,
  `symbol` mediumtext COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (1, 'Bulgaria-Bulgarian lev(BGN)', NULL, 'лв', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (2, 'Switzerland \r-Swiss franc (CHF)', NULL, 'CHF', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (3, 'Czechia-Czech koruna(CZK))', NULL, 'Kč ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (4, 'Denmark-Danish krone(DKK)', NULL, 'kr ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (5, 'Euro area countries -Euro(EUR)', NULL, '€ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (6, 'United Kingdom-Pounds sterling (GBP)', NULL, '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (7, 'Croatia -Croatian Kuna (HRK)', NULL, 'kn', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (8, 'Georgia -Georgian lari (GEL)', NULL, '&#8382;', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (9, 'Hungary -Hungarian forint (HUF)', NULL, 'ft', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (10, 'Norway -Norwegian krone (NOK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (11, 'Poland -Polish zloty (PLN)', NULL, 'zł ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (12, 'Russia -Russian ruble (RUB)', NULL, '&#8381; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (13, 'Romania -Romanian leu (RON)', NULL, 'lei', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (14, 'Sweden - Swedish krona (SEK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (15, 'Turkey -Turkish lira (TRY)', NULL, '&#8378; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (16, 'Ukraine - Ukrainian hryvna  (UAH)', NULL, '₴ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (17, 'UAE -Emirati dirham (AED)', NULL, 'د.إ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (18, 'Israel - Israeli shekel (ILS)', NULL, '&#8362; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (19, 'Kenya - Kenyan shilling(KES)', NULL, 'Ksh', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (20, 'Morocco - Moroccan dirham (MAD)', NULL, '.د.م ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (21, 'Nigeria - Nigerian naira (NGN)', NULL, '₦ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (22, 'South Africa -South african rand** (ZAR)', NULL, 'R', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (23, 'Brazil- Brazilian real(BRL)', NULL, 'R$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (24, 'Canada-Canadian dollars (CAD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (25, 'Chile -Chilean peso (CLP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (26, 'Colombia -Colombian peso (COP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (27, 'Mexico - Mexican peso (MXN)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (28, 'Peru -Peruvian sol(PEN)', NULL, 'S/. ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (29, 'USA -US dollar (USD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (30, 'Australia -Australian dollars (AUD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (31, 'Bangladesh -Bangladeshi taka (BDT) ', NULL, '&#2547; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (32, 'China - Chinese yuan (CNY)', NULL, '&#20803; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (33, 'Hong Kong - Hong Kong dollar(HKD)', NULL, '&#36; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (34, 'Indonesia - Indonesian rupiah (IDR)', NULL, 'Rp', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (35, 'India - Indian rupee', 'INR', '₹', '?', 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (36, 'Japan - Japanese yen (JPY)', NULL, '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (37, 'Malaysia - Malaysian ringgit (MYR)', NULL, 'RM', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (38, 'New Zealand - New Zealand dollar (NZD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (39, 'Philippines- Philippine peso (PHP)', NULL, '₱ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (40, 'Pakistan- Pakistani rupee (PKR)', NULL, 'Rs ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (41, 'Singapore - Singapore dollar (SGD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (42, 'South Korea - South Korean won (KRW)', NULL, '&#8361; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (43, 'Sri Lanka - Sri Lankan rupee (LKR)', NULL, 'Rs', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (44, 'Thailand- Thai baht (THB)', NULL, '&#3647; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (45, 'Vietnam - Vietnamese dong', 'VND', '₫', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (46, 'Bitcoin - BTC or XBT', 'BTC ', '₿', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (47, 'Ripples', 'XRP', 'XRP', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (48, 'Monero', 'XMR', 'ɱ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (49, 'Litecoin', 'LTC', 'Ł', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (50, 'Ethereum', 'ETH', 'Ξ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (51, 'Euro', 'EUR', '€', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (52, 'Pounds sterling', 'GBP', '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (53, 'US dollar', 'USD', '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (54, 'Japanese yen', 'JPY', '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (55, 'Omani rial', 'OMR', 'R.O.', NULL, 1);


#
# TABLE STRUCTURE FOR: db_custadvance
#

DROP TABLE IF EXISTS `db_custadvance`;

CREATE TABLE `db_custadvance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `amount` double(20,2) DEFAULT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `note` text CHARACTER SET utf8,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_ip` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_custadvance_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_custadvance_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customer_payments
#

DROP TABLE IF EXISTS `db_customer_payments`;

CREATE TABLE `db_customer_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `salespayment_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8,
  `system_ip` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `salespayment_id` (`salespayment_id`),
  CONSTRAINT `db_customer_payments_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_payments_ibfk_2` FOREIGN KEY (`salespayment_id`) REFERENCES `db_salespayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customers
#

DROP TABLE IF EXISTS `db_customers`;

CREATE TABLE `db_customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Customer Code',
  `customer_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gstin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vatin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opening_balance` double(20,4) DEFAULT NULL,
  `sales_due` double(20,4) DEFAULT NULL,
  `sales_return_due` double(20,4) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `city` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postcode` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_country_id` int(11) DEFAULT NULL,
  `ship_state_id` int(11) DEFAULT NULL,
  `ship_city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_postcode` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_address` text COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `location_link` text COLLATE utf8_unicode_ci,
  `attachment_1` text COLLATE utf8_unicode_ci,
  `price_level_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'Increase',
  `price_level` double(20,4) DEFAULT '0.0000',
  `delete_bit` int(11) DEFAULT '0',
  `tot_advance` double(20,4) DEFAULT NULL,
  `credit_limit` double(20,4) DEFAULT '-1.0000',
  `shippingaddress_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_customers_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (1, 1, NULL, 'CU0001', 'Walk-in customer', NULL, '', '', '', '', NULL, '0.0000', '0.0000', '0.0000', 1, NULL, NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2019-01-01', '10:55:54 pm', 'admin', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, NULL, '-1.0000', 1);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (2, 2, 1, 'CU/02/0001', 'Walk-in customer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0.0000', '4.0000', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-02-12', '05:53:37 pm', '', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, '0.0000', '-1.0000', 2);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (3, 2, 3, 'CU/02/0003', 'TEST', '1122', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', NULL, NULL, NULL, NULL, NULL, '182.190.165.198', '182.190.165.198', '2025-06-03', '05:45:07 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', 9);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (4, 2, 4, 'CU/02/0004', 'Muhammed', '97759659', '', '', '', '', NULL, '0.0000', NULL, NULL, 0, NULL, '', '', '', NULL, NULL, NULL, NULL, NULL, '37.40.228.98', '37.40.228.98', '2025-06-18', '06:35:52 pm', 'Suwaiq', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, 10);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (5, 2, 5, 'CU/01/0005', 'Shoe Retailer - Sultanate of Oman', '+96897759659', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', NULL, NULL, NULL, NULL, NULL, '145.255.89.229', 'dynamic.isp.ooredoo.om', '2025-09-11', '01:01:33 am', 'manager2', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL);


#
# TABLE STRUCTURE FOR: db_emailtemplates
#

DROP TABLE IF EXISTS `db_emailtemplates`;

CREATE TABLE `db_emailtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `key` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8_unicode_ci,
  `variables` text COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  `undelete_bit` int(11) DEFAULT NULL,
  `admin_only` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_emailtemplates_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (1, 1, 'SAAS_FORGOT_PASSWORD_EMAIL', 'Site forgot password email template', 'Hi {{user_name}},\r\n\r\nyour OTP is {{email_otp}}\r\n\r\nThank you\r\n{{saas_name}}', '{{user_name}}<br>\r\n{{saas_name}}<br>\r\n{{email_otp}}<br>', 1, 1, 1);
INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (2, 1, 'SAAS_WELCOME_EMAIL', 'Site welcome email', 'Hi {{user_name}},\r\nYour email id {{email_id}},\r\nwelcome to our {{saas_name}},\r\n\r\nThank you', '{{user_name}}<br>\r\n{{email_id}}<br>\r\n{{saas_name}}<br>', 1, 1, 1);


#
# TABLE STRUCTURE FOR: db_expense
#

DROP TABLE IF EXISTS `db_expense`;

CREATE TABLE `db_expense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Expense Code',
  `expense_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `expense_date` date DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expense_for` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expense_amt` double(20,4) DEFAULT NULL,
  `payment_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8_unicode_ci,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `account_id` (`account_id`),
  CONSTRAINT `db_expense_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_expense_ibfk_2` FOREIGN KEY (`account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_expense_category
#

DROP TABLE IF EXISTS `db_expense_category`;

CREATE TABLE `db_expense_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `category_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_expense_category_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (1, 2, 'EC0001', 'Travel Expense', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (2, 2, 'EC0002', 'BUY FOR SHOP', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (3, 2, 'EC0003', 'Salaries Advance', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (4, 2, 'EC0004', 'SALARIES PAID', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (5, 2, 'EC0005', 'WATER;ELECTRICITY AND WIFI BILLS', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (7, 2, 'EC0006', 'Shop RENT', '', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_hold
#

DROP TABLE IF EXISTS `db_hold`;

CREATE TABLE `db_hold` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `reference_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Temprary',
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `sales_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text COLLATE utf8_unicode_ci,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_hold_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_hold_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_hold_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_holditems
#

DROP TABLE IF EXISTS `db_holditems`;

CREATE TABLE `db_holditems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `hold_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `sales_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`hold_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `db_holditems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_holditems_ibfk_2` FOREIGN KEY (`hold_id`) REFERENCES `db_hold` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_holditems_ibfk_3` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_instamojo
#

DROP TABLE IF EXISTS `db_instamojo`;

CREATE TABLE `db_instamojo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sandbox` int(11) DEFAULT NULL,
  `api_key` text CHARACTER SET utf8,
  `api_token` text CHARACTER SET utf8,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_instamojo_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_instamojo` (`id`, `store_id`, `sandbox`, `api_key`, `api_token`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_instamojopayments
#

DROP TABLE IF EXISTS `db_instamojopayments`;

CREATE TABLE `db_instamojopayments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(25) CHARACTER SET utf8 DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `buyer_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `amount` decimal(16,2) NOT NULL,
  `purpose` text CHARACTER SET utf8,
  `expires_at` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `send_sms` varchar(5) CHARACTER SET utf8 NOT NULL DEFAULT 'false',
  `send_email` varchar(5) CHARACTER SET utf8 NOT NULL DEFAULT 'false',
  `sms_status` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `email_status` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `shorturl` mediumtext CHARACTER SET utf8,
  `longurl` mediumtext CHARACTER SET utf8,
  `redirect_url` mediumtext CHARACTER SET utf8,
  `webhook` mediumtext CHARACTER SET utf8,
  `allow_repeated_payments` varchar(5) CHARACTER SET utf8 NOT NULL DEFAULT 'false',
  `customer_id` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `modified_at` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_items
#

DROP TABLE IF EXISTS `db_items`;

CREATE TABLE `db_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create ITEM Code',
  `item_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `sku` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hsn` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `alert_qty` int(11) DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `lot_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `price` double(20,4) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `purchase_price` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `profit_margin` double(20,2) DEFAULT NULL,
  `sales_price` double(20,4) DEFAULT NULL,
  `stock` double(20,2) DEFAULT NULL,
  `item_image` text COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `discount_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount` double(20,2) DEFAULT NULL,
  `service_bit` int(11) DEFAULT '0',
  `seller_points` double(20,2) DEFAULT '0.00',
  `custom_barcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `item_group` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `child_bit` int(11) DEFAULT '0',
  `mrp` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_items_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=242 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (1, 2, 1, 'SHO0001', '6147-G1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '42.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '06:41:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (2, 2, 2, 'SHO0002', '2289-333T', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '41.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:48:27 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (3, 2, 3, 'SHO0003', 'F89725-284', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '26.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:50:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (4, 2, 4, 'SHO0004', '135-72', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '34.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:54:11 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (5, 2, 5, 'SHO0005', '0855-190', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '33.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:55:18 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (6, 2, 6, 'SHO0006', '135-77', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '38.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:56:55 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (7, 2, 7, 'SHO0007', '136-92', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '35.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:59:42 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (8, 2, 8, 'SHO0008', 'M1-12', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '29.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:02:06 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (9, 2, 9, 'SHO0009', 'M1-11', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '7.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:03:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (10, 2, 10, 'SHO0010', 'M1-2', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '35.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:04:07 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (11, 2, 11, 'SHO0011', 'M1-4', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '32.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:05:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (12, 2, 12, 'SHO0012', 'M1-5', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '50.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:06:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (13, 2, 13, 'SHO0013', 'M1-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '19.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:08:34 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (14, 2, 14, 'SHO0014', 'F053986-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '40.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:09:45 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (15, 2, 15, 'SHO0015', 'M1-7', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '38.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:12:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (16, 2, 16, 'SHO0016', '6147-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '47.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:14:15 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (17, 2, 17, 'SHO0017', 'FD6466-66', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '44.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:15:28 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (18, 2, 18, 'SHO0018', 'M1-3', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:16:34 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (19, 2, 19, 'SHO0019', 'GN242-638', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:18:21 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (20, 2, 20, 'SHO0020', 'GN242-692', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '12.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:19:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (21, 2, 21, 'SHO0021', '8441-7', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '31.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:20:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (22, 2, 22, 'SHO0022', 'M1-9', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '33.33', '4.0000', '44.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:23:31 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (23, 2, 23, 'SHO0023', '8441-94', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '38.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:25:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (24, 2, 24, 'SHO0024', '8441-4', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '46.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:26:13 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (25, 2, 25, 'SHO0025', '9252-D51', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '39.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:27:04 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (26, 2, 26, 'SHO0026', '9252-10', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '49.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:27:43 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (27, 2, 27, 'SHO0027', '9252-A15', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '46.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:28:29 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (28, 2, 28, 'SHO0028', '8181-D90', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '33.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:29:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (29, 2, 29, 'SHO0029', '8441-1', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '54.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:30:11 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (30, 2, 30, 'SHO0030', '8181-G1', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '41.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:31:07 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (31, 2, 31, 'SHO0031', '8441-G1', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '28.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:32:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (32, 2, 32, 'SHO0032', 'M1-10', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '37.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:34:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (33, 2, 33, 'SHO0033', 'M1-1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '18.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:35:18 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (34, 2, 34, 'SHO0034', 'A09557', 54, '', '', 1, 0, 0, NULL, NULL, '4.8500', 151, '4.8500', 'Inclusive', '40.00', '7.0000', '137.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:43:59 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (35, 2, 35, 'SHO0035', '1281', 54, '', '', 1, 0, 0, NULL, NULL, '4.9500', 151, '4.9500', 'Inclusive', '41.41', '7.0000', '68.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:46:21 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (36, 2, 36, 'SHO0036', 'KV-02', 54, '', '', 1, 0, 0, NULL, NULL, '3.9700', 151, '3.9700', 'Inclusive', '76.32', '7.0000', '140.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:47:52 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (37, 2, 37, 'SHO0037', 'QS5571', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '6.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:52:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (38, 2, 38, 'SHO0038', 'R8621-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '11.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:53:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (39, 2, 39, 'SHO0039', 'CMF36072-145A', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '27.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:56:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (40, 2, 40, 'SHO0040', 'QGQ-210', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '3.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:57:45 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (41, 2, 41, 'SHO0041', 'MY2056-2', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '46.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:58:50 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (42, 2, 42, 'SHO0042', 'MY3700-3', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '100.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:00:14 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (43, 2, 43, 'SHO0043', 'MY3700-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '117.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:02:38 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (44, 2, 44, 'SHO0044', 'LX6095-17', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:04:43 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (45, 2, 45, 'SHO0045', 'LX9698', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:06:29 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (46, 2, 46, 'SHO0046', 'LX2041-5', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '11.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:07:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (47, 2, 47, 'SHO0047', 'M2273-16', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '22.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:08:54 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (48, 2, 48, 'SHO0048', '2273-1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '30.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:09:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (49, 2, 49, 'SHO0049', '23041-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '88.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:11:39 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (50, 2, 50, 'SHO0050', '2944', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '26.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:12:20 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (51, 2, 51, 'SHO0051', '7793-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '22.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:12:54 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (52, 2, 52, 'SHO0052', '58825-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '76.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:13:59 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (53, 2, 53, 'SHO0053', 'A90458-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '76.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:15:10 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (54, 2, 54, 'SHO0054', 'A8602', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '29.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:17:15 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (55, 2, 55, 'SHO0055', '8042', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '17.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:18:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (56, 2, 56, 'SHO0056', '8602', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '10.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:19:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (57, 2, 57, 'SHO0057', '1098-3', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '26.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:20:15 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (58, 2, 58, 'SHO0058', '2577', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '52.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:20:49 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (59, 2, 59, 'SHO0059', '90458', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '7.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:22:19 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (60, 2, 60, 'SHO0060', '998', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '108.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:23:48 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (61, 2, 61, 'SHO0061', '8438-2', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '44.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:24:29 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (62, 2, 62, 'SHO0062', 'SP8108', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '97.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:25:42 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (63, 2, 63, 'SHO0063', 'SP8109', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '110.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:28:42 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (64, 2, 64, 'SHO0064', 'BL70-305', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '45.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:30:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (65, 2, 65, 'SHO0065', '5722-5', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '56.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:31:10 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (66, 2, 66, 'SHO0066', '52269', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '26.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:32:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (67, 2, 67, 'SHO0067', 'YC-452', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '43.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:33:40 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (68, 2, 68, 'SHO0068', '3317-3', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '13.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:34:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (69, 2, 69, 'SHO0069', 'TL-911', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '81.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:35:12 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (70, 2, 70, 'SHO0070', 'Z68141', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '34.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:40:49 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (71, 2, 71, 'SHO0071', '2877', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '4.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:43:39 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (72, 2, 72, 'SHO0072', '8625-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '15.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:45:02 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (73, 2, 73, 'SHO0073', '0365-0910', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '46.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:45:51 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (74, 2, 74, 'SHO0074', 'ME1507', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '41.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:46:33 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (75, 2, 75, 'SHO0075', 'YC-442', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '17.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:56:46 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (76, 2, 76, 'SHO0076', '30-432', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:57:16 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (77, 2, 77, 'SHO0077', '30-428', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '21.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:57:56 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (78, 2, 78, 'SHO0078', '2020-2', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '30.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:58:48 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (79, 2, 79, 'SHO0079', 'SH-12', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '18.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:07:26 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (80, 2, 80, 'SHO0080', 'ME1501', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '60.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:08:59 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (81, 2, 81, 'SHO0081', 'ME1514', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '84.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:10:01 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (82, 2, 82, 'SHO0082', 'ME1502', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '82.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:11:03 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (83, 2, 83, 'SHO0083', '8895-68', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '22.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:12:04 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (84, 2, 84, 'SHO0084', '10041', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '43.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:13:02 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (85, 2, 85, 'SHO0085', '0909-25', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:14:48 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (86, 2, 86, 'SHO0086', '0909-27', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '7.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:15:44 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (87, 2, 87, 'SHO0087', '30-406', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '36.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:17:11 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (88, 2, 88, 'SHO0088', '80421-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '55.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:18:41 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (89, 2, 89, 'SHO0089', 'H38', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', '36.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:19:23 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (90, 2, 90, 'SHO0090', '6296-12', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '15.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:20:12 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (91, 2, 91, 'SHO0091', '15290', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '25.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:20:59 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (92, 2, 92, 'SHO0092', '6038', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '8.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:22:32 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (93, 2, 93, 'SHO0093', '2256-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '35.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:23:11 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (94, 2, 94, 'SHO0094', '37057-1', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '26.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:24:10 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (95, 2, 95, 'SHO0095', '37057', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '14.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:24:51 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (96, 2, 96, 'SHO0096', '91349-18', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '40.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:26:28 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (97, 2, 97, 'SHO0097', '2262-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '9.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:29:17 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (98, 2, 98, 'SHO0098', '2321', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '38.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:29:57 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (99, 2, 99, 'SHO0099', '5018', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '17.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:30:52 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (100, 2, 100, 'SHO0100', '8535-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '33.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:31:54 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (101, 2, 101, 'SHO0101', '8359', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '13.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:32:39 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (102, 2, 102, 'SHO0102', '8101-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '31.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:33:32 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (103, 2, 103, 'SHO0103', '52323', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '15.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:34:26 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (104, 2, 104, 'SHO0104', '09557', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '15.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:35:16 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (105, 2, 105, 'SHO0105', '8520', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '39.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:35:44 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (106, 2, 106, 'SHO0106', '7769-11', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '10.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:36:21 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (107, 2, 107, 'SHO0107', 'd1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '70.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:40:13 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (108, 2, 108, 'SHO0108', 'd2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '25.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:41:02 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (109, 2, 109, 'SHO0109', 'D3', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '42.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:41:40 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (110, 2, 110, 'SHO0110', 'D4', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '35.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:42:16 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (111, 2, 111, 'SHO0111', 'D8', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '15.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:42:52 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (112, 2, 112, 'SHO0112', 'D9', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '23.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:43:30 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (113, 2, 113, 'SHO0113', 'D10', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '30.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:44:07 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (114, 2, 114, 'SHO0114', 'D11', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '14.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:44:43 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (115, 2, 115, 'SHO0115', 'D14', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '5.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:45:18 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (116, 2, 116, 'SHO0116', 'D15', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '36.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:46:00 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (117, 2, 117, 'SHO0117', 'D7', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '9.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:46:47 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (118, 2, 118, 'SHO0118', 'D12', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '6.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:47:28 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (119, 2, 119, 'SHO0119', 'D16', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '12.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:48:07 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (120, 2, 120, 'SHO0120', 'D17', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '1.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:48:45 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (121, 2, 121, 'SHO0121', 'D18', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '16.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:50:46 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (122, 2, 122, 'SHO0122', 'D19', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '30.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:51:17 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (123, 2, 123, 'SHO0123', 'D20 FLAT', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '25.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:52:19 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (124, 2, 124, 'SHO0124', 'D23', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '27.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:52:57 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (125, 2, 125, 'SHO0125', 'D24', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '23.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:53:32 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (126, 2, 126, 'SHO0126', 'D6', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '10.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:54:27 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (127, 2, 127, 'SHO0127', 'D15 FLAT', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '23.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:55:12 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (128, 2, 128, 'SHO0128', 'D21', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '20.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:55:50 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (129, 2, 129, 'SHO0129', '1801', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:58:09 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (130, 2, 130, 'SHO0130', '90047', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '9.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:59:09 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (131, 2, 131, 'SHO0131', '9318-14', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '3.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:59:52 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (132, 2, 132, 'SHO0132', 'E3402', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '3.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:00:32 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (133, 2, 133, 'SHO0133', '52140-2', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:01:20 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (134, 2, 134, 'SHO0134', 'OB-52', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', '68.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:03:28 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (135, 2, 135, 'SHO0135', 'OB-51', 55, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', '39.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:04:04 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (136, 2, 136, 'SHO0136', 'OB-53', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', '51.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:04:50 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (137, 2, 137, 'SHO0137', '2412-145', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '86.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:05:23 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (138, 2, 138, 'SHO0138', 'ME1442', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '26.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '08:44:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (139, 2, 139, 'SHO0139', '30-256', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '08:46:14 pm', 'Liwa', NULL, 0, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (140, 2, 140, 'SHO0140', '30-255', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '17.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '08:48:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (141, 2, 141, 'SHO0141', 'lw96', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '28.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '08:50:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (142, 2, 142, 'SHO0142', 'QB-93', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '16.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:00:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (143, 2, 143, 'SHO0143', 'BK-480', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '15.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:01:49 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (144, 2, 144, 'SHO0144', '30-171', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '43.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:02:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (145, 2, 145, 'SHO0145', '0318-28', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '60.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:04:34 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (146, 2, 146, 'SHO0146', 'ME1477', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '19.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:05:33 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (147, 2, 147, 'SHO0147', '9263-4', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:06:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (148, 2, 148, 'SHO0148', 'S3377', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:07:22 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (149, 2, 149, 'SHO0149', '2123', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '17.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:08:13 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (150, 2, 150, 'SHO0150', '908-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:09:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (151, 2, 151, 'SHO0151', '518-1', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '0.00', '4.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:10:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (152, 2, 152, 'SHO0152', 'B6120', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '38.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:12:43 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (153, 2, 153, 'SHO0153', '6887-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:13:48 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (154, 2, 154, 'SHO0154', '60074-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '7.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:14:51 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (155, 2, 155, 'SHO0155', '58531-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '60.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:19:38 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (156, 2, 156, 'SHO0156', '2391', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:21:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (157, 2, 157, 'SHO0157', '810-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '11.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:22:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (158, 2, 158, 'SHO0158', '2022', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:22:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (159, 2, 159, 'SHO0159', '625-58', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '15.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:24:20 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (160, 2, 160, 'SHO0160', '90042', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '16.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:25:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (161, 2, 161, 'SHO0161', '90080', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '61.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:27:16 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (162, 2, 162, 'SHO0162', 'TL-752', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '20.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:28:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (163, 2, 163, 'SHO0163', '0365-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:29:35 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (164, 2, 164, 'SHO0164', '8758', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', '40.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:30:42 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (165, 2, 165, 'SHO0165', '3563-1', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', '40.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:31:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (166, 2, 166, 'SHO0166', '859', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '16.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:33:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (167, 2, 167, 'SHO0167', 'E3299', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:34:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (168, 2, 168, 'SHO0168', '52271', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '16.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:35:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (169, 2, 169, 'SHO0169', '025-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '22.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:36:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (170, 2, 170, 'SHO0170', 'M24614', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '14.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:37:12 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (171, 2, 171, 'SHO0171', '211', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '20.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:39:57 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (172, 2, 172, 'SHO0172', '3297', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '14.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:40:35 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (173, 2, 173, 'SHO0173', '2105', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:41:21 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (174, 2, 174, 'SHO0174', 'G693', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:44:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (175, 2, 175, 'SHO0175', 'G694', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:45:28 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (176, 2, 176, 'SHO0176', 'ZX-150', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '12.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:46:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (177, 2, 177, 'SHO0177', 'ZX-151', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '2.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:49:14 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (178, 2, 178, 'SHO0178', '8287', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '2.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:50:10 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (179, 2, 179, 'SHO0179', 'L24685', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '13.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:50:59 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (180, 2, 180, 'SHO0180', '8277', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '19.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:52:16 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (181, 2, 181, 'SHO0181', 'B2615', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:53:08 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (182, 2, 182, 'SHO0182', 'Y2316', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:53:56 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (183, 2, 183, 'SHO0183', 'A-7', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '17.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:54:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (184, 2, 184, 'SHO0184', 'A-4', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '11.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:55:43 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (185, 2, 185, 'SHO0185', '7569-16', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:56:50 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (186, 2, 186, 'SHO0186', '5500', 53, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '0.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:58:14 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (187, 2, 187, 'SHO0187', '6600', 53, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '0.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:59:01 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (188, 2, 188, 'SHO0188', '7700', 53, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '0.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:59:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (189, 2, 189, 'SHO0189', '8800', 53, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '0.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:00:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (190, 2, 190, 'SHO0190', 'MZAF-23', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '14.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:01:31 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (191, 2, 191, 'SHO0191', 'HT-90', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '15.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:10:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (192, 2, 192, 'SHO0192', '8586', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '30.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:11:19 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (193, 2, 193, 'SHO0193', 'A8588-10', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '25.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:12:05 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (194, 2, 194, 'SHO0194', '3312', 54, '', '', 1, 0, 0, NULL, NULL, '5.5000', 151, '5.5000', 'Inclusive', '36.36', '7.5000', '20.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:13:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (195, 2, 195, 'SHO0195', '68546', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:14:08 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (196, 2, 196, 'SHO0196', 'JX-08', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:14:56 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (197, 2, 197, 'SHO0197', 'MY0910-15', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '12.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:15:38 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (198, 2, 198, 'SHO0198', 'HT-62', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '14.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:16:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (199, 2, 199, 'SHO0199', 'FC008', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '9.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:16:59 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (200, 2, 200, 'SHO0200', '37057-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:17:53 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (201, 2, 201, 'SHO0201', '55-31', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '19.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:18:40 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (202, 2, 202, 'SHO0202', '8968', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:19:23 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (203, 2, 203, 'SHO0203', 'JYN-06', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '7.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:20:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (204, 2, 204, 'SHO0204', 'CM8907-4', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:21:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (205, 2, 205, 'SHO0205', '2032-10', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:22:14 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (206, 2, 206, 'SHO0206', '8520', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '9.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:23:22 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (207, 2, 207, 'SHO0207', 'YJ302', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '20.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:24:13 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (208, 2, 208, 'SHO0208', '5016', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '45.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:25:19 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (209, 2, 209, 'SHO0209', '21002', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '7.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:26:16 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (210, 2, 210, 'SHO0210', '30578', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '2.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:27:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (211, 2, 211, 'SHO0211', '3085', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:29:10 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (212, 2, 212, 'SHO0212', '002#', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:30:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (213, 2, 213, 'SHO0213', 'E47', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:32:53 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (214, 2, 214, 'SHO0214', 'E43', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '2.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:33:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (215, 2, 215, 'SHO0215', '4328Q', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:34:45 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (216, 2, 216, 'SHO0216', 'E3', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:35:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (217, 2, 217, 'SHO0217', 'E10', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:36:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (218, 2, 218, 'SHO0218', 'C183', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:37:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (219, 2, 219, 'SHO0219', '4045', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:38:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (220, 2, 220, 'SHO0220', 'E225', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:40:02 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (221, 2, 221, 'SHO0221', 'HD-088', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '9.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:41:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (222, 2, 222, 'SHO0222', '2131', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:42:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (223, 2, 223, 'SHO0223', '24756', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:43:36 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (224, 2, 224, 'SHO0224', '5001', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:44:47 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (225, 2, 225, 'SHO0225', '8744', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '2.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:45:53 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (226, 2, 226, 'SHO0226', 'PIN2#', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '9.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:48:57 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (227, 2, 227, 'SHO0227', '2133', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '28.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:50:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (228, 2, 228, 'SHO0228', '4009', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:51:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (229, 2, 229, 'SHO0229', '2065', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:52:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (230, 2, 230, 'SHO0230', 'GU055', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:53:15 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (231, 2, 231, 'SHO0231', '12065', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '14.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:54:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (232, 2, 232, 'SHO0232', '2340', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '2.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:54:39 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (233, 2, 233, 'SHO0233', '1140', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:55:22 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (234, 2, 234, 'SHO0234', 'KL-22', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:56:04 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (235, 2, 235, 'SHO0235', '30683', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '7.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:56:45 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (236, 2, 236, 'SHO0236', 'A068', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '34.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:57:21 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (237, 2, 237, 'SHO0237', 'GU59567', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '16.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:58:08 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (238, 2, 238, 'SHO0238', '2066', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:58:49 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (239, 2, 239, 'SHO0239', '6029', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:59:31 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (240, 2, 240, 'SHO0240', '5015', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '24.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '11:00:16 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (241, 2, 241, 'SHO0241', '6458-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '34.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '11:02:01 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');


#
# TABLE STRUCTURE FOR: db_languages
#

DROP TABLE IF EXISTS `db_languages`;

CREATE TABLE `db_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (1, 'English', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (2, 'Russian', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (3, 'Spanish', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (4, 'Arabic', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (5, 'Bangla', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (6, 'French', 0);


#
# TABLE STRUCTURE FOR: db_package
#

DROP TABLE IF EXISTS `db_package`;

CREATE TABLE `db_package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `package_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `package_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `package_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `monthly_price` double(20,2) DEFAULT NULL,
  `annual_price` double(20,2) DEFAULT NULL,
  `trial_days` int(11) DEFAULT NULL,
  `max_users` int(11) DEFAULT NULL,
  `max_items` int(11) DEFAULT NULL,
  `max_invoices` int(11) DEFAULT NULL,
  `max_warehouses` int(11) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_package_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_paymenttypes
#

DROP TABLE IF EXISTS `db_paymenttypes`;

CREATE TABLE `db_paymenttypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_paymenttypes_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (36, 2, 'Cash', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (37, 2, 'Visa', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (39, 2, 'Bank Transfer', 1);


#
# TABLE STRUCTURE FOR: db_paypal
#

DROP TABLE IF EXISTS `db_paypal`;

CREATE TABLE `db_paypal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sandbox` int(11) DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_paypal_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_paypal` (`id`, `store_id`, `sandbox`, `email`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_paypalpaylog
#

DROP TABLE IF EXISTS `db_paypalpaylog`;

CREATE TABLE `db_paypalpaylog` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `txn_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `payment_gross` float(10,2) NOT NULL,
  `currency_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `payer_email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `payment_status` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_permissions
#

DROP TABLE IF EXISTS `db_permissions`;

CREATE TABLE `db_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `permissions` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_permissions_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8203 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4414, 1, 17, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4415, 1, 17, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4416, 1, 17, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4417, 1, 17, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4418, 1, 17, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4419, 1, 17, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4420, 1, 17, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4421, 1, 17, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4422, 1, 17, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4423, 1, 17, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4424, 1, 17, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4425, 1, 17, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4426, 1, 17, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4427, 1, 17, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4428, 1, 17, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4429, 1, 17, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4430, 1, 17, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4431, 1, 17, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4432, 1, 17, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4433, 1, 17, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4434, 1, 17, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4435, 1, 17, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4436, 1, 17, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4437, 1, 17, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4438, 1, 17, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4439, 1, 17, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4440, 1, 17, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4441, 1, 17, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4442, 1, 17, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4443, 1, 17, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4444, 1, 17, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4445, 1, 17, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4446, 1, 17, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4447, 1, 17, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4448, 1, 17, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4449, 1, 17, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4450, 1, 17, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4451, 1, 17, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4452, 1, 17, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4453, 1, 17, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4454, 1, 17, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4455, 1, 17, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4456, 1, 17, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4457, 1, 17, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4458, 1, 17, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4459, 1, 17, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4460, 1, 17, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4461, 1, 17, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4462, 1, 17, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4463, 1, 17, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4464, 1, 17, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4465, 1, 17, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4466, 1, 17, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4467, 1, 17, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4468, 1, 17, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4469, 1, 17, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4470, 1, 17, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4471, 1, 17, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4472, 1, 17, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4473, 1, 17, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4474, 1, 17, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4475, 1, 17, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4476, 1, 17, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4477, 1, 17, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4478, 1, 17, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4479, 1, 17, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4480, 1, 17, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4481, 1, 17, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4482, 1, 17, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4483, 1, 17, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4484, 1, 17, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4485, 1, 17, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4486, 1, 17, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4487, 1, 17, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4488, 1, 17, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4489, 1, 17, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4490, 1, 17, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4491, 1, 17, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4492, 1, 18, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4493, 1, 18, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4494, 1, 18, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4495, 1, 18, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4496, 1, 18, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4497, 1, 18, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4498, 1, 18, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4499, 1, 18, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4500, 1, 18, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4501, 1, 18, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4502, 1, 18, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4503, 1, 18, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4504, 1, 18, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4505, 1, 18, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4506, 1, 18, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4507, 1, 18, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4508, 1, 18, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4509, 1, 18, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4510, 1, 18, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4511, 1, 18, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4512, 1, 18, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4513, 1, 18, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4514, 1, 18, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4515, 1, 18, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4516, 1, 18, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4517, 1, 18, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4518, 1, 18, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4519, 1, 18, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4520, 1, 18, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4521, 1, 18, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4522, 1, 18, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4523, 1, 18, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4524, 1, 18, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4525, 1, 18, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4526, 1, 18, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4527, 1, 18, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4528, 1, 18, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4529, 1, 18, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4530, 1, 18, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4531, 1, 18, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4532, 1, 18, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4533, 1, 18, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4534, 1, 18, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4535, 1, 18, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4536, 1, 18, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4537, 1, 18, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4538, 1, 18, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4539, 1, 18, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4540, 1, 18, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4541, 1, 18, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4542, 1, 18, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4543, 1, 18, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4544, 1, 18, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4545, 1, 18, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4546, 1, 18, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4547, 1, 18, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4548, 1, 18, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4549, 1, 18, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4550, 1, 18, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4551, 1, 18, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4552, 1, 18, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4553, 1, 18, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4554, 1, 18, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4555, 1, 18, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4556, 1, 18, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4557, 1, 18, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4558, 1, 18, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4559, 1, 18, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4560, 1, 18, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4561, 1, 18, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4562, 1, 18, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4563, 1, 18, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4564, 1, 18, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4565, 1, 18, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4566, 1, 18, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4567, 1, 18, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4568, 1, 18, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4569, 1, 18, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4570, 1, 18, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4571, 1, 18, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4572, 1, 18, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4573, 1, 18, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4574, 1, 18, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4575, 1, 18, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4576, 1, 18, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4577, 1, 18, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4578, 1, 18, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4579, 1, 18, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4580, 1, 18, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5818, 1, 2, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5819, 1, 2, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5820, 1, 2, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5821, 1, 2, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5822, 1, 2, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5823, 1, 2, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5824, 1, 2, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5825, 1, 2, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5826, 1, 2, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5827, 1, 2, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5828, 1, 2, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5829, 1, 2, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5830, 1, 2, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5831, 1, 2, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5832, 1, 2, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5833, 1, 2, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5834, 1, 2, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5835, 1, 2, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5836, 1, 2, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5837, 1, 2, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5838, 1, 2, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5839, 1, 2, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5840, 1, 2, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5841, 1, 2, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5842, 1, 2, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5843, 1, 2, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5844, 1, 2, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5845, 1, 2, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5846, 1, 2, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5847, 1, 2, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5848, 1, 2, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5849, 1, 2, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5850, 1, 2, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5851, 1, 2, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5852, 1, 2, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5853, 1, 2, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5854, 1, 2, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5855, 1, 2, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5856, 1, 2, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5857, 1, 2, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5858, 1, 2, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5859, 1, 2, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5860, 1, 2, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5861, 1, 2, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5862, 1, 2, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5863, 1, 2, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5864, 1, 2, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5865, 1, 2, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5866, 1, 2, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5867, 1, 2, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5868, 1, 2, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5869, 1, 2, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5870, 1, 2, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5871, 1, 2, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5872, 1, 2, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5873, 1, 2, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5874, 1, 2, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5875, 1, 2, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5876, 1, 2, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5877, 1, 2, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5878, 1, 2, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5879, 1, 2, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5880, 1, 2, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5881, 1, 2, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5882, 1, 2, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5883, 1, 2, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5884, 1, 2, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5885, 1, 2, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5886, 1, 2, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5887, 1, 2, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5888, 1, 2, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5889, 1, 2, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5890, 1, 2, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5891, 1, 2, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5892, 1, 2, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5893, 1, 2, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5894, 1, 2, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5895, 1, 2, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5896, 1, 2, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5897, 1, 2, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5898, 1, 2, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5899, 1, 2, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5900, 1, 2, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5901, 1, 2, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5902, 1, 2, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5903, 1, 2, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5904, 1, 2, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5905, 1, 2, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5906, 1, 2, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5907, 1, 2, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5908, 1, 2, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5909, 1, 2, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5910, 1, 2, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5911, 1, 2, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5912, 1, 2, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5913, 1, 2, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5914, 1, 2, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5915, 1, 2, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5916, 1, 2, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5917, 1, 2, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5918, 1, 2, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5919, 1, 2, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5920, 1, 2, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5921, 1, 2, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5922, 1, 2, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5923, 1, 2, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5924, 1, 2, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5925, 1, 2, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5926, 1, 2, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5927, 1, 2, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5928, 1, 2, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5929, 1, 2, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5930, 1, 2, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5931, 1, 2, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5932, 1, 2, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5933, 1, 2, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5934, 1, 2, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5935, 1, 2, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5936, 1, 2, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5937, 1, 2, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5938, 1, 2, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5939, 1, 2, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5940, 1, 2, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5941, 1, 2, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5942, 1, 2, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5943, 1, 2, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5944, 1, 2, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5945, 1, 2, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5946, 1, 2, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5947, 1, 2, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5948, 1, 2, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5949, 1, 2, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5950, 1, 2, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5951, 1, 2, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5952, 1, 2, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5953, 1, 2, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5954, 1, 2, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5955, 1, 2, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5956, 1, 2, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5957, 1, 2, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5958, 1, 2, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5959, 1, 2, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5960, 1, 2, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5961, 1, 2, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5962, 1, 2, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5963, 1, 2, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5964, 1, 2, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5965, 1, 2, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5966, 1, 2, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5967, 1, 2, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5968, 1, 2, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5969, 1, 2, 'subscription');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5970, 1, 2, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5971, 1, 2, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5972, 1, 2, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5973, 1, 2, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5974, 1, 2, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5975, 1, 2, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5976, 1, 2, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5977, 1, 2, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5978, 1, 2, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5999, 2, 28, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6000, 2, 28, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6001, 2, 28, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6002, 2, 28, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6011, 2, 29, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6012, 2, 29, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6013, 2, 29, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6014, 2, 29, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6015, 2, 29, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6016, 2, 29, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6017, 2, 29, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6018, 2, 29, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6019, 2, 29, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6020, 2, 29, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6021, 2, 29, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6022, 2, 29, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6023, 2, 29, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6024, 2, 29, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6025, 2, 29, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6026, 2, 29, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6027, 2, 29, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6028, 2, 29, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6029, 2, 29, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6030, 2, 29, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6031, 2, 29, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6032, 2, 29, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6033, 2, 29, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6034, 2, 29, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6035, 2, 29, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6036, 2, 29, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6037, 2, 29, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6038, 2, 29, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6039, 2, 29, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6040, 2, 29, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6041, 2, 29, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6042, 2, 29, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6043, 2, 29, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6044, 2, 29, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6045, 2, 29, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6046, 2, 29, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6047, 2, 29, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6048, 2, 29, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6049, 2, 29, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6050, 2, 29, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6051, 2, 29, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6052, 2, 29, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6053, 2, 29, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6054, 2, 29, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6055, 2, 29, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6056, 2, 29, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6057, 2, 29, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6058, 2, 29, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6059, 2, 29, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6060, 2, 29, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6061, 2, 29, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6062, 2, 29, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6063, 2, 29, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6064, 2, 29, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6065, 2, 29, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6066, 2, 29, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6067, 2, 29, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6068, 2, 29, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6069, 2, 29, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6070, 2, 29, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6071, 2, 29, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6072, 2, 29, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6073, 2, 29, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6074, 2, 29, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6075, 2, 29, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6076, 2, 29, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6077, 2, 29, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6078, 2, 29, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6079, 2, 29, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6080, 2, 29, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6081, 2, 29, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6082, 2, 29, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6083, 2, 29, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6084, 2, 29, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6085, 2, 29, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6086, 2, 29, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6087, 2, 29, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6088, 2, 29, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6089, 2, 29, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6090, 2, 29, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6091, 2, 29, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6092, 2, 29, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6093, 2, 29, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6094, 2, 29, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6095, 2, 29, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6096, 2, 29, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6097, 2, 29, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6098, 2, 29, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6099, 2, 29, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6100, 2, 29, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6101, 2, 29, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6102, 2, 29, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6103, 2, 29, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6104, 2, 29, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6105, 2, 29, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6106, 2, 29, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6107, 2, 29, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6108, 2, 29, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6109, 2, 29, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6110, 2, 29, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6111, 2, 29, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6112, 2, 29, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6113, 2, 29, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6114, 2, 29, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6115, 2, 29, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6116, 2, 29, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6117, 2, 29, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6118, 2, 29, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6119, 2, 29, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6120, 2, 29, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6121, 2, 29, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6122, 2, 29, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6123, 2, 29, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6124, 2, 29, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6125, 2, 29, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6126, 2, 29, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6127, 2, 29, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6128, 2, 29, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6129, 2, 29, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6130, 2, 29, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6131, 2, 29, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6132, 2, 29, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6133, 2, 29, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6134, 2, 29, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6135, 2, 29, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6136, 2, 29, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6137, 2, 29, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6138, 2, 29, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6139, 2, 29, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6140, 2, 29, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6141, 2, 29, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6142, 2, 29, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6143, 2, 29, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6144, 2, 29, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6145, 2, 29, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6146, 2, 29, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6147, 2, 29, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6148, 2, 29, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6149, 2, 29, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6150, 2, 29, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6151, 2, 29, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6152, 2, 29, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6153, 2, 29, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6154, 2, 29, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6155, 2, 29, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6156, 2, 29, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6157, 2, 29, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6158, 2, 29, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6159, 2, 29, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6160, 2, 29, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6161, 2, 29, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6162, 2, 29, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6163, 2, 29, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6164, 2, 29, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6165, 2, 29, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6166, 2, 29, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6167, 2, 29, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6168, 2, 29, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6169, 2, 29, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6170, 2, 29, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6179, 1, 2, 'gstr_1_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6180, 1, 2, 'gstr_2_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6181, 1, 2, 'delivery_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6182, 1, 2, 'load_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6183, 1, 2, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6184, 1, 2, 'customer_orders_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7679, 2, 5, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7680, 2, 5, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7681, 2, 5, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7682, 2, 5, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7683, 2, 5, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7684, 2, 5, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7685, 2, 5, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7686, 2, 5, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7687, 2, 5, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7688, 2, 5, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7689, 2, 5, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7690, 2, 5, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7691, 2, 5, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7692, 2, 5, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7693, 2, 5, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7694, 2, 5, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7695, 2, 5, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7696, 2, 5, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7697, 2, 5, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7698, 2, 5, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7699, 2, 5, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7861, 2, 4, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7862, 2, 4, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7863, 2, 4, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7864, 2, 4, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7865, 2, 4, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7866, 2, 4, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7867, 2, 4, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7868, 2, 4, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7869, 2, 4, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7870, 2, 4, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7871, 2, 4, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7872, 2, 4, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7873, 2, 4, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7874, 2, 4, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7875, 2, 4, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7876, 2, 4, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7877, 2, 4, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7878, 2, 4, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7879, 2, 4, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7880, 2, 4, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7881, 2, 4, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7882, 2, 4, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7883, 2, 4, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7884, 2, 4, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7885, 2, 4, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7886, 2, 4, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7887, 2, 4, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7888, 2, 4, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7889, 2, 4, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7890, 2, 4, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7891, 2, 4, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7892, 2, 4, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7893, 2, 4, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7894, 2, 4, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7895, 2, 4, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7896, 2, 4, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7897, 2, 4, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7898, 2, 4, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7899, 2, 4, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7900, 2, 4, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7901, 2, 4, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7902, 2, 4, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7903, 2, 4, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7904, 2, 4, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7905, 2, 4, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7906, 2, 4, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7907, 2, 4, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7908, 2, 4, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7909, 2, 4, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7910, 2, 4, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7911, 2, 4, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7912, 2, 4, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7913, 2, 4, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7914, 2, 4, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7915, 2, 4, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7916, 2, 4, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7917, 2, 4, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7918, 2, 4, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7919, 2, 4, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7920, 2, 4, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7921, 2, 4, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7922, 2, 4, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7923, 2, 4, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7924, 2, 4, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7925, 2, 4, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7926, 2, 4, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7927, 2, 4, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7928, 2, 4, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7929, 2, 4, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7930, 2, 4, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7931, 2, 4, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7932, 2, 4, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7933, 2, 4, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7934, 2, 4, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7935, 2, 4, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7936, 2, 4, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7937, 2, 4, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7938, 2, 4, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7939, 2, 4, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7940, 2, 4, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7941, 2, 4, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7942, 2, 4, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7943, 2, 4, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7944, 2, 4, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7945, 2, 4, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7946, 2, 4, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7947, 2, 4, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7948, 2, 4, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7949, 2, 4, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7950, 2, 4, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7951, 2, 4, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7952, 2, 4, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7953, 2, 4, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7954, 2, 4, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7955, 2, 4, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7956, 2, 4, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7957, 2, 4, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7958, 2, 4, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7959, 2, 4, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7960, 2, 4, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7961, 2, 4, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7962, 2, 4, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7963, 2, 4, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7964, 2, 4, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7965, 2, 4, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7966, 2, 4, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7967, 2, 4, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7968, 2, 4, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7969, 2, 4, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7970, 2, 4, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7971, 2, 4, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7972, 2, 4, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7973, 2, 4, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7974, 2, 4, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7975, 2, 4, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7976, 2, 4, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7977, 2, 4, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7978, 2, 4, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7979, 2, 4, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7980, 2, 4, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7981, 2, 4, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7982, 2, 4, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7983, 2, 4, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7984, 2, 4, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7985, 2, 4, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7986, 2, 4, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7987, 2, 4, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7988, 2, 4, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7989, 2, 4, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7990, 2, 4, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7991, 2, 4, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7992, 2, 4, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7993, 2, 4, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7994, 2, 4, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7995, 2, 4, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7996, 2, 4, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7997, 2, 4, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7998, 2, 4, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7999, 2, 4, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8000, 2, 4, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8001, 2, 4, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8002, 2, 4, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8003, 2, 4, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8004, 2, 4, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8005, 2, 4, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8006, 2, 4, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8007, 2, 4, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8008, 2, 4, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8009, 2, 4, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8010, 2, 4, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8011, 2, 4, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8012, 2, 4, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8013, 2, 4, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8014, 2, 4, 'gstr_1_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8015, 2, 4, 'gstr_2_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8016, 2, 4, 'customer_orders_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8017, 2, 4, 'load_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8018, 2, 4, 'delivery_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8019, 2, 4, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8143, 2, 3, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8144, 2, 3, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8145, 2, 3, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8146, 2, 3, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8147, 2, 3, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8148, 2, 3, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8149, 2, 3, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8150, 2, 3, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8151, 2, 3, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8152, 2, 3, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8153, 2, 3, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8154, 2, 3, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8155, 2, 3, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8156, 2, 3, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8157, 2, 3, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8158, 2, 3, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8159, 2, 3, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8160, 2, 3, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8161, 2, 3, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8162, 2, 3, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8163, 2, 3, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8164, 2, 3, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8165, 2, 3, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8166, 2, 3, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8167, 2, 3, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8168, 2, 3, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8169, 2, 3, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8170, 2, 3, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8171, 2, 3, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8172, 2, 3, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8173, 2, 3, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8174, 2, 3, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8175, 2, 3, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8176, 2, 3, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8177, 2, 3, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8178, 2, 3, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8179, 2, 3, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8180, 2, 3, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8181, 2, 3, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8182, 2, 3, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8183, 2, 3, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8184, 2, 3, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8185, 2, 3, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8186, 2, 3, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8187, 2, 3, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8188, 2, 3, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8189, 2, 3, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8190, 2, 3, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8191, 2, 3, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8192, 2, 3, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8193, 2, 3, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8194, 2, 3, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8195, 2, 3, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8196, 2, 3, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8197, 2, 3, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8198, 2, 3, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8199, 2, 3, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8200, 2, 3, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8201, 2, 3, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8202, 2, 3, 'show_purchase_price');


#
# TABLE STRUCTURE FOR: db_purchase
#

DROP TABLE IF EXISTS `db_purchase`;

CREATE TABLE `db_purchase` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Purchase Code',
  `purchase_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `purchase_note` text COLLATE utf8_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'Purchase return raised',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchase_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchase_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (1, 2, 4, 1, 'PU/20250929/PO0001', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '18.0000', NULL, '18.0000', '', 'Unpaid', '0.0000', '2025-09-29', '04:54:22 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (2, 2, 4, 2, 'PU/20250929/PO0002', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '24.0000', NULL, '24.0000', '', 'Unpaid', '0.0000', '2025-09-29', '04:56:02 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (3, 2, 4, 3, 'PU/20250929/PO0003', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '150.0000', NULL, '150.0000', '', 'Unpaid', '0.0000', '2025-09-29', '04:57:39 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (4, 2, 4, 4, 'PU/20250929/PO0004', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '190.0000', NULL, '190.0000', '', 'Unpaid', '0.0000', '2025-09-29', '05:02:05 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (5, 2, 4, 5, 'PU/20250929/PO0005', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1810.2900', NULL, '1810.2900', '', 'Unpaid', '0.0000', '2025-09-29', '05:20:55 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (6, 2, 4, 6, 'PU/20250929/PO0006', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '502.0000', NULL, '502.0000', '', 'Unpaid', '0.0000', '2025-09-29', '05:24:03 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (7, 2, 4, 7, 'PU/20250929/PO0007', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '688.0000', NULL, '688.0000', '', 'Unpaid', '0.0000', '2025-09-29', '05:40:11 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (8, 2, 4, 8, 'PU/20250929/PO0008', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '400.0000', NULL, '400.0000', '', 'Unpaid', '0.0000', '2025-09-29', '05:49:11 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (9, 2, 4, 9, 'PU/20250929/PO0009', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '968.0000', NULL, '968.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:02:45 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (10, 2, 4, 10, 'PU/20250929/PO0010', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1077.0000', NULL, '1077.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:14:41 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (11, 2, 4, 11, 'PU/20250929/PO0011', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '502.0000', NULL, '502.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:22:05 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (12, 2, 4, 12, 'PU/20250929/PO0012', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '385.0000', NULL, '385.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:31:58 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (13, 2, 4, 13, 'PU/20250929/PO0013', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '907.0000', NULL, '907.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:36:06 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);


#
# TABLE STRUCTURE FOR: db_purchaseitems
#

DROP TABLE IF EXISTS `db_purchaseitems`;

CREATE TABLE `db_purchaseitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `purchase_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `purchase_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchaseitems_ibfk_1` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (88, 2, 1, 'Received', 19, '6.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (89, 2, 2, 'Received', 13, '8.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (90, 2, 3, 'Received', 33, '8.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (91, 2, 3, 'Received', 7, '12.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (92, 2, 3, 'Received', 65, '26.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '78.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (93, 2, 4, 'Received', 83, '11.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '22.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (94, 2, 4, 'Received', 10, '22.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '66.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (95, 2, 4, 'Received', 146, '9.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (96, 2, 4, 'Received', 161, '28.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '84.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (97, 2, 5, 'Received', 35, '32.00', '4.9500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.9500', '158.4000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (98, 2, 5, 'Received', 34, '89.00', '4.8500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.8500', '431.6500', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (99, 2, 5, 'Received', 105, '30.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (100, 2, 5, 'Received', 52, '34.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '170.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (101, 2, 5, 'Received', 36, '92.00', '3.9700', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.9700', '365.2400', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (102, 2, 5, 'Received', 49, '53.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '265.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (103, 2, 5, 'Received', 54, '16.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (104, 2, 5, 'Received', 241, '10.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (105, 2, 5, 'Received', 74, '24.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '72.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (106, 2, 5, 'Received', 6, '17.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '68.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (107, 2, 6, 'Received', 70, '28.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '140.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (108, 2, 6, 'Received', 93, '25.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '125.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (109, 2, 6, 'Received', 145, '55.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '110.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (110, 2, 6, 'Received', 61, '21.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '63.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (111, 2, 6, 'Received', 2, '16.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '64.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (112, 2, 7, 'Received', 14, '26.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '78.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (113, 2, 7, 'Received', 20, '9.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '27.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (114, 2, 7, 'Received', 141, '11.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '33.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (115, 2, 7, 'Received', 80, '43.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '86.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (116, 2, 7, 'Received', 12, '32.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '96.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (117, 2, 7, 'Received', 82, '53.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '106.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (118, 2, 7, 'Received', 4, '16.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '64.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (119, 2, 7, 'Received', 15, '25.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '75.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (120, 2, 7, 'Received', 11, '23.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '69.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (121, 2, 7, 'Received', 8, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (122, 2, 8, 'Received', 137, '62.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '124.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (123, 2, 8, 'Received', 180, '11.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '44.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (124, 2, 8, 'Received', 157, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (125, 2, 8, 'Received', 75, '7.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '21.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (126, 2, 8, 'Received', 30, '22.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '44.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (127, 2, 8, 'Received', 28, '22.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '44.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (128, 2, 8, 'Received', 78, '18.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '108.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (129, 2, 9, 'Received', 81, '59.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '118.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (130, 2, 9, 'Received', 67, '26.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '78.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (131, 2, 9, 'Received', 104, '7.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (132, 2, 9, 'Received', 183, '6.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (133, 2, 9, 'Received', 184, '5.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (134, 2, 9, 'Received', 155, '24.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (135, 2, 9, 'Received', 29, '36.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '72.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (136, 2, 9, 'Received', 58, '22.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '110.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (137, 2, 9, 'Received', 201, '11.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '22.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (138, 2, 9, 'Received', 43, '76.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '380.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (139, 2, 10, 'Received', 60, '54.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '324.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (140, 2, 10, 'Received', 88, '40.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '200.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (141, 2, 10, 'Received', 101, '6.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (142, 2, 10, 'Received', 144, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (143, 2, 10, 'Received', 26, '31.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '62.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (144, 2, 10, 'Received', 84, '8.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '40.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (145, 2, 10, 'Received', 42, '59.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '295.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (146, 2, 10, 'Received', 152, '18.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '72.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (147, 2, 11, 'Received', 31, '7.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '14.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (148, 2, 11, 'Received', 134, '32.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '32.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (149, 2, 11, 'Received', 135, '15.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (150, 2, 11, 'Received', 17, '31.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '93.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (151, 2, 11, 'Received', 69, '60.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '180.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (152, 2, 11, 'Received', 3, '19.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '57.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (153, 2, 11, 'Received', 56, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (154, 2, 11, 'Received', 77, '10.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (155, 2, 11, 'Received', 21, '21.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (156, 2, 11, 'Received', 138, '12.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (157, 2, 12, 'Received', 23, '25.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (158, 2, 12, 'Received', 87, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (159, 2, 12, 'Received', 24, '34.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '68.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (160, 2, 12, 'Received', 73, '21.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '63.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (161, 2, 12, 'Received', 79, '9.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (162, 2, 12, 'Received', 1, '27.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '81.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (163, 2, 12, 'Received', 136, '23.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '23.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (164, 2, 12, 'Received', 5, '7.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (165, 2, 13, 'Received', 16, '33.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '99.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (166, 2, 13, 'Received', 53, '45.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '225.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (167, 2, 13, 'Received', 62, '43.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '129.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (168, 2, 13, 'Received', 63, '50.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (169, 2, 13, 'Received', 64, '22.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '66.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (170, 2, 13, 'Received', 25, '25.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (171, 2, 13, 'Received', 27, '32.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '64.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (172, 2, 13, 'Received', 32, '30.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (173, 2, 13, 'Received', 22, '32.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '64.0000', NULL, NULL, 1, '');


#
# TABLE STRUCTURE FOR: db_purchaseitemsreturn
#

DROP TABLE IF EXISTS `db_purchaseitemsreturn`;

CREATE TABLE `db_purchaseitemsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `return_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `return_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchaseitemsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchaseitemsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_purchasereturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasepayments
#

DROP TABLE IF EXISTS `db_purchasepayments`;

CREATE TABLE `db_purchasepayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchasepayments_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepayments_ibfk_2` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepayments_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasepaymentsreturn
#

DROP TABLE IF EXISTS `db_purchasepaymentsreturn`;

CREATE TABLE `db_purchasepaymentsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_purchasereturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasereturn
#

DROP TABLE IF EXISTS `db_purchasereturn`;

CREATE TABLE `db_purchasereturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Purchase Return Code',
  `warehouse_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `return_note` text COLLATE utf8_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchasereturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasereturn_ibfk_2` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotation
#

DROP TABLE IF EXISTS `db_quotation`;

CREATE TABLE `db_quotation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create quotation Code',
  `quotation_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quotation_date` date DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `quotation_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL,
  `round_off` double(20,4) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `quotation_note` text COLLATE utf8_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'quotation return raised',
  `customer_previous_due` double(20,4) DEFAULT NULL,
  `customer_total_due` double(20,4) DEFAULT NULL,
  `sales_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_quotation_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotation_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotation_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotationitems
#

DROP TABLE IF EXISTS `db_quotationitems`;

CREATE TABLE `db_quotationitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `quotation_id` int(11) DEFAULT NULL,
  `quotation_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `quotation_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `seller_points` double(20,4) DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `quotation_id` (`quotation_id`),
  CONSTRAINT `db_quotationitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotationitems_ibfk_2` FOREIGN KEY (`quotation_id`) REFERENCES `db_quotation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_roles
#

DROP TABLE IF EXISTS `db_roles`;

CREATE TABLE `db_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `role_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_roles_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (1, 1, 'Admin', 'All Rights Permitted.', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (2, 1, 'Store Admin', 'Note: Apply this role for New Store Admin. ', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (3, 2, 'sales', '', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (4, 2, 'Manager', '', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (5, 2, 'Purchase Executive', '', 1);


#
# TABLE STRUCTURE FOR: db_sales
#

DROP TABLE IF EXISTS `db_sales`;

CREATE TABLE `db_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `init_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `count_id` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Use to create Sales Code',
  `sales_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `sales_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text COLLATE utf8_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'sales return raised',
  `customer_previous_due` double(20,2) DEFAULT NULL,
  `customer_total_due` double(20,2) DEFAULT NULL,
  `quotation_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_sales_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (1, 2, 3, NULL, '1', 'SL/0001', NULL, '2025-09-28', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-09-28', '09:17:55 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, 1, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (2, 2, 3, NULL, '2', 'SL/0002', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-29', '11:24:31 am', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (3, 2, 3, NULL, '3', 'SL/0003', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-09-29', '11:29:11 am', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (4, 2, 3, NULL, '4', 'SL/0004', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '19.00', '0.00', '19.0000', '', 'Paid', '19.0000', '2025-09-29', '06:08:31 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: db_salesitems
#

DROP TABLE IF EXISTS `db_salesitems`;

CREATE TABLE `db_salesitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sales_id` int(11) DEFAULT NULL,
  `sales_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `sales_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `seller_points` double(20,2) DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`sales_id`),
  CONSTRAINT `db_salesitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesitems_ibfk_2` FOREIGN KEY (`sales_id`) REFERENCES `db_sales` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (1, 2, 1, 'Final', 138, '', '1.00', '4.0000', 'Inclusive', 151, NULL, 'Percentage', '0.0000', '0.0000', '4.0000', '4.0000', 1, '0.00');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (2, 2, 2, 'Final', 123, '', '1.00', '6.0000', 'Inclusive', 151, NULL, 'Percentage', '0.0000', '0.0000', '6.0000', '6.0000', 1, '0.00');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (3, 2, 3, 'Final', 12, '', '1.00', '5.0000', 'Inclusive', 151, NULL, 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (4, 2, 4, 'Final', 125, '', '2.00', '6.0000', 'Inclusive', 151, NULL, 'Percentage', '0.0000', '0.0000', '6.0000', '12.0000', 1, '0.00');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`) VALUES (5, 2, 4, 'Final', 117, '', '1.00', '7.0000', 'Inclusive', 151, NULL, 'Percentage', '0.0000', '0.0000', '7.0000', '7.0000', 1, '0.00');


#
# TABLE STRUCTURE FOR: db_salesitemsreturn
#

DROP TABLE IF EXISTS `db_salesitemsreturn`;

CREATE TABLE `db_salesitemsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sales_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `return_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `return_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  CONSTRAINT `db_salesitemsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesitemsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_salesreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_salesitemsreturn` (`id`, `store_id`, `sales_id`, `return_id`, `return_status`, `item_id`, `return_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_input`, `discount_amt`, `discount_type`, `unit_total_cost`, `total_cost`, `status`, `description`) VALUES (1, 2, 1, 1, 'Return', 138, '1.00', '4.0000', 'Inclusive', 151, NULL, NULL, '0.0000', 'Percentage', '4.0000', '4.0000', 1, '');


#
# TABLE STRUCTURE FOR: db_salespayments
#

DROP TABLE IF EXISTS `db_salespayments`;

CREATE TABLE `db_salespayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `sales_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text COLLATE utf8_unicode_ci,
  `change_return` double(20,4) DEFAULT NULL COMMENT 'Refunding the greater amount',
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `advance_adjusted` double(20,4) DEFAULT NULL,
  `cheque_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cheque_period` int(11) DEFAULT NULL,
  `cheque_status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`sales_id`),
  KEY `customer_id` (`customer_id`),
  CONSTRAINT `db_salespayments_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespayments_ibfk_2` FOREIGN KEY (`sales_id`) REFERENCES `db_sales` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespayments_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (1, 1, 'SP/2025/01/0001', 2, 1, '2025-09-28', 'Visa', '4.0000', 'Paid By Visa', '0.0000', '37.28.67.43', 'dynamic.isp.ooredoo.om', '09:17:55', '2025-09-28', 'Liwa', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (2, 2, 'SP/2025/01/0002', 2, 2, '2025-09-29', 'Visa', '6.0000', 'Paid By Visa', '0.0000', '37.28.67.43', 'dynamic.isp.ooredoo.om', '11:24:31', '2025-09-29', 'Liwa', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (3, 3, 'SP/2025/01/0003', 2, 3, '2025-09-29', 'Visa', '5.0000', 'Paid By Visa', '0.0000', '37.28.67.43', 'dynamic.isp.ooredoo.om', '11:29:11', '2025-09-29', 'Liwa', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (4, 4, 'SP/2025/01/0004', 2, 4, '2025-09-29', 'Visa', '19.0000', 'Paid By Visa', '0.0000', '37.28.67.43', 'dynamic.isp.ooredoo.om', '06:08:31', '2025-09-29', 'Liwa', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: db_salespaymentsreturn
#

DROP TABLE IF EXISTS `db_salespaymentsreturn`;

CREATE TABLE `db_salespaymentsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `sales_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text COLLATE utf8_unicode_ci,
  `change_return` double(20,4) DEFAULT NULL COMMENT 'Refunding the greater amount',
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `db_salespaymentsreturn_ibfk_3` (`customer_id`),
  CONSTRAINT `db_salespaymentsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespaymentsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_salesreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespaymentsreturn_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_salesreturn
#

DROP TABLE IF EXISTS `db_salesreturn`;

CREATE TABLE `db_salesreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Sales Return Code',
  `sales_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `return_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL,
  `round_off` double(20,4) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `return_note` text COLLATE utf8_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'Return raised or not 1 or null',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`sales_id`),
  CONSTRAINT `db_salesreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesreturn_ibfk_2` FOREIGN KEY (`sales_id`) REFERENCES `db_sales` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_salesreturn` (`id`, `store_id`, `count_id`, `sales_id`, `warehouse_id`, `return_code`, `reference_no`, `return_date`, `return_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `return_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`) VALUES (1, 2, 1, 1, 3, 'SR/2025/01/0001', '', '2025-09-28', 'Return', 2, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4.0000', NULL, '4.0000', '', 'Unpaid', '0.0000', '2025-09-28', '11:05:15 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, NULL, 1, NULL);


#
# TABLE STRUCTURE FOR: db_shippingaddress
#

DROP TABLE IF EXISTS `db_shippingaddress`;

CREATE TABLE `db_shippingaddress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `city` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  `postcode` varchar(20) CHARACTER SET latin1 DEFAULT NULL,
  `address` text CHARACTER SET latin1,
  `status` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `location_link` text CHARACTER SET latin1,
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (1, 1, 1, NULL, NULL, '', '', 1, 1, NULL);
INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (2, 2, NULL, NULL, NULL, NULL, NULL, 1, 2, NULL);
INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (6, 2, 138, 0, '', '', '', 1, 11, '');
INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (8, 2, 0, 0, '', '', '', 1, 25, '');
INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (9, 2, 0, 0, '', '', '', 1, 3, '');
INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (10, 2, 0, 0, '', '', '', 1, 4, '');


#
# TABLE STRUCTURE FOR: db_sitesettings
#

DROP TABLE IF EXISTS `db_sitesettings`;

CREATE TABLE `db_sitesettings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `site_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `logo` mediumtext COLLATE utf8_unicode_ci COMMENT 'path',
  `machine_id` text COLLATE utf8_unicode_ci,
  `domain` text COLLATE utf8_unicode_ci,
  `unique_code` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_sitesettings` (`id`, `version`, `site_name`, `logo`, `machine_id`, `domain`, `unique_code`) VALUES (1, '2.5', 'Baramiij POS', '/uploads/site/billing-book.png', '1', 'dun.ota.mybluehost.me', '0ehdzwvy7imoa5t3rc82jlq6xs4bkf');


#
# TABLE STRUCTURE FOR: db_smsapi
#

DROP TABLE IF EXISTS `db_smsapi`;

CREATE TABLE `db_smsapi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `info` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `key` varchar(600) COLLATE utf8_unicode_ci DEFAULT NULL,
  `key_value` varchar(600) COLLATE utf8_unicode_ci DEFAULT NULL,
  `delete_bit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (26, 2, 'url', 'weblink', 'http://example.com/sendmessage', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (27, 2, 'mobile', 'mobiles', '', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (28, 2, 'message', 'message', '', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (29, 1, 'url', 'weblink', 'https://www.example.com/api/mt/SendSMS?', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (30, 1, 'mobile', 'mobiles', '', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (31, 1, 'message', 'message', '', NULL);


#
# TABLE STRUCTURE FOR: db_smstemplates
#

DROP TABLE IF EXISTS `db_smstemplates`;

CREATE TABLE `db_smstemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `template_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8_unicode_ci,
  `variables` text COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  `undelete_bit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (1, 1, 'GREETING TO CUSTOMER ON SALES', 'Hi {{customer_name}},\r\nYour sales Id is {{sales_id}},\r\nSales Date {{sales_date}},\r\nTotal amount  {{sales_amount}},\r\nYou have paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}<br>                          \r\n{{sales_id}}<br>\r\n{{sales_date}}<br>\r\n{{sales_amount}}<br>\r\n{{paid_amt}}<br>\r\n{{due_amt}}<br>\r\n{{store_name}}<br>\r\n{{store_mobile}}<br>\r\n{{store_address}}<br>\r\n{{store_website}}<br>\r\n{{store_email}}<br>\r\n', 1, 1);
INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (2, 1, 'GREETING TO CUSTOMER ON SALES RETURN', 'Hi {{customer_name}},\r\nYour sales return Id is {{return_id}},\r\nReturn Date {{return_date}},\r\nTotal amount  {{return_amount}},\r\nWe paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}<br>                          \r\n{{return_id}}<br>\r\n{{return_date}}<br>\r\n{{return_amount}}<br>\r\n{{paid_amt}}<br>\r\n{{due_amt}}<br>\r\n{{company_name}}<br>\r\n{{company_mobile}}<br>\r\n{{company_address}}<br>\r\n{{company_website}}<br>\r\n{{company_email}}<br>', 1, 1);
INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (12, 2, 'GREETING TO CUSTOMER ON SALES', 'Hi {{customer_name}},\r\nYour sales Id is {{sales_id}},\r\nSales Date {{sales_date}},\r\nTotal amount  {{sales_amount}},\r\nYou have paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}                          \r\n{{sales_id}}\r\n{{sales_date}}\r\n{{sales_amount}}\r\n{{paid_amt}}\r\n{{due_amt}}\r\n{{store_name}}\r\n{{store_mobile}}\r\n{{store_address}}\r\n{{store_website}}\r\n{{store_email}}\r\n', 1, 1);
INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (13, 2, 'GREETING TO CUSTOMER ON SALES RETURN', 'Hi {{customer_name}},\r\nYour sales return Id is {{return_id}},\r\nReturn Date {{return_date}},\r\nTotal amount  {{return_amount}},\r\nWe paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}                          \r\n{{return_id}}\r\n{{return_date}}\r\n{{return_amount}}\r\n{{paid_amt}}\r\n{{due_amt}}\r\n{{company_name}}\r\n{{company_mobile}}\r\n{{company_address}}\r\n{{company_website}}\r\n{{company_email}}\r\n', 1, 1);


#
# TABLE STRUCTURE FOR: db_sobpayments
#

DROP TABLE IF EXISTS `db_sobpayments`;

CREATE TABLE `db_sobpayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` mediumtext COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_states
#

DROP TABLE IF EXISTS `db_states`;

CREATE TABLE `db_states` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `state_code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(4050) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country_code` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `country` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `added_on` date DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_stockadjustment
#

DROP TABLE IF EXISTS `db_stockadjustment`;

CREATE TABLE `db_stockadjustment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `adjustment_date` date DEFAULT NULL,
  `adjustment_note` mediumtext COLLATE utf8_unicode_ci,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=238 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (1, 2, 3, 'Auto Generated For 6147-G1', '2025-09-26', 'Auto Generated For 6147-G1', '2025-09-26', '06:41:46 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (2, 2, 3, 'Auto Generated For 2289-333T', '2025-09-26', 'Auto Generated For 2289-333T', '2025-09-26', '07:48:27 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (3, 2, 3, 'Auto Generated For F89725-284', '2025-09-26', 'Auto Generated For F89725-284', '2025-09-26', '07:50:32 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (4, 2, 3, 'Auto Generated For 135-72', '2025-09-26', 'Auto Generated For 135-72', '2025-09-26', '07:54:11 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (5, 2, 3, 'Auto Generated For 0855-190', '2025-09-26', 'Auto Generated For 0855-190', '2025-09-26', '07:55:18 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (6, 2, 3, 'Auto Generated For 135-77', '2025-09-26', 'Auto Generated For 135-77', '2025-09-26', '07:56:55 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (7, 2, 3, 'Auto Generated For 136-92', '2025-09-26', 'Auto Generated For 136-92', '2025-09-26', '07:59:42 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (8, 2, 3, 'Auto Generated For M1-12', '2025-09-26', 'Auto Generated For M1-12', '2025-09-26', '08:02:06 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (9, 2, 3, 'Auto Generated For M1-11', '2025-09-26', 'Auto Generated For M1-11', '2025-09-26', '08:03:24 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (10, 2, 3, 'Auto Generated For M1-2', '2025-09-26', 'Auto Generated For M1-2', '2025-09-26', '08:04:07 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (11, 2, 3, 'Auto Generated For M1-4', '2025-09-26', 'Auto Generated For M1-4', '2025-09-26', '08:05:26 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (12, 2, 3, 'Auto Generated For M1-5', '2025-09-26', 'Auto Generated For M1-5', '2025-09-26', '08:06:25 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (13, 2, 3, 'Auto Generated For M1-6', '2025-09-26', 'Auto Generated For M1-6', '2025-09-26', '08:08:34 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (14, 2, 3, 'Auto Generated For F053986-6', '2025-09-26', 'Auto Generated For F053986-6', '2025-09-26', '08:09:45 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (15, 2, 3, 'Auto Generated For M1-7', '2025-09-26', 'Auto Generated For M1-7', '2025-09-26', '08:12:46 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (16, 2, 3, 'Auto Generated For 6147-6', '2025-09-26', 'Auto Generated For 6147-6', '2025-09-26', '08:14:15 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (17, 2, 3, 'Auto Generated For FD6466-66', '2025-09-26', 'Auto Generated For FD6466-66', '2025-09-26', '08:15:28 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (18, 2, 3, 'Auto Generated For M1-3', '2025-09-26', 'Auto Generated For M1-3', '2025-09-26', '08:16:34 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (19, 2, 3, 'Auto Generated For GN242-638', '2025-09-26', 'Auto Generated For GN242-638', '2025-09-26', '08:18:21 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (20, 2, 3, 'Auto Generated For GN242-692', '2025-09-26', 'Auto Generated For GN242-692', '2025-09-26', '08:19:30 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (21, 2, 3, 'Auto Generated For 8441-7', '2025-09-26', 'Auto Generated For 8441-7', '2025-09-26', '08:20:44 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (22, 2, 3, 'Auto Generated For M1-9', '2025-09-26', 'Auto Generated For M1-9', '2025-09-26', '08:23:31 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (23, 2, 3, 'Auto Generated For 8441-94', '2025-09-26', 'Auto Generated For 8441-94', '2025-09-26', '08:25:17 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (24, 2, 3, 'Auto Generated For 8441-4', '2025-09-26', 'Auto Generated For 8441-4', '2025-09-26', '08:26:13 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (25, 2, 3, 'Auto Generated For 9252-D51', '2025-09-26', 'Auto Generated For 9252-D51', '2025-09-26', '08:27:04 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (26, 2, 3, 'Auto Generated For 9252-10', '2025-09-26', 'Auto Generated For 9252-10', '2025-09-26', '08:27:43 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (27, 2, 3, 'Auto Generated For 9252-A15', '2025-09-26', 'Auto Generated For 9252-A15', '2025-09-26', '08:28:29 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (28, 2, 3, 'Auto Generated For 8181-D90', '2025-09-26', 'Auto Generated For 8181-D90', '2025-09-26', '08:29:26 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (29, 2, 3, 'Auto Generated For 8441-1', '2025-09-26', 'Auto Generated For 8441-1', '2025-09-26', '08:30:11 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (30, 2, 3, 'Auto Generated For 8181-G1', '2025-09-26', 'Auto Generated For 8181-G1', '2025-09-26', '08:31:07 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (31, 2, 3, 'Auto Generated For 8441-G1', '2025-09-26', 'Auto Generated For 8441-G1', '2025-09-26', '08:32:00 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (32, 2, 3, 'Auto Generated For M1-10', '2025-09-26', 'Auto Generated For M1-10', '2025-09-26', '08:34:30 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (33, 2, 3, 'Auto Generated For M1-1', '2025-09-26', 'Auto Generated For M1-1', '2025-09-26', '08:35:18 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (34, 2, 3, 'Auto Generated For A09557', '2025-09-26', 'Auto Generated For A09557', '2025-09-26', '08:43:59 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (35, 2, 3, 'Auto Generated For 1281', '2025-09-26', 'Auto Generated For 1281', '2025-09-26', '08:46:21 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (36, 2, 3, 'Auto Generated For KV-02', '2025-09-26', 'Auto Generated For KV-02', '2025-09-26', '08:47:52 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (37, 2, 3, 'Auto Generated For QS5571', '2025-09-26', 'Auto Generated For QS5571', '2025-09-26', '08:52:25 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (38, 2, 3, 'Auto Generated For R8621-6', '2025-09-26', 'Auto Generated For R8621-6', '2025-09-26', '08:53:46 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (39, 2, 3, 'Auto Generated For CMF36072-145A', '2025-09-26', 'Auto Generated For CMF36072-145A', '2025-09-26', '08:56:25 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (40, 2, 3, 'Auto Generated For QGQ-210', '2025-09-26', 'Auto Generated For QGQ-210', '2025-09-26', '08:57:45 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (41, 2, 3, 'Auto Generated For MY2056-2', '2025-09-26', 'Auto Generated For MY2056-2', '2025-09-26', '08:58:50 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (42, 2, 3, 'Auto Generated For MY3700-3', '2025-09-26', 'Auto Generated For MY3700-3', '2025-09-26', '09:00:14 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (43, 2, 3, 'Auto Generated For MY3700-2', '2025-09-26', 'Auto Generated For MY3700-2', '2025-09-26', '09:02:38 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (44, 2, 3, 'Auto Generated For LX6095-17', '2025-09-26', 'Auto Generated For LX6095-17', '2025-09-26', '09:04:43 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (45, 2, 3, 'Auto Generated For LX9698', '2025-09-26', 'Auto Generated For LX9698', '2025-09-26', '09:06:29 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (46, 2, 3, 'Auto Generated For LX2041-5', '2025-09-26', 'Auto Generated For LX2041-5', '2025-09-26', '09:07:30 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (47, 2, 3, 'Auto Generated For M2273-16', '2025-09-26', 'Auto Generated For M2273-16', '2025-09-26', '09:08:54 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (48, 2, 3, 'Auto Generated For 2273-1', '2025-09-26', 'Auto Generated For 2273-1', '2025-09-26', '09:09:46 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (49, 2, 3, 'Auto Generated For 23041-2', '2025-09-26', 'Auto Generated For 23041-2', '2025-09-26', '09:11:39 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (50, 2, 3, 'Auto Generated For 2944', '2025-09-26', 'Auto Generated For 2944', '2025-09-26', '09:12:20 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (51, 2, 3, 'Auto Generated For 7793-2', '2025-09-26', 'Auto Generated For 7793-2', '2025-09-26', '09:12:54 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (52, 2, 3, 'Auto Generated For 58825-1', '2025-09-26', 'Auto Generated For 58825-1', '2025-09-26', '09:13:59 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (53, 2, 3, 'Auto Generated For A90458-2', '2025-09-26', 'Auto Generated For A90458-2', '2025-09-26', '09:15:10 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (54, 2, 3, 'Auto Generated For A8602', '2025-09-26', 'Auto Generated For A8602', '2025-09-26', '09:17:15 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (55, 2, 3, 'Auto Generated For 8042', '2025-09-26', 'Auto Generated For 8042', '2025-09-26', '09:18:03 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (56, 2, 3, 'Auto Generated For 8602', '2025-09-26', 'Auto Generated For 8602', '2025-09-26', '09:19:17 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (57, 2, 3, 'Auto Generated For 1098-3', '2025-09-26', 'Auto Generated For 1098-3', '2025-09-26', '09:20:15 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (58, 2, 3, 'Auto Generated For 2577', '2025-09-26', 'Auto Generated For 2577', '2025-09-26', '09:20:49 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (59, 2, 3, 'Auto Generated For 90458', '2025-09-26', 'Auto Generated For 90458', '2025-09-26', '09:22:19 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (60, 2, 3, 'Auto Generated For 998', '2025-09-26', 'Auto Generated For 998', '2025-09-26', '09:23:48 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (61, 2, 3, 'Auto Generated For 8438-2', '2025-09-26', 'Auto Generated For 8438-2', '2025-09-26', '09:24:29 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (62, 2, 3, 'Auto Generated For SP8108', '2025-09-26', 'Auto Generated For SP8108', '2025-09-26', '09:25:42 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (63, 2, 3, 'Auto Generated For SP8109', '2025-09-26', 'Auto Generated For SP8109', '2025-09-26', '09:28:42 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (64, 2, 3, 'Auto Generated For BL70-305', '2025-09-26', 'Auto Generated For BL70-305', '2025-09-26', '09:30:25 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (65, 2, 3, 'Auto Generated For 5722-5', '2025-09-26', 'Auto Generated For 5722-5', '2025-09-26', '09:31:10 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (66, 2, 3, 'Auto Generated For 52269', '2025-09-26', 'Auto Generated For 52269', '2025-09-26', '09:32:24 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (67, 2, 3, 'Auto Generated For YE452', '2025-09-26', 'Auto Generated For YE452', '2025-09-26', '09:33:40 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (68, 2, 3, 'Auto Generated For 3317-3', '2025-09-26', 'Auto Generated For 3317-3', '2025-09-26', '09:34:26 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (69, 2, 3, 'Auto Generated For TL-911', '2025-09-26', 'Auto Generated For TL-911', '2025-09-26', '09:35:12 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (70, 2, 3, 'Auto Generated For Z68141', '2025-09-26', 'Auto Generated For Z68141', '2025-09-26', '09:40:49 pm', 'Liwa', '37.28.75.246', '37.28.75.246', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (71, 2, 3, 'Auto Generated For 2877', '2025-09-27', 'Auto Generated For 2877', '2025-09-27', '01:43:39 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (72, 2, 3, 'Auto Generated For 8625-1', '2025-09-27', 'Auto Generated For 8625-1', '2025-09-27', '01:45:02 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (73, 2, 3, 'Auto Generated For 0365-0910', '2025-09-27', 'Auto Generated For 0365-0910', '2025-09-27', '01:45:51 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (74, 2, 3, 'Auto Generated For ME1507', '2025-09-27', 'Auto Generated For ME1507', '2025-09-27', '01:46:33 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (75, 2, 3, 'Auto Generated For YC-442', '2025-09-27', 'Auto Generated For YC-442', '2025-09-27', '01:56:46 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (76, 2, 3, 'Auto Generated For 30-432', '2025-09-27', 'Auto Generated For 30-432', '2025-09-27', '01:57:16 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (77, 2, 3, 'Auto Generated For 30-428', '2025-09-27', 'Auto Generated For 30-428', '2025-09-27', '01:57:56 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (78, 2, 3, 'Auto Generated For 2020-2', '2025-09-27', 'Auto Generated For 2020-2', '2025-09-27', '01:58:48 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (79, 2, 3, 'Auto Generated For SH-12', '2025-09-27', 'Auto Generated For SH-12', '2025-09-27', '02:07:26 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (80, 2, 3, 'Auto Generated For ME1501', '2025-09-27', 'Auto Generated For ME1501', '2025-09-27', '02:08:59 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (81, 2, 3, 'Auto Generated For ME1514', '2025-09-27', 'Auto Generated For ME1514', '2025-09-27', '02:10:01 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (82, 2, 3, 'Auto Generated For ME1502', '2025-09-27', 'Auto Generated For ME1502', '2025-09-27', '02:11:03 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (83, 2, 3, 'Auto Generated For 8895-68', '2025-09-27', 'Auto Generated For 8895-68', '2025-09-27', '02:12:04 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (84, 2, 3, 'Auto Generated For 10041', '2025-09-27', 'Auto Generated For 10041', '2025-09-27', '02:13:02 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (85, 2, 3, 'Auto Generated For 0909-25', '2025-09-27', 'Auto Generated For 0909-25', '2025-09-27', '02:14:48 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (86, 2, 3, 'Auto Generated For 0909-27', '2025-09-27', 'Auto Generated For 0909-27', '2025-09-27', '02:15:44 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (87, 2, 3, 'Auto Generated For 30-406', '2025-09-27', 'Auto Generated For 30-406', '2025-09-27', '02:17:11 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (88, 2, 3, 'Auto Generated For 80421-1', '2025-09-27', 'Auto Generated For 80421-1', '2025-09-27', '02:18:41 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (89, 2, 3, 'Auto Generated For H38', '2025-09-27', 'Auto Generated For H38', '2025-09-27', '02:19:23 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (90, 2, 3, 'Auto Generated For 6296-12', '2025-09-27', 'Auto Generated For 6296-12', '2025-09-27', '02:20:12 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (91, 2, 3, 'Auto Generated For 15290', '2025-09-27', 'Auto Generated For 15290', '2025-09-27', '02:20:59 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (92, 2, 3, 'Auto Generated For 6038', '2025-09-27', 'Auto Generated For 6038', '2025-09-27', '02:22:32 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (93, 2, 3, 'Auto Generated For 2256-1', '2025-09-27', 'Auto Generated For 2256-1', '2025-09-27', '02:23:11 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (94, 2, 3, 'Auto Generated For 37057-1', '2025-09-27', 'Auto Generated For 37057-1', '2025-09-27', '02:24:10 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (95, 2, 3, 'Auto Generated For 37057', '2025-09-27', 'Auto Generated For 37057', '2025-09-27', '02:24:51 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (96, 2, 3, 'Auto Generated For 91349-18', '2025-09-27', 'Auto Generated For 91349-18', '2025-09-27', '02:26:28 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (97, 2, 3, 'Auto Generated For 2262-1', '2025-09-27', 'Auto Generated For 2262-1', '2025-09-27', '02:29:17 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (98, 2, 3, 'Auto Generated For 2321', '2025-09-27', 'Auto Generated For 2321', '2025-09-27', '02:29:57 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (99, 2, 3, 'Auto Generated For 5018', '2025-09-27', 'Auto Generated For 5018', '2025-09-27', '02:30:52 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (100, 2, 3, 'Auto Generated For 8535-1', '2025-09-27', 'Auto Generated For 8535-1', '2025-09-27', '02:31:54 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (101, 2, 3, 'Auto Generated For 8359', '2025-09-27', 'Auto Generated For 8359', '2025-09-27', '02:32:39 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (102, 2, 3, 'Auto Generated For 8101-1', '2025-09-27', 'Auto Generated For 8101-1', '2025-09-27', '02:33:32 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (103, 2, 3, 'Auto Generated For 52323', '2025-09-27', 'Auto Generated For 52323', '2025-09-27', '02:34:26 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (104, 2, 3, 'Auto Generated For 09557', '2025-09-27', 'Auto Generated For 09557', '2025-09-27', '02:35:16 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (105, 2, 3, 'Auto Generated For 8520', '2025-09-27', 'Auto Generated For 8520', '2025-09-27', '02:35:44 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (106, 2, 3, 'Auto Generated For 7769-11', '2025-09-27', 'Auto Generated For 7769-11', '2025-09-27', '02:36:21 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (107, 2, 3, 'Auto Generated For d1', '2025-09-27', 'Auto Generated For d1', '2025-09-27', '02:40:13 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (108, 2, 3, 'Auto Generated For d2', '2025-09-27', 'Auto Generated For d2', '2025-09-27', '02:41:02 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (109, 2, 3, 'Auto Generated For D3', '2025-09-27', 'Auto Generated For D3', '2025-09-27', '02:41:40 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (110, 2, 3, 'Auto Generated For D4', '2025-09-27', 'Auto Generated For D4', '2025-09-27', '02:42:16 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (111, 2, 3, 'Auto Generated For D8', '2025-09-27', 'Auto Generated For D8', '2025-09-27', '02:42:52 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (112, 2, 3, 'Auto Generated For D9', '2025-09-27', 'Auto Generated For D9', '2025-09-27', '02:43:30 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (113, 2, 3, 'Auto Generated For D10', '2025-09-27', 'Auto Generated For D10', '2025-09-27', '02:44:07 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (114, 2, 3, 'Auto Generated For D11', '2025-09-27', 'Auto Generated For D11', '2025-09-27', '02:44:43 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (115, 2, 3, 'Auto Generated For D14', '2025-09-27', 'Auto Generated For D14', '2025-09-27', '02:45:18 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (116, 2, 3, 'Auto Generated For D15', '2025-09-27', 'Auto Generated For D15', '2025-09-27', '02:46:00 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (117, 2, 3, 'Auto Generated For D7', '2025-09-27', 'Auto Generated For D7', '2025-09-27', '02:46:47 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (118, 2, 3, 'Auto Generated For D12', '2025-09-27', 'Auto Generated For D12', '2025-09-27', '02:47:28 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (119, 2, 3, 'Auto Generated For D16', '2025-09-27', 'Auto Generated For D16', '2025-09-27', '02:48:07 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (120, 2, 3, 'Auto Generated For D17', '2025-09-27', 'Auto Generated For D17', '2025-09-27', '02:48:45 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (121, 2, 3, 'Auto Generated For D18', '2025-09-27', 'Auto Generated For D18', '2025-09-27', '02:50:46 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (122, 2, 3, 'Auto Generated For D19', '2025-09-27', 'Auto Generated For D19', '2025-09-27', '02:51:17 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (123, 2, 3, 'Auto Generated For D20 FLAT', '2025-09-27', 'Auto Generated For D20 FLAT', '2025-09-27', '02:52:19 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (124, 2, 3, 'Auto Generated For D23', '2025-09-27', 'Auto Generated For D23', '2025-09-27', '02:52:57 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (125, 2, 3, 'Auto Generated For D24', '2025-09-27', 'Auto Generated For D24', '2025-09-27', '02:53:32 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (126, 2, 3, 'Auto Generated For D6', '2025-09-27', 'Auto Generated For D6', '2025-09-27', '02:54:27 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (127, 2, 3, 'Auto Generated For D15 FLAT', '2025-09-27', 'Auto Generated For D15 FLAT', '2025-09-27', '02:55:12 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (128, 2, 3, 'Auto Generated For D21', '2025-09-27', 'Auto Generated For D21', '2025-09-27', '02:55:50 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (129, 2, 3, 'Auto Generated For 1801', '2025-09-27', 'Auto Generated For 1801', '2025-09-27', '02:58:09 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (130, 2, 3, 'Auto Generated For 90047', '2025-09-27', 'Auto Generated For 90047', '2025-09-27', '02:59:09 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (131, 2, 3, 'Auto Generated For 9318-14', '2025-09-27', 'Auto Generated For 9318-14', '2025-09-27', '02:59:52 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (132, 2, 3, 'Auto Generated For E3402', '2025-09-27', 'Auto Generated For E3402', '2025-09-27', '03:00:32 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (133, 2, 3, 'Auto Generated For 52140-2', '2025-09-27', 'Auto Generated For 52140-2', '2025-09-27', '03:01:20 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (134, 2, 3, 'Auto Generated For OB-52', '2025-09-27', 'Auto Generated For OB-52', '2025-09-27', '03:03:28 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (135, 2, 3, 'Auto Generated For OB-51', '2025-09-27', 'Auto Generated For OB-51', '2025-09-27', '03:04:04 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (136, 2, 3, 'Auto Generated For OB-53', '2025-09-27', 'Auto Generated For OB-53', '2025-09-27', '03:04:50 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (137, 2, 3, 'Auto Generated For 2412-145', '2025-09-27', 'Auto Generated For 2412-145', '2025-09-27', '03:05:23 am', 'Liwa', '37.40.228.35', '37.40.228.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (138, 2, 3, 'Auto Generated For ME1442', '2025-09-28', 'Auto Generated For ME1442', '2025-09-28', '08:44:03 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (139, 2, 3, 'Auto Generated For 30-256', '2025-09-28', 'Auto Generated For 30-256', '2025-09-28', '08:46:14 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (140, 2, 3, 'Auto Generated For 30-255', '2025-09-28', 'Auto Generated For 30-255', '2025-09-28', '08:48:30 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (141, 2, 3, 'Auto Generated For lw96', '2025-09-28', 'Auto Generated For lw96', '2025-09-28', '08:50:00 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (142, 2, 3, 'Auto Generated For QB-93', '2025-09-28', 'Auto Generated For QB-93', '2025-09-28', '09:00:26 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (143, 2, 3, 'Auto Generated For BK-480', '2025-09-28', 'Auto Generated For BK-480', '2025-09-28', '09:01:49 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (144, 2, 3, 'Auto Generated For 30-171', '2025-09-28', 'Auto Generated For 30-171', '2025-09-28', '09:02:44 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (145, 2, 3, 'Auto Generated For 0318-28', '2025-09-28', 'Auto Generated For 0318-28', '2025-09-28', '09:04:34 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (146, 2, 3, 'Auto Generated For ME1477', '2025-09-28', 'Auto Generated For ME1477', '2025-09-28', '09:05:33 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (147, 2, 3, 'Auto Generated For 9263-4', '2025-09-28', 'Auto Generated For 9263-4', '2025-09-28', '09:06:24 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (148, 2, 3, 'Auto Generated For S3377', '2025-09-28', 'Auto Generated For S3377', '2025-09-28', '09:07:22 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (149, 2, 3, 'Auto Generated For 2123', '2025-09-28', 'Auto Generated For 2123', '2025-09-28', '09:08:13 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (150, 2, 3, 'Auto Generated For 908-2', '2025-09-28', 'Auto Generated For 908-2', '2025-09-28', '09:09:00 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (151, 2, 3, 'Auto Generated For 518-1', '2025-09-28', 'Auto Generated For 518-1', '2025-09-28', '09:10:17 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (152, 2, 3, 'Auto Generated For B6120', '2025-09-28', 'Auto Generated For B6120', '2025-09-28', '09:12:43 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (153, 2, 3, 'Auto Generated For 6887-1', '2025-09-28', 'Auto Generated For 6887-1', '2025-09-28', '09:13:48 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (154, 2, 3, 'Auto Generated For 60074-1', '2025-09-28', 'Auto Generated For 60074-1', '2025-09-28', '09:14:51 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (155, 2, 3, 'Auto Generated For 58531-1', '2025-09-28', 'Auto Generated For 58531-1', '2025-09-28', '09:19:38 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (156, 2, 3, 'Auto Generated For 2391', '2025-09-28', 'Auto Generated For 2391', '2025-09-28', '09:21:00 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (157, 2, 3, 'Auto Generated For 810-1', '2025-09-28', 'Auto Generated For 810-1', '2025-09-28', '09:22:00 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (158, 2, 3, 'Auto Generated For 2022', '2025-09-28', 'Auto Generated For 2022', '2025-09-28', '09:22:46 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (159, 2, 3, 'Auto Generated For 625-58', '2025-09-28', 'Auto Generated For 625-58', '2025-09-28', '09:24:20 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (160, 2, 3, 'Auto Generated For 90042', '2025-09-28', 'Auto Generated For 90042', '2025-09-28', '09:25:26 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (161, 2, 3, 'Auto Generated For 90080', '2025-09-28', 'Auto Generated For 90080', '2025-09-28', '09:27:16 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (162, 2, 3, 'Auto Generated For TL-752', '2025-09-28', 'Auto Generated For TL-752', '2025-09-28', '09:28:03 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (163, 2, 3, 'Auto Generated For 0365-6', '2025-09-28', 'Auto Generated For 0365-6', '2025-09-28', '09:29:35 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (164, 2, 3, 'Auto Generated For 8758', '2025-09-28', 'Auto Generated For 8758', '2025-09-28', '09:30:42 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (165, 2, 3, 'Auto Generated For 3563-1', '2025-09-28', 'Auto Generated For 3563-1', '2025-09-28', '09:31:44 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (166, 2, 3, 'Auto Generated For 859', '2025-09-28', 'Auto Generated For 859', '2025-09-28', '09:33:44 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (167, 2, 3, 'Auto Generated For E3299', '2025-09-28', 'Auto Generated For E3299', '2025-09-28', '09:34:26 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (168, 2, 3, 'Auto Generated For 52271', '2025-09-28', 'Auto Generated For 52271', '2025-09-28', '09:35:25 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (169, 2, 3, 'Auto Generated For 025-1', '2025-09-28', 'Auto Generated For 025-1', '2025-09-28', '09:36:17 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (170, 2, 3, 'Auto Generated For M24614', '2025-09-28', 'Auto Generated For M24614', '2025-09-28', '09:37:12 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (171, 2, 3, 'Auto Generated For 211', '2025-09-28', 'Auto Generated For 211', '2025-09-28', '09:39:57 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (172, 2, 3, 'Auto Generated For 3297', '2025-09-28', 'Auto Generated For 3297', '2025-09-28', '09:40:35 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (173, 2, 3, 'Auto Generated For 2105', '2025-09-28', 'Auto Generated For 2105', '2025-09-28', '09:41:21 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (174, 2, 3, 'Auto Generated For G693', '2025-09-28', 'Auto Generated For G693', '2025-09-28', '09:44:30 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (175, 2, 3, 'Auto Generated For G694', '2025-09-28', 'Auto Generated For G694', '2025-09-28', '09:45:28 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (176, 2, 3, 'Auto Generated For ZX-150', '2025-09-28', 'Auto Generated For ZX-150', '2025-09-28', '09:46:17 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (177, 2, 3, 'Auto Generated For ZX-151', '2025-09-28', 'Auto Generated For ZX-151', '2025-09-28', '09:49:14 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (178, 2, 3, 'Auto Generated For 8287', '2025-09-28', 'Auto Generated For 8287', '2025-09-28', '09:50:10 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (179, 2, 3, 'Auto Generated For L24685', '2025-09-28', 'Auto Generated For L24685', '2025-09-28', '09:50:59 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (180, 2, 3, 'Auto Generated For 8277', '2025-09-28', 'Auto Generated For 8277', '2025-09-28', '09:52:16 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (181, 2, 3, 'Auto Generated For B2615', '2025-09-28', 'Auto Generated For B2615', '2025-09-28', '09:53:08 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (182, 2, 3, 'Auto Generated For Y2316', '2025-09-28', 'Auto Generated For Y2316', '2025-09-28', '09:53:56 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (183, 2, 3, 'Auto Generated For A-7', '2025-09-28', 'Auto Generated For A-7', '2025-09-28', '09:54:46 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (184, 2, 3, 'Auto Generated For A-4', '2025-09-28', 'Auto Generated For A-4', '2025-09-28', '09:55:43 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (185, 2, 3, 'Auto Generated For 7569-16', '2025-09-28', 'Auto Generated For 7569-16', '2025-09-28', '09:56:50 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (186, 2, 3, 'Auto Generated For MZAF-23', '2025-09-28', 'Auto Generated For MZAF-23', '2025-09-28', '10:01:31 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (187, 2, 3, 'Auto Generated For HT-90', '2025-09-28', 'Auto Generated For HT-90', '2025-09-28', '10:10:32 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (188, 2, 3, 'Auto Generated For 8586', '2025-09-28', 'Auto Generated For 8586', '2025-09-28', '10:11:19 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (189, 2, 3, 'Auto Generated For A8588-10', '2025-09-28', 'Auto Generated For A8588-10', '2025-09-28', '10:12:05 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (190, 2, 3, 'Auto Generated For 3312', '2025-09-28', 'Auto Generated For 3312', '2025-09-28', '10:13:17 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (191, 2, 3, 'Auto Generated For 68546', '2025-09-28', 'Auto Generated For 68546', '2025-09-28', '10:14:08 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (192, 2, 3, 'Auto Generated For JX-08', '2025-09-28', 'Auto Generated For JX-08', '2025-09-28', '10:14:56 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (193, 2, 3, 'Auto Generated For MY0910-15', '2025-09-28', 'Auto Generated For MY0910-15', '2025-09-28', '10:15:38 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (194, 2, 3, 'Auto Generated For HT-62', '2025-09-28', 'Auto Generated For HT-62', '2025-09-28', '10:16:17 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (195, 2, 3, 'Auto Generated For FC008', '2025-09-28', 'Auto Generated For FC008', '2025-09-28', '10:16:59 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (196, 2, 3, 'Auto Generated For 37057-2', '2025-09-28', 'Auto Generated For 37057-2', '2025-09-28', '10:17:53 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (197, 2, 3, 'Auto Generated For 55-31', '2025-09-28', 'Auto Generated For 55-31', '2025-09-28', '10:18:40 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (198, 2, 3, 'Auto Generated For 8968', '2025-09-28', 'Auto Generated For 8968', '2025-09-28', '10:19:23 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (199, 2, 3, 'Auto Generated For JYN-06', '2025-09-28', 'Auto Generated For JYN-06', '2025-09-28', '10:20:24 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (200, 2, 3, 'Auto Generated For CM8907-4', '2025-09-28', 'Auto Generated For CM8907-4', '2025-09-28', '10:21:30 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (201, 2, 3, 'Auto Generated For 2032-10', '2025-09-28', 'Auto Generated For 2032-10', '2025-09-28', '10:22:14 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (202, 2, 3, 'Auto Generated For 8520', '2025-09-28', 'Auto Generated For 8520', '2025-09-28', '10:23:22 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (203, 2, 3, 'Auto Generated For YJ302', '2025-09-28', 'Auto Generated For YJ302', '2025-09-28', '10:24:13 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (204, 2, 3, 'Auto Generated For 5016', '2025-09-28', 'Auto Generated For 5016', '2025-09-28', '10:25:19 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (205, 2, 3, 'Auto Generated For 21002', '2025-09-28', 'Auto Generated For 21002', '2025-09-28', '10:26:16 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (206, 2, 3, 'Auto Generated For 30578', '2025-09-28', 'Auto Generated For 30578', '2025-09-28', '10:27:03 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (207, 2, 3, 'Auto Generated For 3085', '2025-09-28', 'Auto Generated For 3085', '2025-09-28', '10:29:10 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (208, 2, 3, 'Auto Generated For 002#', '2025-09-28', 'Auto Generated For 002#', '2025-09-28', '10:30:24 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (209, 2, 3, 'Auto Generated For E47', '2025-09-28', 'Auto Generated For E47', '2025-09-28', '10:32:53 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (210, 2, 3, 'Auto Generated For E43', '2025-09-28', 'Auto Generated For E43', '2025-09-28', '10:33:44 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (211, 2, 3, 'Auto Generated For 4328Q', '2025-09-28', 'Auto Generated For 4328Q', '2025-09-28', '10:34:45 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (212, 2, 3, 'Auto Generated For E3', '2025-09-28', 'Auto Generated For E3', '2025-09-28', '10:35:24 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (213, 2, 3, 'Auto Generated For E10', '2025-09-28', 'Auto Generated For E10', '2025-09-28', '10:36:17 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (214, 2, 3, 'Auto Generated For C183', '2025-09-28', 'Auto Generated For C183', '2025-09-28', '10:37:26 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (215, 2, 3, 'Auto Generated For 4045', '2025-09-28', 'Auto Generated For 4045', '2025-09-28', '10:38:17 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (216, 2, 3, 'Auto Generated For E225', '2025-09-28', 'Auto Generated For E225', '2025-09-28', '10:40:02 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (217, 2, 3, 'Auto Generated For HD-088', '2025-09-28', 'Auto Generated For HD-088', '2025-09-28', '10:41:32 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (218, 2, 3, 'Auto Generated For 2131', '2025-09-28', 'Auto Generated For 2131', '2025-09-28', '10:42:32 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (219, 2, 3, 'Auto Generated For 24756', '2025-09-28', 'Auto Generated For 24756', '2025-09-28', '10:43:36 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (220, 2, 3, 'Auto Generated For 5001', '2025-09-28', 'Auto Generated For 5001', '2025-09-28', '10:44:47 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (221, 2, 3, 'Auto Generated For 8744', '2025-09-28', 'Auto Generated For 8744', '2025-09-28', '10:45:53 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (222, 2, 3, 'Auto Generated For PIN2#', '2025-09-28', 'Auto Generated For PIN2#', '2025-09-28', '10:48:57 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (223, 2, 3, 'Auto Generated For 2133', '2025-09-28', 'Auto Generated For 2133', '2025-09-28', '10:50:44 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (224, 2, 3, 'Auto Generated For 4009', '2025-09-28', 'Auto Generated For 4009', '2025-09-28', '10:51:46 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (225, 2, 3, 'Auto Generated For 2065', '2025-09-28', 'Auto Generated For 2065', '2025-09-28', '10:52:32 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (226, 2, 3, 'Auto Generated For GU055', '2025-09-28', 'Auto Generated For GU055', '2025-09-28', '10:53:15 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (227, 2, 3, 'Auto Generated For 12065', '2025-09-28', 'Auto Generated For 12065', '2025-09-28', '10:54:03 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (228, 2, 3, 'Auto Generated For 2340', '2025-09-28', 'Auto Generated For 2340', '2025-09-28', '10:54:39 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (229, 2, 3, 'Auto Generated For 1140', '2025-09-28', 'Auto Generated For 1140', '2025-09-28', '10:55:22 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (230, 2, 3, 'Auto Generated For KL-22', '2025-09-28', 'Auto Generated For KL-22', '2025-09-28', '10:56:04 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (231, 2, 3, 'Auto Generated For 30683', '2025-09-28', 'Auto Generated For 30683', '2025-09-28', '10:56:45 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (232, 2, 3, 'Auto Generated For A068', '2025-09-28', 'Auto Generated For A068', '2025-09-28', '10:57:21 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (233, 2, 3, 'Auto Generated For GU59567', '2025-09-28', 'Auto Generated For GU59567', '2025-09-28', '10:58:08 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (234, 2, 3, 'Auto Generated For 2066', '2025-09-28', 'Auto Generated For 2066', '2025-09-28', '10:58:49 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (235, 2, 3, 'Auto Generated For 6029', '2025-09-28', 'Auto Generated For 6029', '2025-09-28', '10:59:31 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (236, 2, 3, 'Auto Generated For 5015', '2025-09-28', 'Auto Generated For 5015', '2025-09-28', '11:00:16 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (237, 2, 3, 'Auto Generated For 6458-1', '2025-09-28', 'Auto Generated For 6458-1', '2025-09-28', '11:02:01 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', 1);


#
# TABLE STRUCTURE FOR: db_stockadjustmentitems
#

DROP TABLE IF EXISTS `db_stockadjustmentitems`;

CREATE TABLE `db_stockadjustmentitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `adjustment_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `adjustment_qty` double(20,2) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `purchase_id` (`adjustment_id`),
  KEY `item_id` (`item_id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB AUTO_INCREMENT=238 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (1, 2, 3, 1, 1, '15.00', 1, 'Auto Generated For 6147-G1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (2, 2, 3, 2, 2, '25.00', 1, 'Auto Generated For 2289-333T');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (3, 2, 3, 3, 3, '7.00', 1, 'Auto Generated For F89725-284');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (4, 2, 3, 4, 4, '18.00', 1, 'Auto Generated For 135-72');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (5, 2, 3, 5, 5, '26.00', 1, 'Auto Generated For 0855-190');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (6, 2, 3, 6, 6, '21.00', 1, 'Auto Generated For 135-77');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (7, 2, 3, 7, 7, '23.00', 1, 'Auto Generated For 136-92');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (8, 2, 3, 8, 8, '11.00', 1, 'Auto Generated For M1-12');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (9, 2, 3, 9, 9, '7.00', 1, 'Auto Generated For M1-11');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (10, 2, 3, 10, 10, '13.00', 1, 'Auto Generated For M1-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (11, 2, 3, 11, 11, '9.00', 1, 'Auto Generated For M1-4');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (12, 2, 3, 12, 12, '19.00', 1, 'Auto Generated For M1-5');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (13, 2, 3, 13, 13, '11.00', 1, 'Auto Generated For M1-6');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (14, 2, 3, 14, 14, '14.00', 1, 'Auto Generated For F053986-6');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (15, 2, 3, 15, 15, '13.00', 1, 'Auto Generated For M1-7');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (16, 2, 3, 16, 16, '14.00', 1, 'Auto Generated For 6147-6');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (17, 2, 3, 17, 17, '13.00', 1, 'Auto Generated For FD6466-66');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (18, 2, 3, 18, 18, '8.00', 1, 'Auto Generated For M1-3');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (19, 2, 3, 19, 19, '2.00', 1, 'Auto Generated For GN242-638');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (20, 2, 3, 20, 20, '3.00', 1, 'Auto Generated For GN242-692');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (21, 2, 3, 21, 21, '10.00', 1, 'Auto Generated For 8441-7');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (22, 2, 3, 22, 22, '12.00', 1, 'Auto Generated For M1-9');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (23, 2, 3, 23, 23, '13.00', 1, 'Auto Generated For 8441-94');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (24, 2, 3, 24, 24, '12.00', 1, 'Auto Generated For 8441-4');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (25, 2, 3, 25, 25, '14.00', 1, 'Auto Generated For 9252-D51');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (26, 2, 3, 26, 26, '18.00', 1, 'Auto Generated For 9252-10');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (27, 2, 3, 27, 27, '14.00', 1, 'Auto Generated For 9252-A15');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (28, 2, 3, 28, 28, '11.00', 1, 'Auto Generated For 8181-D90');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (29, 2, 3, 29, 29, '18.00', 1, 'Auto Generated For 8441-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (30, 2, 3, 30, 30, '19.00', 1, 'Auto Generated For 8181-G1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (31, 2, 3, 31, 31, '21.00', 1, 'Auto Generated For 8441-G1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (32, 2, 3, 32, 32, '7.00', 1, 'Auto Generated For M1-10');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (33, 2, 3, 33, 33, '10.00', 1, 'Auto Generated For M1-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (34, 2, 3, 34, 34, '48.00', 1, 'Auto Generated For A09557');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (35, 2, 3, 35, 35, '36.00', 1, 'Auto Generated For 1281');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (36, 2, 3, 36, 36, '48.00', 1, 'Auto Generated For KV-02');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (37, 2, 3, 37, 37, '6.00', 1, 'Auto Generated For QS5571');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (38, 2, 3, 38, 38, '11.00', 1, 'Auto Generated For R8621-6');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (39, 2, 3, 39, 39, '27.00', 1, 'Auto Generated For CMF36072-145A');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (40, 2, 3, 40, 40, '3.00', 1, 'Auto Generated For QGQ-210');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (41, 2, 3, 41, 41, '46.00', 1, 'Auto Generated For MY2056-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (42, 2, 3, 42, 42, '41.00', 1, 'Auto Generated For MY3700-3');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (43, 2, 3, 43, 43, '41.00', 1, 'Auto Generated For MY3700-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (44, 2, 3, 44, 44, '6.00', 1, 'Auto Generated For LX6095-17');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (45, 2, 3, 45, 45, '8.00', 1, 'Auto Generated For LX9698');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (46, 2, 3, 46, 46, '11.00', 1, 'Auto Generated For LX2041-5');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (47, 2, 3, 47, 47, '22.00', 1, 'Auto Generated For M2273-16');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (48, 2, 3, 48, 48, '30.00', 1, 'Auto Generated For 2273-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (49, 2, 3, 49, 49, '35.00', 1, 'Auto Generated For 23041-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (50, 2, 3, 50, 50, '26.00', 1, 'Auto Generated For 2944');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (51, 2, 3, 51, 51, '22.00', 1, 'Auto Generated For 7793-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (52, 2, 3, 52, 52, '42.00', 1, 'Auto Generated For 58825-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (53, 2, 3, 53, 53, '31.00', 1, 'Auto Generated For A90458-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (54, 2, 3, 54, 54, '13.00', 1, 'Auto Generated For A8602');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (55, 2, 3, 55, 55, '17.00', 1, 'Auto Generated For 8042');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (56, 2, 3, 56, 56, '7.00', 1, 'Auto Generated For 8602');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (57, 2, 3, 57, 57, '26.00', 1, 'Auto Generated For 1098-3');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (58, 2, 3, 58, 58, '30.00', 1, 'Auto Generated For 2577');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (59, 2, 3, 59, 59, '7.00', 1, 'Auto Generated For 90458');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (60, 2, 3, 60, 60, '54.00', 1, 'Auto Generated For 998');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (61, 2, 3, 61, 61, '23.00', 1, 'Auto Generated For 8438-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (62, 2, 3, 62, 62, '54.00', 1, 'Auto Generated For SP8108');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (63, 2, 3, 63, 63, '60.00', 1, 'Auto Generated For SP8109');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (64, 2, 3, 64, 64, '23.00', 1, 'Auto Generated For BL70-305');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (65, 2, 3, 65, 65, '30.00', 1, 'Auto Generated For 5722-5');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (66, 2, 3, 66, 66, '26.00', 1, 'Auto Generated For 52269');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (67, 2, 3, 67, 67, '17.00', 1, 'Auto Generated For YE452');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (68, 2, 3, 68, 68, '13.00', 1, 'Auto Generated For 3317-3');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (69, 2, 3, 69, 69, '21.00', 1, 'Auto Generated For TL-911');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (70, 2, 3, 70, 70, '6.00', 1, 'Auto Generated For Z68141');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (71, 2, 3, 71, 71, '4.00', 1, 'Auto Generated For 2877');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (72, 2, 3, 72, 72, '15.00', 1, 'Auto Generated For 8625-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (73, 2, 3, 73, 73, '25.00', 1, 'Auto Generated For 0365-0910');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (74, 2, 3, 74, 74, '17.00', 1, 'Auto Generated For ME1507');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (75, 2, 3, 75, 75, '10.00', 1, 'Auto Generated For YC-442');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (76, 2, 3, 76, 76, '5.00', 1, 'Auto Generated For 30-432');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (77, 2, 3, 77, 77, '11.00', 1, 'Auto Generated For 30-428');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (78, 2, 3, 78, 78, '12.00', 1, 'Auto Generated For 2020-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (79, 2, 3, 79, 79, '9.00', 1, 'Auto Generated For SH-12');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (80, 2, 3, 80, 80, '17.00', 1, 'Auto Generated For ME1501');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (81, 2, 3, 81, 81, '25.00', 1, 'Auto Generated For ME1514');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (82, 2, 3, 82, 82, '29.00', 1, 'Auto Generated For ME1502');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (83, 2, 3, 83, 83, '11.00', 1, 'Auto Generated For 8895-68');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (84, 2, 3, 84, 84, '35.00', 1, 'Auto Generated For 10041');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (85, 2, 3, 85, 85, '5.00', 1, 'Auto Generated For 0909-25');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (86, 2, 3, 86, 86, '7.00', 1, 'Auto Generated For 0909-27');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (87, 2, 3, 87, 87, '18.00', 1, 'Auto Generated For 30-406');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (88, 2, 3, 88, 88, '15.00', 1, 'Auto Generated For 80421-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (89, 2, 3, 89, 89, '36.00', 1, 'Auto Generated For H38');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (90, 2, 3, 90, 90, '15.00', 1, 'Auto Generated For 6296-12');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (91, 2, 3, 91, 91, '25.00', 1, 'Auto Generated For 15290');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (92, 2, 3, 92, 92, '8.00', 1, 'Auto Generated For 6038');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (93, 2, 3, 93, 93, '10.00', 1, 'Auto Generated For 2256-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (94, 2, 3, 94, 94, '26.00', 1, 'Auto Generated For 37057-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (95, 2, 3, 95, 95, '14.00', 1, 'Auto Generated For 37057');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (96, 2, 3, 96, 96, '40.00', 1, 'Auto Generated For 91349-18');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (97, 2, 3, 97, 97, '9.00', 1, 'Auto Generated For 2262-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (98, 2, 3, 98, 98, '38.00', 1, 'Auto Generated For 2321');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (99, 2, 3, 99, 99, '17.00', 1, 'Auto Generated For 5018');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (100, 2, 3, 100, 100, '33.00', 1, 'Auto Generated For 8535-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (101, 2, 3, 101, 101, '7.00', 1, 'Auto Generated For 8359');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (102, 2, 3, 102, 102, '31.00', 1, 'Auto Generated For 8101-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (103, 2, 3, 103, 103, '15.00', 1, 'Auto Generated For 52323');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (104, 2, 3, 104, 104, '8.00', 1, 'Auto Generated For 09557');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (105, 2, 3, 105, 105, '9.00', 1, 'Auto Generated For 8520');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (106, 2, 3, 106, 106, '10.00', 1, 'Auto Generated For 7769-11');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (107, 2, 3, 107, 107, '70.00', 1, 'Auto Generated For d1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (108, 2, 3, 108, 108, '25.00', 1, 'Auto Generated For d2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (109, 2, 3, 109, 109, '42.00', 1, 'Auto Generated For D3');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (110, 2, 3, 110, 110, '35.00', 1, 'Auto Generated For D4');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (111, 2, 3, 111, 111, '15.00', 1, 'Auto Generated For D8');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (112, 2, 3, 112, 112, '23.00', 1, 'Auto Generated For D9');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (113, 2, 3, 113, 113, '30.00', 1, 'Auto Generated For D10');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (114, 2, 3, 114, 114, '14.00', 1, 'Auto Generated For D11');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (115, 2, 3, 115, 115, '5.00', 1, 'Auto Generated For D14');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (116, 2, 3, 116, 116, '36.00', 1, 'Auto Generated For D15');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (117, 2, 3, 117, 117, '10.00', 1, 'Auto Generated For D7');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (118, 2, 3, 118, 118, '6.00', 1, 'Auto Generated For D12');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (119, 2, 3, 119, 119, '12.00', 1, 'Auto Generated For D16');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (120, 2, 3, 120, 120, '1.00', 1, 'Auto Generated For D17');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (121, 2, 3, 121, 121, '16.00', 1, 'Auto Generated For D18');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (122, 2, 3, 122, 122, '30.00', 1, 'Auto Generated For D19');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (123, 2, 3, 123, 123, '26.00', 1, 'Auto Generated For D20 FLAT');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (124, 2, 3, 124, 124, '27.00', 1, 'Auto Generated For D23');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (125, 2, 3, 125, 125, '25.00', 1, 'Auto Generated For D24');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (126, 2, 3, 126, 126, '10.00', 1, 'Auto Generated For D6');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (127, 2, 3, 127, 127, '23.00', 1, 'Auto Generated For D15 FLAT');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (128, 2, 3, 128, 128, '20.00', 1, 'Auto Generated For D21');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (129, 2, 3, 129, 129, '4.00', 1, 'Auto Generated For 1801');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (130, 2, 3, 130, 130, '9.00', 1, 'Auto Generated For 90047');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (131, 2, 3, 131, 131, '3.00', 1, 'Auto Generated For 9318-14');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (132, 2, 3, 132, 132, '3.00', 1, 'Auto Generated For E3402');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (133, 2, 3, 133, 133, '5.00', 1, 'Auto Generated For 52140-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (134, 2, 3, 134, 134, '36.00', 1, 'Auto Generated For OB-52');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (135, 2, 3, 135, 135, '24.00', 1, 'Auto Generated For OB-51');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (136, 2, 3, 136, 136, '28.00', 1, 'Auto Generated For OB-53');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (137, 2, 3, 137, 137, '24.00', 1, 'Auto Generated For 2412-145');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (138, 2, 3, 138, 138, '14.00', 1, 'Auto Generated For ME1442');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (139, 2, 3, 139, 139, '5.00', 1, 'Auto Generated For 30-256');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (140, 2, 3, 140, 140, '17.00', 1, 'Auto Generated For 30-255');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (141, 2, 3, 141, 141, '17.00', 1, 'Auto Generated For lw96');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (142, 2, 3, 142, 142, '16.00', 1, 'Auto Generated For QB-93');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (143, 2, 3, 143, 143, '15.00', 1, 'Auto Generated For BK-480');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (144, 2, 3, 144, 144, '25.00', 1, 'Auto Generated For 30-171');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (145, 2, 3, 145, 145, '5.00', 1, 'Auto Generated For 0318-28');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (146, 2, 3, 146, 146, '10.00', 1, 'Auto Generated For ME1477');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (147, 2, 3, 147, 147, '6.00', 1, 'Auto Generated For 9263-4');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (148, 2, 3, 148, 148, '4.00', 1, 'Auto Generated For S3377');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (149, 2, 3, 149, 149, '17.00', 1, 'Auto Generated For 2123');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (150, 2, 3, 150, 150, '5.00', 1, 'Auto Generated For 908-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (151, 2, 3, 151, 151, '4.00', 1, 'Auto Generated For 518-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (152, 2, 3, 152, 152, '20.00', 1, 'Auto Generated For B6120');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (153, 2, 3, 153, 153, '6.00', 1, 'Auto Generated For 6887-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (154, 2, 3, 154, 154, '7.00', 1, 'Auto Generated For 60074-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (155, 2, 3, 155, 155, '36.00', 1, 'Auto Generated For 58531-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (156, 2, 3, 156, 156, '4.00', 1, 'Auto Generated For 2391');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (157, 2, 3, 157, 157, '8.00', 1, 'Auto Generated For 810-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (158, 2, 3, 158, 158, '5.00', 1, 'Auto Generated For 2022');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (159, 2, 3, 159, 159, '15.00', 1, 'Auto Generated For 625-58');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (160, 2, 3, 160, 160, '16.00', 1, 'Auto Generated For 90042');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (161, 2, 3, 161, 161, '33.00', 1, 'Auto Generated For 90080');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (162, 2, 3, 162, 162, '20.00', 1, 'Auto Generated For TL-752');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (163, 2, 3, 163, 163, '4.00', 1, 'Auto Generated For 0365-6');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (164, 2, 3, 164, 164, '40.00', 1, 'Auto Generated For 8758');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (165, 2, 3, 165, 165, '40.00', 1, 'Auto Generated For 3563-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (166, 2, 3, 166, 166, '16.00', 1, 'Auto Generated For 859');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (167, 2, 3, 167, 167, '5.00', 1, 'Auto Generated For E3299');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (168, 2, 3, 168, 168, '16.00', 1, 'Auto Generated For 52271');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (169, 2, 3, 169, 169, '22.00', 1, 'Auto Generated For 025-1');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (170, 2, 3, 170, 170, '14.00', 1, 'Auto Generated For M24614');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (171, 2, 3, 171, 171, '20.00', 1, 'Auto Generated For 211');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (172, 2, 3, 172, 172, '14.00', 1, 'Auto Generated For 3297');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (173, 2, 3, 173, 173, '10.00', 1, 'Auto Generated For 2105');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (174, 2, 3, 174, 174, '4.00', 1, 'Auto Generated For G693');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (175, 2, 3, 175, 175, '8.00', 1, 'Auto Generated For G694');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (176, 2, 3, 176, 176, '12.00', 1, 'Auto Generated For ZX-150');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (177, 2, 3, 177, 177, '2.00', 1, 'Auto Generated For ZX-151');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (178, 2, 3, 178, 178, '2.00', 1, 'Auto Generated For 8287');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (179, 2, 3, 179, 179, '13.00', 1, 'Auto Generated For L24685');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (180, 2, 3, 180, 180, '8.00', 1, 'Auto Generated For 8277');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (181, 2, 3, 181, 181, '4.00', 1, 'Auto Generated For B2615');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (182, 2, 3, 182, 182, '5.00', 1, 'Auto Generated For Y2316');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (183, 2, 3, 183, 183, '11.00', 1, 'Auto Generated For A-7');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (184, 2, 3, 184, 184, '6.00', 1, 'Auto Generated For A-4');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (185, 2, 3, 185, 185, '3.00', 1, 'Auto Generated For 7569-16');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (186, 2, 3, 186, 190, '14.00', 1, 'Auto Generated For MZAF-23');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (187, 2, 3, 187, 191, '15.00', 1, 'Auto Generated For HT-90');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (188, 2, 3, 188, 192, '30.00', 1, 'Auto Generated For 8586');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (189, 2, 3, 189, 193, '25.00', 1, 'Auto Generated For A8588-10');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (190, 2, 3, 190, 194, '20.00', 1, 'Auto Generated For 3312');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (191, 2, 3, 191, 195, '4.00', 1, 'Auto Generated For 68546');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (192, 2, 3, 192, 196, '4.00', 1, 'Auto Generated For JX-08');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (193, 2, 3, 193, 197, '12.00', 1, 'Auto Generated For MY0910-15');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (194, 2, 3, 194, 198, '14.00', 1, 'Auto Generated For HT-62');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (195, 2, 3, 195, 199, '9.00', 1, 'Auto Generated For FC008');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (196, 2, 3, 196, 200, '4.00', 1, 'Auto Generated For 37057-2');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (197, 2, 3, 197, 201, '8.00', 1, 'Auto Generated For 55-31');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (198, 2, 3, 198, 202, '10.00', 1, 'Auto Generated For 8968');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (199, 2, 3, 199, 203, '7.00', 1, 'Auto Generated For JYN-06');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (200, 2, 3, 200, 204, '4.00', 1, 'Auto Generated For CM8907-4');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (201, 2, 3, 201, 205, '10.00', 1, 'Auto Generated For 2032-10');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (202, 2, 3, 202, 206, '9.00', 1, 'Auto Generated For 8520');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (203, 2, 3, 203, 207, '20.00', 1, 'Auto Generated For YJ302');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (204, 2, 3, 204, 208, '45.00', 1, 'Auto Generated For 5016');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (205, 2, 3, 205, 209, '7.00', 1, 'Auto Generated For 21002');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (206, 2, 3, 206, 210, '2.00', 1, 'Auto Generated For 30578');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (207, 2, 3, 207, 211, '6.00', 1, 'Auto Generated For 3085');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (208, 2, 3, 208, 212, '4.00', 1, 'Auto Generated For 002#');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (209, 2, 3, 209, 213, '10.00', 1, 'Auto Generated For E47');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (210, 2, 3, 210, 214, '2.00', 1, 'Auto Generated For E43');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (211, 2, 3, 211, 215, '8.00', 1, 'Auto Generated For 4328Q');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (212, 2, 3, 212, 216, '6.00', 1, 'Auto Generated For E3');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (213, 2, 3, 213, 217, '4.00', 1, 'Auto Generated For E10');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (214, 2, 3, 214, 218, '8.00', 1, 'Auto Generated For C183');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (215, 2, 3, 215, 219, '3.00', 1, 'Auto Generated For 4045');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (216, 2, 3, 216, 220, '3.00', 1, 'Auto Generated For E225');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (217, 2, 3, 217, 221, '9.00', 1, 'Auto Generated For HD-088');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (218, 2, 3, 218, 222, '3.00', 1, 'Auto Generated For 2131');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (219, 2, 3, 219, 223, '5.00', 1, 'Auto Generated For 24756');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (220, 2, 3, 220, 224, '3.00', 1, 'Auto Generated For 5001');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (221, 2, 3, 221, 225, '2.00', 1, 'Auto Generated For 8744');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (222, 2, 3, 222, 226, '9.00', 1, 'Auto Generated For PIN2#');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (223, 2, 3, 223, 227, '28.00', 1, 'Auto Generated For 2133');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (224, 2, 3, 224, 228, '10.00', 1, 'Auto Generated For 4009');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (225, 2, 3, 225, 229, '10.00', 1, 'Auto Generated For 2065');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (226, 2, 3, 226, 230, '6.00', 1, 'Auto Generated For GU055');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (227, 2, 3, 227, 231, '14.00', 1, 'Auto Generated For 12065');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (228, 2, 3, 228, 232, '2.00', 1, 'Auto Generated For 2340');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (229, 2, 3, 229, 233, '6.00', 1, 'Auto Generated For 1140');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (230, 2, 3, 230, 234, '4.00', 1, 'Auto Generated For KL-22');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (231, 2, 3, 231, 235, '7.00', 1, 'Auto Generated For 30683');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (232, 2, 3, 232, 236, '34.00', 1, 'Auto Generated For A068');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (233, 2, 3, 233, 237, '16.00', 1, 'Auto Generated For GU59567');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (234, 2, 3, 234, 238, '4.00', 1, 'Auto Generated For 2066');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (235, 2, 3, 235, 239, '3.00', 1, 'Auto Generated For 6029');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (236, 2, 3, 236, 240, '24.00', 1, 'Auto Generated For 5015');
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (237, 2, 3, 237, 241, '24.00', 1, 'Auto Generated For 6458-1');


#
# TABLE STRUCTURE FOR: db_stockentry
#

DROP TABLE IF EXISTS `db_stockentry`;

CREATE TABLE `db_stockentry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entry_date` date DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_stocktransfer
#

DROP TABLE IF EXISTS `db_stocktransfer`;

CREATE TABLE `db_stocktransfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL COMMENT 'from store',
  `to_store_id` int(11) DEFAULT NULL COMMENT 'to store transfer',
  `warehouse_from` int(11) DEFAULT NULL,
  `warehouse_to` int(11) DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `note` text CHARACTER SET latin1,
  `created_by` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_id` (`warehouse_from`),
  KEY `warehouse_to` (`warehouse_to`),
  KEY `db_stocktransfer_ibfk_4` (`to_store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_stocktransfer` (`id`, `store_id`, `to_store_id`, `warehouse_from`, `warehouse_to`, `transfer_date`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`) VALUES (1, 2, NULL, 3, 4, '2025-08-21', '', 'manager2', '2025-08-21', '09:55:27 am', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', 1);


#
# TABLE STRUCTURE FOR: db_stocktransferitems
#

DROP TABLE IF EXISTS `db_stocktransferitems`;

CREATE TABLE `db_stocktransferitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stocktransfer_id` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL COMMENT 'from store',
  `to_store_id` int(11) DEFAULT NULL COMMENT 'to store',
  `warehouse_from` int(11) DEFAULT NULL COMMENT 'warehouse ids',
  `warehouse_to` int(11) DEFAULT NULL COMMENT 'warehouse ids',
  `item_id` int(11) DEFAULT NULL,
  `transfer_qty` double(20,2) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_from` (`warehouse_from`),
  KEY `warehouse_to` (`warehouse_to`),
  KEY `stocktranfer_id` (`stocktransfer_id`),
  KEY `item_id` (`item_id`),
  KEY `db_stocktransferitems_ibfk_6` (`to_store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_stocktransferitems` (`id`, `stocktransfer_id`, `store_id`, `to_store_id`, `warehouse_from`, `warehouse_to`, `item_id`, `transfer_qty`, `status`) VALUES (1, 1, 2, NULL, 3, 4, 944, '5.00', 1);


#
# TABLE STRUCTURE FOR: db_store
#

DROP TABLE IF EXISTS `db_store`;

CREATE TABLE `db_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_code` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_website` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `website` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_logo` text COLLATE utf8_unicode_ci,
  `logo` mediumtext COLLATE utf8_unicode_ci,
  `upi_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `upi_code` text COLLATE utf8_unicode_ci,
  `country` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gst_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vat_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pan_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bank_details` mediumtext COLLATE utf8_unicode_ci,
  `cid` int(11) DEFAULT NULL,
  `category_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `supplier_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_return_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_return_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expense_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accounts_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `journal_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cust_advance_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `invoice_view` int(11) DEFAULT NULL COMMENT '1=Standard,2=Indian GST',
  `sms_status` int(11) DEFAULT NULL COMMENT '1=Enable 0=Disable',
  `status` int(11) DEFAULT NULL,
  `language_id` int(11) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `currency_placement` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `timezone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_format` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time_format` int(11) DEFAULT NULL,
  `sales_discount` double(20,4) DEFAULT NULL,
  `currencysymbol_id` int(11) DEFAULT NULL,
  `regno_key` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fav_icon` text COLLATE utf8_unicode_ci,
  `purchase_code` text COLLATE utf8_unicode_ci,
  `change_return` int(11) DEFAULT NULL,
  `sales_invoice_format_id` int(11) DEFAULT NULL,
  `pos_invoice_format_id` int(11) DEFAULT NULL,
  `sales_invoice_footer_text` text COLLATE utf8_unicode_ci,
  `round_off` int(11) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quotation_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `decimals` int(11) DEFAULT '2',
  `money_transfer_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_payment_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_return_payment_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_payment_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_return_payment_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expense_payment_init` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `current_subscriptionlist_id` int(11) DEFAULT '0',
  `smtp_host` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smtp_port` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smtp_user` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smtp_pass` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smtp_status` int(11) DEFAULT '0',
  `sms_url` text COLLATE utf8_unicode_ci,
  `user_id` int(11) NOT NULL,
  `mrp_column` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_store` (`id`, `store_code`, `store_name`, `store_website`, `mobile`, `phone`, `email`, `website`, `store_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `accounts_init`, `journal_init`, `cust_advance_init`, `invoice_view`, `sms_status`, `status`, `language_id`, `currency_id`, `currency_placement`, `timezone`, `date_format`, `time_format`, `sales_discount`, `currencysymbol_id`, `regno_key`, `fav_icon`, `purchase_code`, `change_return`, `sales_invoice_format_id`, `pos_invoice_format_id`, `sales_invoice_footer_text`, `round_off`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `quotation_init`, `decimals`, `money_transfer_init`, `sales_payment_init`, `sales_return_payment_init`, `purchase_payment_init`, `purchase_return_payment_init`, `expense_payment_init`, `current_subscriptionlist_id`, `smtp_host`, `smtp_port`, `smtp_user`, `smtp_pass`, `smtp_status`, `sms_url`, `user_id`, `mrp_column`) VALUES (1, 'ST0001', 'SAAS ADMIN', '', '+919999999999', '', 'admin@example.com', 'www', 'uploads/store/company_logo.png', NULL, NULL, NULL, 'India', 'Karnataka', 'Bengalore', 'Gandhi Road', '', '', '', '', '', NULL, 'CT/01/', 'IT01', 'SU/01/', 'PU/2020/01', 'PR/2020/01/', 'CU/01/', 'SL/2020/01/', 'SR/2020/01/', 'EX/2020/01/', 'AC/01/', 'JE', 'ADV', 1, 0, 1, 1, 35, 'Left', 'Asia/Kolkata\r\n', 'dd-mm-yyyy', 12, '0.0000', NULL, NULL, NULL, NULL, 1, 3, 1, 'Its Footer, You can change it from Store Settings.', 0, NULL, NULL, NULL, NULL, NULL, 'QT/2020/01/', 2, 'MT/01/', 'SP/2020/01/', 'SRP/2020/01/', 'PP/2020/01/', 'PRP/2020/01/', 'XP/2020/01/', 26, 'ssl://smtp.gmail.com', '465', 'salmanpathanindia@gmail.com', '9632563672', 1, 'http://sms.proware.in/api/sendhttp.php?authkey=248050Asbku6K75bf27efc&amp;mobiles={{MOBILE}}&amp;message={{MESSAGE}}&amp;sender=WBMGIC&amp;route=4', 0, 0);
INSERT INTO `db_store` (`id`, `store_code`, `store_name`, `store_website`, `mobile`, `phone`, `email`, `website`, `store_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `accounts_init`, `journal_init`, `cust_advance_init`, `invoice_view`, `sms_status`, `status`, `language_id`, `currency_id`, `currency_placement`, `timezone`, `date_format`, `time_format`, `sales_discount`, `currencysymbol_id`, `regno_key`, `fav_icon`, `purchase_code`, `change_return`, `sales_invoice_format_id`, `pos_invoice_format_id`, `sales_invoice_footer_text`, `round_off`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `quotation_init`, `decimals`, `money_transfer_init`, `sales_payment_init`, `sales_return_payment_init`, `purchase_payment_init`, `purchase_return_payment_init`, `expense_payment_init`, `current_subscriptionlist_id`, `smtp_host`, `smtp_port`, `smtp_user`, `smtp_pass`, `smtp_status`, `sms_url`, `user_id`, `mrp_column`) VALUES (2, 'ST0002', 'Quotation to ', '', '+96897759659', '', '.', NULL, 'uploads/store/logo3.jpg', NULL, NULL, NULL, 'Oman', '', 'Suhar', 'Suhar\r\n', '700', '', '1703156', '', '', NULL, 'CT/01/', 'SHO', 'SU/01/', 'PO', 'PR/2025/01/', 'CU/01/', 'SL/', 'SR/2025/01/', 'EX/2025/01/', 'AC/01/', NULL, 'ADV', 1, 2, 1, 1, 55, 'Left', 'Asia/Muscat\r\n', 'dd-mm-yyyy', 12, '0.0000', NULL, NULL, NULL, NULL, 1, 3, 1, 'This is footer text. It is in Store Management.', 0, '2021-02-12', '05:53:37 pm', '', '127.0.0.1', 'LAPTOP-I5OUIM4R', 'QT/2025/01/', 3, 'MT/01/', 'SP/2025/01/', 'SRP/2025/01/', 'PP/2025/01/', 'PRP/2025/01/', 'XP/2025/01/', 28, NULL, NULL, NULL, NULL, 0, NULL, 0, 0);


#
# TABLE STRUCTURE FOR: db_stripe
#

DROP TABLE IF EXISTS `db_stripe`;

CREATE TABLE `db_stripe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sandbox` int(11) DEFAULT NULL,
  `publishable_key` text CHARACTER SET utf8,
  `api_secret` text CHARACTER SET utf8,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_stripepayments
#

DROP TABLE IF EXISTS `db_stripepayments`;

CREATE TABLE `db_stripepayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `buyer_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `buyer_email` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `paid_amount` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `paid_amount_currency` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `txn_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `payment_status` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_subscription
#

DROP TABLE IF EXISTS `db_subscription`;

CREATE TABLE `db_subscription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `payment_id` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `package_id` int(11) DEFAULT NULL,
  `package_type` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `package_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `description` text CHARACTER SET utf8,
  `subscription_date` date DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `trial_days` int(11) DEFAULT NULL,
  `max_users` int(11) DEFAULT NULL,
  `max_warehouses` int(11) DEFAULT NULL,
  `max_items` int(11) DEFAULT NULL,
  `max_invoices` int(11) DEFAULT NULL,
  `payment_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `txn_id` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `payment_gross` double(10,2) DEFAULT NULL,
  `currency_code` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `payer_email` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `payment_status` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `package_status` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`) VALUES (13, 22, NULL, 2, NULL, 'Regular', 'Test description', '2021-01-25', NULL, 15, 20, 20, 200, 200, 'PayPal', '48R18927X78299709', '250.00', 'USD', 'sb-9fy504805522@business.example.com', 'Pending', '2021-01-25', '01:30:45 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`) VALUES (14, 22, NULL, 2, 'Paid', 'Regular', 'Test description', '2021-01-25', NULL, 15, 20, 20, 200, 200, 'PayPal', '9M838440FH9266015', '250.00', 'USD', 'sb-9fy504805522@business.example.com', 'Pending', '2021-01-25', '01:32:28 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`) VALUES (16, 22, NULL, 2, 'Paid', 'Regular', 'Test description', '2021-01-25', '2021-02-25', 15, 20, 20, 200, 200, 'PayPal', '2PT61144W90213341', '250.00', 'USD', 'sb-9fy504805522@business.example.com', 'Pending', '2021-01-25', '02:00:38 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`) VALUES (26, 1, NULL, 1, 'Free', 'Free', 'Test description', '2021-01-25', '2021-02-04', 10, 2, 2, 20, 20, 'Self', '', '0.00', '', '', '', '2021-01-25', '06:32:32 pm', 'admin', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`) VALUES (27, 24, NULL, 1, 'Free', 'Free', 'Test description', '2021-02-11', '2021-02-21', 10, 2, 2, 20, 20, 'Self', '', '0.00', '', '', '', '2021-02-11', '03:09:47 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`) VALUES (28, 2, NULL, 1, 'Free', 'Free', 'Test description', '2021-02-12', '2021-02-22', 10, 2, 2, 20, 20, 'Self', '', '0.00', '', '', '', '2021-02-12', '06:57:18 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL);


#
# TABLE STRUCTURE FOR: db_supplier_payments
#

DROP TABLE IF EXISTS `db_supplier_payments`;

CREATE TABLE `db_supplier_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchasepayment_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8,
  `system_ip` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `purchasepayment_id` (`purchasepayment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_suppliers
#

DROP TABLE IF EXISTS `db_suppliers`;

CREATE TABLE `db_suppliers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create supplier Code',
  `supplier_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gstin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vatin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opening_balance` double(20,4) DEFAULT NULL,
  `purchase_due` double(20,4) DEFAULT NULL,
  `purchase_return_due` double(20,4) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `city` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postcode` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_suppliers` (`id`, `store_id`, `count_id`, `supplier_code`, `supplier_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `purchase_due`, `purchase_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`) VALUES (1, 2, 1, 'SU/02/0001', 'Mine', '', '', '', '', '', NULL, '0.0000', '0.0000', '0.0000', 0, 0, '', '', '', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', '2025-05-27', '11:37:41 am', 'sohar', NULL, 1);
INSERT INTO `db_suppliers` (`id`, `store_id`, `count_id`, `supplier_code`, `supplier_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `purchase_due`, `purchase_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`) VALUES (2, 2, 2, 'SU/02/0002', 'Jeery Pine', '', '', '', '', '', NULL, '0.0000', '0.0000', '0.0000', 0, 0, '', '', '', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', '2025-05-29', '10:24:36 am', 'sohar', NULL, 1);
INSERT INTO `db_suppliers` (`id`, `store_id`, `count_id`, `supplier_code`, `supplier_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `purchase_due`, `purchase_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`) VALUES (3, 2, 3, 'SU/02/0003', 'INDIA', '', '', '', '', '', NULL, '0.0000', '7621.2900', '0.0000', 0, 0, '', '', '', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', '2025-06-15', '07:03:36 pm', 'sohar', NULL, 1);


#
# TABLE STRUCTURE FOR: db_tax
#

DROP TABLE IF EXISTS `db_tax`;

CREATE TABLE `db_tax` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `tax_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax` double(20,4) DEFAULT NULL,
  `group_bit` int(11) DEFAULT NULL COMMENT '1=Yes, 0=No',
  `subtax_ids` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Tax groups IDs',
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_tax` (`id`, `store_id`, `tax_name`, `tax`, `group_bit`, `subtax_ids`, `status`) VALUES (151, 2, 'Zero', '0.0000', NULL, NULL, 1);
INSERT INTO `db_tax` (`id`, `store_id`, `tax_name`, `tax`, `group_bit`, `subtax_ids`, `status`) VALUES (152, 2, 'percentage', '5.0000', NULL, NULL, 1);


#
# TABLE STRUCTURE FOR: db_timezone
#

DROP TABLE IF EXISTS `db_timezone`;

CREATE TABLE `db_timezone` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timezone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=549 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (1, 'Africa/Abidjan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (2, 'Africa/Accra\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (3, 'Africa/Addis_Ababa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (4, 'Africa/Algiers\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (5, 'Africa/Asmara\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (6, 'Africa/Asmera\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (7, 'Africa/Bamako\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (8, 'Africa/Bangui\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (9, 'Africa/Banjul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (10, 'Africa/Bissau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (11, 'Africa/Blantyre\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (12, 'Africa/Brazzaville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (13, 'Africa/Bujumbura\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (14, 'Africa/Cairo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (15, 'Africa/Casablanca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (16, 'Africa/Ceuta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (17, 'Africa/Conakry\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (18, 'Africa/Dakar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (19, 'Africa/Dar_es_Salaam\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (20, 'Africa/Djibouti\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (21, 'Africa/Douala\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (22, 'Africa/El_Aaiun\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (23, 'Africa/Freetown\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (24, 'Africa/Gaborone\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (25, 'Africa/Harare\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (26, 'Africa/Johannesburg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (27, 'Africa/Juba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (28, 'Africa/Kampala\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (29, 'Africa/Khartoum\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (30, 'Africa/Kigali\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (31, 'Africa/Kinshasa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (32, 'Africa/Lagos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (33, 'Africa/Libreville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (34, 'Africa/Lome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (35, 'Africa/Luanda\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (36, 'Africa/Lubumbashi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (37, 'Africa/Lusaka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (38, 'Africa/Malabo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (39, 'Africa/Maputo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (40, 'Africa/Maseru\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (41, 'Africa/Mbabane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (42, 'Africa/Mogadishu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (43, 'Africa/Monrovia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (44, 'Africa/Nairobi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (45, 'Africa/Ndjamena\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (46, 'Africa/Niamey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (47, 'Africa/Nouakchott\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (48, 'Africa/Ouagadougou\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (49, 'Africa/Porto-Novo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (50, 'Africa/Sao_Tome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (51, 'Africa/Timbuktu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (52, 'Africa/Tripoli\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (53, 'Africa/Tunis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (54, 'Africa/Windhoek\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (55, 'AKST9AKDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (56, 'America/Adak\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (57, 'America/Anchorage\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (58, 'America/Anguilla\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (59, 'America/Antigua\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (60, 'America/Araguaina\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (61, 'America/Argentina/Buenos_Aires\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (62, 'America/Argentina/Catamarca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (63, 'America/Argentina/ComodRivadavia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (64, 'America/Argentina/Cordoba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (65, 'America/Argentina/Jujuy\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (66, 'America/Argentina/La_Rioja\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (67, 'America/Argentina/Mendoza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (68, 'America/Argentina/Rio_Gallegos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (69, 'America/Argentina/Salta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (70, 'America/Argentina/San_Juan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (71, 'America/Argentina/San_Luis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (72, 'America/Argentina/Tucuman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (73, 'America/Argentina/Ushuaia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (74, 'America/Aruba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (75, 'America/Asuncion\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (76, 'America/Atikokan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (77, 'America/Atka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (78, 'America/Bahia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (79, 'America/Bahia_Banderas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (80, 'America/Barbados\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (81, 'America/Belem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (82, 'America/Belize\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (83, 'America/Blanc-Sablon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (84, 'America/Boa_Vista\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (85, 'America/Bogota\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (86, 'America/Boise\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (87, 'America/Buenos_Aires\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (88, 'America/Cambridge_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (89, 'America/Campo_Grande\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (90, 'America/Cancun\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (91, 'America/Caracas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (92, 'America/Catamarca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (93, 'America/Cayenne\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (94, 'America/Cayman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (95, 'America/Chicago\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (96, 'America/Chihuahua\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (97, 'America/Coral_Harbour\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (98, 'America/Cordoba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (99, 'America/Costa_Rica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (100, 'America/Creston\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (101, 'America/Cuiaba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (102, 'America/Curacao\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (103, 'America/Danmarkshavn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (104, 'America/Dawson\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (105, 'America/Dawson_Creek\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (106, 'America/Denver\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (107, 'America/Detroit\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (108, 'America/Dominica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (109, 'America/Edmonton\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (110, 'America/Eirunepe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (111, 'America/El_Salvador\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (112, 'America/Ensenada\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (113, 'America/Fort_Wayne\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (114, 'America/Fortaleza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (115, 'America/Glace_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (116, 'America/Godthab\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (117, 'America/Goose_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (118, 'America/Grand_Turk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (119, 'America/Grenada\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (120, 'America/Guadeloupe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (121, 'America/Guatemala\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (122, 'America/Guayaquil\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (123, 'America/Guyana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (124, 'America/Halifax\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (125, 'America/Havana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (126, 'America/Hermosillo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (127, 'America/Indiana/Indianapolis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (128, 'America/Indiana/Knox\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (129, 'America/Indiana/Marengo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (130, 'America/Indiana/Petersburg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (131, 'America/Indiana/Tell_City\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (132, 'America/Indiana/Vevay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (133, 'America/Indiana/Vincennes\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (134, 'America/Indiana/Winamac\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (135, 'America/Indianapolis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (136, 'America/Inuvik\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (137, 'America/Iqaluit\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (138, 'America/Jamaica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (139, 'America/Jujuy\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (140, 'America/Juneau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (141, 'America/Kentucky/Louisville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (142, 'America/Kentucky/Monticello\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (143, 'America/Knox_IN\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (144, 'America/Kralendijk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (145, 'America/La_Paz\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (146, 'America/Lima\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (147, 'America/Los_Angeles\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (148, 'America/Louisville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (149, 'America/Lower_Princes\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (150, 'America/Maceio\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (151, 'America/Managua\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (152, 'America/Manaus\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (153, 'America/Marigot\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (154, 'America/Martinique\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (155, 'America/Matamoros\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (156, 'America/Mazatlan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (157, 'America/Mendoza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (158, 'America/Menominee\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (159, 'America/Merida\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (160, 'America/Metlakatla\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (161, 'America/Mexico_City\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (162, 'America/Miquelon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (163, 'America/Moncton\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (164, 'America/Monterrey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (165, 'America/Montevideo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (166, 'America/Montreal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (167, 'America/Montserrat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (168, 'America/Nassau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (169, 'America/New_York\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (170, 'America/Nipigon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (171, 'America/Nome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (172, 'America/Noronha\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (173, 'America/North_Dakota/Beulah\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (174, 'America/North_Dakota/Center\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (175, 'America/North_Dakota/New_Salem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (176, 'America/Ojinaga\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (177, 'America/Panama\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (178, 'America/Pangnirtung\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (179, 'America/Paramaribo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (180, 'America/Phoenix\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (181, 'America/Port_of_Spain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (182, 'America/Port-au-Prince\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (183, 'America/Porto_Acre\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (184, 'America/Porto_Velho\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (185, 'America/Puerto_Rico\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (186, 'America/Rainy_River\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (187, 'America/Rankin_Inlet\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (188, 'America/Recife\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (189, 'America/Regina\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (190, 'America/Resolute\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (191, 'America/Rio_Branco\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (192, 'America/Rosario\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (193, 'America/Santa_Isabel\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (194, 'America/Santarem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (195, 'America/Santiago\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (196, 'America/Santo_Domingo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (197, 'America/Sao_Paulo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (198, 'America/Scoresbysund\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (199, 'America/Shiprock\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (200, 'America/Sitka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (201, 'America/St_Barthelemy\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (202, 'America/St_Johns\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (203, 'America/St_Kitts\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (204, 'America/St_Lucia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (205, 'America/St_Thomas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (206, 'America/St_Vincent\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (207, 'America/Swift_Current\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (208, 'America/Tegucigalpa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (209, 'America/Thule\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (210, 'America/Thunder_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (211, 'America/Tijuana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (212, 'America/Toronto\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (213, 'America/Tortola\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (214, 'America/Vancouver\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (215, 'America/Virgin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (216, 'America/Whitehorse\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (217, 'America/Winnipeg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (218, 'America/Yakutat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (219, 'America/Yellowknife\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (220, 'Antarctica/Casey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (221, 'Antarctica/Davis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (222, 'Antarctica/DumontDUrville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (223, 'Antarctica/Macquarie\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (224, 'Antarctica/Mawson\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (225, 'Antarctica/McMurdo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (226, 'Antarctica/Palmer\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (227, 'Antarctica/Rothera\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (228, 'Antarctica/South_Pole\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (229, 'Antarctica/Syowa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (230, 'Antarctica/Vostok\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (231, 'Arctic/Longyearbyen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (232, 'Asia/Aden\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (233, 'Asia/Almaty\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (234, 'Asia/Amman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (235, 'Asia/Anadyr\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (236, 'Asia/Aqtau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (237, 'Asia/Aqtobe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (238, 'Asia/Ashgabat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (239, 'Asia/Ashkhabad\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (240, 'Asia/Baghdad\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (241, 'Asia/Bahrain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (242, 'Asia/Baku\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (243, 'Asia/Bangkok\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (244, 'Asia/Beirut\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (245, 'Asia/Bishkek\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (246, 'Asia/Brunei\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (247, 'Asia/Calcutta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (248, 'Asia/Choibalsan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (249, 'Asia/Chongqing\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (250, 'Asia/Chungking\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (251, 'Asia/Colombo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (252, 'Asia/Dacca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (253, 'Asia/Damascus\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (254, 'Asia/Dhaka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (255, 'Asia/Dili\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (256, 'Asia/Dubai\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (257, 'Asia/Dushanbe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (258, 'Asia/Gaza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (259, 'Asia/Harbin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (260, 'Asia/Hebron\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (261, 'Asia/Ho_Chi_Minh\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (262, 'Asia/Hong_Kong\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (263, 'Asia/Hovd\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (264, 'Asia/Irkutsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (265, 'Asia/Istanbul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (266, 'Asia/Jakarta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (267, 'Asia/Jayapura\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (268, 'Asia/Jerusalem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (269, 'Asia/Kabul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (270, 'Asia/Kamchatka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (271, 'Asia/Karachi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (272, 'Asia/Kashgar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (273, 'Asia/Kathmandu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (274, 'Asia/Katmandu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (275, 'Asia/Kolkata\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (276, 'Asia/Krasnoyarsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (277, 'Asia/Kuala_Lumpur\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (278, 'Asia/Kuching\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (279, 'Asia/Kuwait\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (280, 'Asia/Macao\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (281, 'Asia/Macau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (282, 'Asia/Magadan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (283, 'Asia/Makassar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (284, 'Asia/Manila\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (285, 'Asia/Muscat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (286, 'Asia/Nicosia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (287, 'Asia/Novokuznetsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (288, 'Asia/Novosibirsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (289, 'Asia/Omsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (290, 'Asia/Oral\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (291, 'Asia/Phnom_Penh\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (292, 'Asia/Pontianak\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (293, 'Asia/Pyongyang\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (294, 'Asia/Qatar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (295, 'Asia/Qyzylorda\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (296, 'Asia/Rangoon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (297, 'Asia/Riyadh\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (298, 'Asia/Saigon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (299, 'Asia/Sakhalin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (300, 'Asia/Samarkand\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (301, 'Asia/Seoul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (302, 'Asia/Shanghai\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (303, 'Asia/Singapore\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (304, 'Asia/Taipei\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (305, 'Asia/Tashkent\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (306, 'Asia/Tbilisi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (307, 'Asia/Tehran\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (308, 'Asia/Tel_Aviv\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (309, 'Asia/Thimbu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (310, 'Asia/Thimphu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (311, 'Asia/Tokyo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (312, 'Asia/Ujung_Pandang\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (313, 'Asia/Ulaanbaatar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (314, 'Asia/Ulan_Bator\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (315, 'Asia/Urumqi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (316, 'Asia/Vientiane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (317, 'Asia/Vladivostok\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (318, 'Asia/Yakutsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (319, 'Asia/Yekaterinburg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (320, 'Asia/Yerevan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (321, 'Atlantic/Azores\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (322, 'Atlantic/Bermuda\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (323, 'Atlantic/Canary\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (324, 'Atlantic/Cape_Verde\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (325, 'Atlantic/Faeroe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (326, 'Atlantic/Faroe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (327, 'Atlantic/Jan_Mayen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (328, 'Atlantic/Madeira\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (329, 'Atlantic/Reykjavik\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (330, 'Atlantic/South_Georgia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (331, 'Atlantic/St_Helena\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (332, 'Atlantic/Stanley\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (333, 'Australia/ACT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (334, 'Australia/Adelaide\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (335, 'Australia/Brisbane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (336, 'Australia/Broken_Hill\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (337, 'Australia/Canberra\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (338, 'Australia/Currie\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (339, 'Australia/Darwin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (340, 'Australia/Eucla\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (341, 'Australia/Hobart\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (342, 'Australia/LHI\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (343, 'Australia/Lindeman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (344, 'Australia/Lord_Howe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (345, 'Australia/Melbourne\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (346, 'Australia/North\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (347, 'Australia/NSW\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (348, 'Australia/Perth\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (349, 'Australia/Queensland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (350, 'Australia/South\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (351, 'Australia/Sydney\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (352, 'Australia/Tasmania\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (353, 'Australia/Victoria\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (354, 'Australia/West\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (355, 'Australia/Yancowinna\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (356, 'Brazil/Acre\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (357, 'Brazil/DeNoronha\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (358, 'Brazil/East\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (359, 'Brazil/West\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (360, 'Canada/Atlantic\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (361, 'Canada/Central\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (362, 'Canada/Eastern\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (363, 'Canada/East-Saskatchewan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (364, 'Canada/Mountain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (365, 'Canada/Newfoundland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (366, 'Canada/Pacific\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (367, 'Canada/Saskatchewan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (368, 'Canada/Yukon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (369, 'CET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (370, 'Chile/Continental\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (371, 'Chile/EasterIsland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (372, 'CST6CDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (373, 'Cuba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (374, 'EET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (375, 'Egypt\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (376, 'Eire\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (377, 'EST\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (378, 'EST5EDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (379, 'Etc./GMT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (380, 'Etc./GMT+0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (381, 'Etc./UCT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (382, 'Etc./Universal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (383, 'Etc./UTC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (384, 'Etc./Zulu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (385, 'Europe/Amsterdam\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (386, 'Europe/Andorra\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (387, 'Europe/Athens\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (388, 'Europe/Belfast\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (389, 'Europe/Belgrade\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (390, 'Europe/Berlin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (391, 'Europe/Bratislava\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (392, 'Europe/Brussels\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (393, 'Europe/Bucharest\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (394, 'Europe/Budapest\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (395, 'Europe/Chisinau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (396, 'Europe/Copenhagen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (397, 'Europe/Dublin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (398, 'Europe/Gibraltar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (399, 'Europe/Guernsey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (400, 'Europe/Helsinki\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (401, 'Europe/Isle_of_Man\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (402, 'Europe/Istanbul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (403, 'Europe/Jersey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (404, 'Europe/Kaliningrad\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (405, 'Europe/Kiev\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (406, 'Europe/Lisbon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (407, 'Europe/Ljubljana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (408, 'Europe/London\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (409, 'Europe/Luxembourg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (410, 'Europe/Madrid\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (411, 'Europe/Malta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (412, 'Europe/Mariehamn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (413, 'Europe/Minsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (414, 'Europe/Monaco\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (415, 'Europe/Moscow\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (416, 'Europe/Nicosia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (417, 'Europe/Oslo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (418, 'Europe/Paris\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (419, 'Europe/Podgorica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (420, 'Europe/Prague\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (421, 'Europe/Riga\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (422, 'Europe/Rome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (423, 'Europe/Samara\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (424, 'Europe/San_Marino\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (425, 'Europe/Sarajevo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (426, 'Europe/Simferopol\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (427, 'Europe/Skopje\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (428, 'Europe/Sofia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (429, 'Europe/Stockholm\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (430, 'Europe/Tallinn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (431, 'Europe/Tirane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (432, 'Europe/Tiraspol\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (433, 'Europe/Uzhgorod\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (434, 'Europe/Vaduz\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (435, 'Europe/Vatican\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (436, 'Europe/Vienna\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (437, 'Europe/Vilnius\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (438, 'Europe/Volgograd\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (439, 'Europe/Warsaw\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (440, 'Europe/Zagreb\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (441, 'Europe/Zaporozhye\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (442, 'Europe/Zurich\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (443, 'GB\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (444, 'GB-Eire\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (445, 'GMT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (446, 'GMT+0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (447, 'GMT0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (448, 'GMT-0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (449, 'Greenwich\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (450, 'Hong Kong\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (451, 'HST\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (452, 'Iceland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (453, 'Indian/Antananarivo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (454, 'Indian/Chagos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (455, 'Indian/Christmas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (456, 'Indian/Cocos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (457, 'Indian/Comoro\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (458, 'Indian/Kerguelen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (459, 'Indian/Mahe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (460, 'Indian/Maldives\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (461, 'Indian/Mauritius\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (462, 'Indian/Mayotte\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (463, 'Indian/Reunion\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (464, 'Iran\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (465, 'Israel\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (466, 'Jamaica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (467, 'Japan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (468, 'JST-9\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (469, 'Kwajalein\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (470, 'Libya\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (471, 'MET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (472, 'Mexico/BajaNorte\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (473, 'Mexico/BajaSur\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (474, 'Mexico/General\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (475, 'MST\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (476, 'MST7MDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (477, 'Navajo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (478, 'NZ\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (479, 'NZ-CHAT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (480, 'Pacific/Apia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (481, 'Pacific/Auckland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (482, 'Pacific/Chatham\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (483, 'Pacific/Chuuk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (484, 'Pacific/Easter\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (485, 'Pacific/Efate\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (486, 'Pacific/Enderbury\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (487, 'Pacific/Fakaofo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (488, 'Pacific/Fiji\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (489, 'Pacific/Funafuti\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (490, 'Pacific/Galapagos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (491, 'Pacific/Gambier\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (492, 'Pacific/Guadalcanal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (493, 'Pacific/Guam\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (494, 'Pacific/Honolulu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (495, 'Pacific/Johnston\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (496, 'Pacific/Kiritimati\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (497, 'Pacific/Kosrae\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (498, 'Pacific/Kwajalein\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (499, 'Pacific/Majuro\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (500, 'Pacific/Marquesas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (501, 'Pacific/Midway\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (502, 'Pacific/Nauru\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (503, 'Pacific/Niue\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (504, 'Pacific/Norfolk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (505, 'Pacific/Noumea\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (506, 'Pacific/Pago_Pago\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (507, 'Pacific/Palau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (508, 'Pacific/Pitcairn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (509, 'Pacific/Pohnpei\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (510, 'Pacific/Ponape\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (511, 'Pacific/Port_Moresby\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (512, 'Pacific/Rarotonga\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (513, 'Pacific/Saipan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (514, 'Pacific/Samoa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (515, 'Pacific/Tahiti\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (516, 'Pacific/Tarawa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (517, 'Pacific/Tongatapu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (518, 'Pacific/Truk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (519, 'Pacific/Wake\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (520, 'Pacific/Wallis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (521, 'Pacific/Yap\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (522, 'Poland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (523, 'Portugal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (524, 'PRC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (525, 'PST8PDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (526, 'ROC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (527, 'ROK\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (528, 'Singapore\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (529, 'Turkey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (530, 'UCT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (531, 'Universal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (532, 'US/Alaska\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (533, 'US/Aleutian\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (534, 'US/Arizona\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (535, 'US/Central\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (536, 'US/Eastern\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (537, 'US/East-Indiana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (538, 'US/Hawaii\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (539, 'US/Indiana-Starke\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (540, 'US/Michigan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (541, 'US/Mountain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (542, 'US/Pacific\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (543, 'US/Pacific-New\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (544, 'US/Samoa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (545, 'UTC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (546, 'WET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (547, 'W-SU\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (548, 'Zulu\r', 1);


#
# TABLE STRUCTURE FOR: db_twilio
#

DROP TABLE IF EXISTS `db_twilio`;

CREATE TABLE `db_twilio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `account_sid` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `auth_token` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `twilio_phone` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_twilio` (`id`, `store_id`, `account_sid`, `auth_token`, `twilio_phone`, `status`) VALUES (1, 1, '', '', '', 0);
INSERT INTO `db_twilio` (`id`, `store_id`, `account_sid`, `auth_token`, `twilio_phone`, `status`) VALUES (3, 2, '', '', '', 0);


#
# TABLE STRUCTURE FOR: db_units
#

DROP TABLE IF EXISTS `db_units`;

CREATE TABLE `db_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `unit_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (1, 2, 'Box', '', NULL, 1);
INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (2, 2, 'PC', '', NULL, 1);
INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (3, 2, 'PIECES', '', NULL, 1);
INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (4, 2, 'MTR', '', NULL, 1);
INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (5, 2, 'ROLL', '', NULL, 1);
INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (8, 2, 'Cartoon', '', NULL, 1);
INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (9, 2, 'Dozen', 'pair of shoes X 12', NULL, 1);


#
# TABLE STRUCTURE FOR: db_users
#

DROP TABLE IF EXISTS `db_users`;

CREATE TABLE `db_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `username` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `first_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` blob,
  `member_of` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `firstname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photo` blob,
  `gender` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `country` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` blob,
  `postcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `role_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `profile_picture` text COLLATE utf8_unicode_ci,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` double DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `updater_id` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (1, 1, 'Admin', 'Super', 'Power', 'e10adc3949ba59abbe56e057f20f883e', '', NULL, NULL, '', 'super@example.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'uploads/users/admin.png', '2018-11-27', '::1', NULL, NULL, NULL, '0', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (2, 2, 'Admin', 'User', ' ', '1c0a97935fcb6ea239507a1be91993cb', NULL, NULL, NULL, '9999999999', 'admin@baramiij.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, 'uploads/users/avatar1.png', '2021-02-12', '05:53:37 pm', '', '127.0.0.1', 'LAPTOP-I5OUIM4R', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (4, 2, 'Liwa', 'Liwa', 'Sales', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '12345678', 'liwa@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, '2022-07-17', '10:30:46 am', 'Admin', '5.21.204.178', 'dynamic.isp.ooredoo.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (13, 2, 'sohar', NULL, 'sales', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'sohar@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, '2025-05-25', '05:15:39 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (14, 2, 'ibri', NULL, 'sales', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'ibri@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, '2025-05-25', '05:26:46 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (15, 2, 'saham', NULL, 'sales', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'saham@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, '2025-05-25', '05:35:39 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (16, 2, 'Suwaiq', NULL, 'sales', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'Suwaiq@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, '2025-05-25', '05:54:10 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (17, 2, 'muscat', NULL, 'sales', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'muscat@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, '2025-05-25', '06:17:20 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (18, 2, 'surr', NULL, 'sales', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'sur@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, '2025-05-26', '12:07:53 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (19, 2, 'salalah', NULL, 'sales', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'salalah@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, '2025-05-26', '12:17:30 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (20, 2, 'manager1', NULL, ' ', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'manager1@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4, NULL, '2025-05-26', '06:01:49 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (21, 2, 'manager2', NULL, ' ', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'manager2@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4, 'uploads/users/Muhammed_11.gif', '2025-05-26', '06:03:14 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (22, 2, 'Suhar', NULL, 'DM2', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'Suhardm2@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3, NULL, '2025-06-11', '03:32:25 pm', 'manager2', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (23, 2, 'Haroon', NULL, ' ', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'haroon@bedots.io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5, NULL, '2025-06-16', '04:47:37 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`) VALUES (24, 2, 'testt', NULL, 'manager', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'test@test.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4, NULL, '2025-07-30', '05:40:40 pm', 'Admin', '159.48.9.159', 'static-host-159-48-9-159.awasr.om', '1', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: db_userswarehouses
#

DROP TABLE IF EXISTS `db_userswarehouses`;

CREATE TABLE `db_userswarehouses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (4, 6, 2);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (8, 5, 5);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (9, 6, 6);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (10, 7, 7);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (11, 8, 8);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (12, 9, 9);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (13, 10, 10);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (41, 3, 4);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (42, 13, 4);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (43, 14, 5);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (44, 15, 6);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (45, 16, 7);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (46, 17, 8);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (47, 18, 9);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (48, 19, 10);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (49, 12, 2);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (50, 12, 3);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (51, 12, 4);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (52, 12, 5);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (53, 12, 6);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (54, 12, 7);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (55, 12, 8);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (56, 12, 9);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (57, 12, 10);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (58, 11, 2);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (59, 11, 3);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (60, 11, 4);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (61, 11, 5);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (62, 11, 6);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (63, 11, 7);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (64, 11, 8);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (65, 11, 9);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (66, 11, 10);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (67, 20, 3);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (68, 20, 4);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (69, 20, 5);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (70, 20, 6);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (71, 20, 7);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (72, 20, 8);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (73, 20, 9);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (74, 20, 10);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (115, 22, 4);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (148, 21, 3);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (149, 21, 4);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (150, 21, 5);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (151, 21, 6);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (152, 21, 7);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (153, 21, 8);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (154, 21, 9);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (155, 21, 10);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (156, 23, 3);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (157, 23, 4);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (158, 23, 5);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (159, 23, 6);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (160, 23, 7);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (161, 23, 8);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (162, 23, 9);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (163, 23, 10);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (164, 24, 3);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (165, 24, 4);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (166, 24, 5);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (167, 24, 6);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (168, 24, 7);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (169, 24, 8);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (170, 24, 9);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (171, 24, 10);
INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (173, 4, 3);


#
# TABLE STRUCTURE FOR: db_variants
#

DROP TABLE IF EXISTS `db_variants`;

CREATE TABLE `db_variants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `variant_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `variant_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_variants` (`id`, `store_id`, `variant_code`, `variant_name`, `description`, `status`) VALUES (1, 2, NULL, 'SM', 'Small ', 1);
INSERT INTO `db_variants` (`id`, `store_id`, `variant_code`, `variant_name`, `description`, `status`) VALUES (2, 2, NULL, 'MED', 'Medium', 1);
INSERT INTO `db_variants` (`id`, `store_id`, `variant_code`, `variant_name`, `description`, `status`) VALUES (3, 2, NULL, '1', 'shose', 1);
INSERT INTO `db_variants` (`id`, `store_id`, `variant_code`, `variant_name`, `description`, `status`) VALUES (4, 2, NULL, '2', 'shose', 1);
INSERT INTO `db_variants` (`id`, `store_id`, `variant_code`, `variant_name`, `description`, `status`) VALUES (5, 2, NULL, 'BAG', 'COLOR OF BAG', 1);
INSERT INTO `db_variants` (`id`, `store_id`, `variant_code`, `variant_name`, `description`, `status`) VALUES (6, 2, NULL, 'Aquazzura heels 3321', 'Three color                                                                                                 Black \r\nGold \r\nSilver ', 1);


#
# TABLE STRUCTURE FOR: db_warehouse
#

DROP TABLE IF EXISTS `db_warehouse`;

CREATE TABLE `db_warehouse` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `warehouse_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (1, 1, 'System', 'Warehouse-A', '', 'warehouse_a@example.com', 0);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (2, 2, 'System', 'System Warehouse', '', '', 0);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (3, 2, 'Custom', 'Liwa', '112233', 'TEST', 1);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (4, 2, 'Custom', 'Sohar', '123456', 'sohar branch', 1);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (5, 2, 'Custom', 'Ibri', '', '', 1);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (6, 2, 'Custom', 'Saham', '', '', 1);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (7, 2, 'Custom', 'Suwaiq', '', '', 1);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (8, 2, 'Custom', 'Muscat', '', '', 1);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (9, 2, 'Custom', 'Sur', '', '', 1);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`) VALUES (10, 2, 'Custom', 'Salalah', '', '', 1);


#
# TABLE STRUCTURE FOR: db_warehouseitems
#

DROP TABLE IF EXISTS `db_warehouseitems`;

CREATE TABLE `db_warehouseitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `available_qty` double(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_id` (`warehouse_id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2444 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (51, 2, 1, 926, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (121, 2, 1, 927, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (152, 2, 1, 926, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (153, 2, 1, 926, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (165, 2, 1, 926, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (177, 2, 1, 927, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (187, 2, 1, 927, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (188, 2, 1, 928, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (226, 2, 1, 929, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (243, 2, 1, 930, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (279, 2, 1, 931, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (292, 2, 1, 930, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (312, 2, 1, 931, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (369, 2, 1, 932, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (380, 2, 1, 933, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (391, 2, 1, 934, '0.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1831, 2, 4, 944, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1840, 2, 3, 9, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1849, 2, 3, 18, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1868, 2, 3, 37, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1869, 2, 3, 38, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1870, 2, 3, 39, '27.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1871, 2, 3, 40, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1872, 2, 3, 41, '46.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1875, 2, 3, 44, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1876, 2, 3, 45, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1877, 2, 3, 46, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1878, 2, 3, 47, '22.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1879, 2, 3, 48, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1881, 2, 3, 50, '26.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1886, 2, 3, 55, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1888, 2, 3, 57, '26.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1890, 2, 3, 59, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1897, 2, 3, 66, '26.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1899, 2, 3, 68, '13.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1902, 2, 3, 71, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1903, 2, 3, 72, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1907, 2, 3, 76, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1916, 2, 3, 85, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1917, 2, 3, 86, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1920, 2, 3, 89, '36.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1921, 2, 3, 90, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1922, 2, 3, 91, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1923, 2, 3, 92, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1925, 2, 3, 94, '26.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1926, 2, 3, 95, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1927, 2, 3, 96, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1928, 2, 3, 97, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1929, 2, 3, 98, '38.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1930, 2, 3, 99, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1931, 2, 3, 100, '33.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1933, 2, 3, 102, '31.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1934, 2, 3, 103, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1937, 2, 3, 106, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1938, 2, 3, 107, '70.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1939, 2, 3, 108, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1940, 2, 3, 109, '42.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1941, 2, 3, 110, '35.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1942, 2, 3, 111, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1943, 2, 3, 112, '23.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1944, 2, 3, 113, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1945, 2, 3, 114, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1946, 2, 3, 115, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1947, 2, 3, 116, '36.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1949, 2, 3, 118, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1950, 2, 3, 119, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1951, 2, 3, 120, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1952, 2, 3, 121, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1953, 2, 3, 122, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1955, 2, 3, 124, '27.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1957, 2, 3, 126, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1958, 2, 3, 127, '23.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1959, 2, 3, 128, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1960, 2, 3, 129, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1962, 2, 3, 131, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1963, 2, 3, 132, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1964, 2, 3, 133, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1970, 2, 3, 139, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1971, 2, 3, 140, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1973, 2, 3, 142, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1974, 2, 3, 143, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1978, 2, 3, 147, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1979, 2, 3, 148, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1980, 2, 3, 149, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1981, 2, 3, 150, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1982, 2, 3, 151, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1984, 2, 3, 153, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1985, 2, 3, 154, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1988, 2, 3, 156, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1990, 2, 3, 158, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1991, 2, 3, 159, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1992, 2, 3, 160, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1994, 2, 3, 162, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1995, 2, 3, 163, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1996, 2, 3, 164, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1997, 2, 3, 165, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1998, 2, 3, 166, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (1999, 2, 3, 167, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2000, 2, 3, 168, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2001, 2, 3, 169, '22.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2002, 2, 3, 170, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2003, 2, 3, 171, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2004, 2, 3, 172, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2005, 2, 3, 173, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2006, 2, 3, 174, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2007, 2, 3, 175, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2008, 2, 3, 176, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2009, 2, 3, 177, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2010, 2, 3, 178, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2011, 2, 3, 179, '13.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2013, 2, 3, 181, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2014, 2, 3, 182, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2017, 2, 3, 185, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2018, 2, 3, 190, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2019, 2, 3, 191, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2020, 2, 3, 192, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2021, 2, 3, 193, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2022, 2, 3, 194, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2023, 2, 3, 195, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2024, 2, 3, 196, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2025, 2, 3, 197, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2026, 2, 3, 198, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2027, 2, 3, 199, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2028, 2, 3, 200, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2030, 2, 3, 202, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2031, 2, 3, 203, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2032, 2, 3, 204, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2033, 2, 3, 205, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2034, 2, 3, 206, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2035, 2, 3, 207, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2036, 2, 3, 208, '45.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2037, 2, 3, 209, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2038, 2, 3, 210, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2039, 2, 3, 211, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2040, 2, 3, 212, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2041, 2, 3, 213, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2042, 2, 3, 214, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2043, 2, 3, 215, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2044, 2, 3, 216, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2045, 2, 3, 217, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2046, 2, 3, 218, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2047, 2, 3, 219, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2048, 2, 3, 220, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2049, 2, 3, 221, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2050, 2, 3, 222, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2051, 2, 3, 223, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2052, 2, 3, 224, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2053, 2, 3, 225, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2054, 2, 3, 226, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2055, 2, 3, 227, '28.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2056, 2, 3, 228, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2057, 2, 3, 229, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2058, 2, 3, 230, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2059, 2, 3, 231, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2060, 2, 3, 232, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2061, 2, 3, 233, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2062, 2, 3, 234, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2063, 2, 3, 235, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2064, 2, 3, 236, '34.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2065, 2, 3, 237, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2066, 2, 3, 238, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2067, 2, 3, 239, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2068, 2, 3, 240, '24.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2071, 2, 3, 123, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2130, 2, 3, 51, '22.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2232, 2, 3, 130, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2270, 2, 3, 19, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2271, 2, 4, 19, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2272, 2, 3, 13, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2273, 2, 4, 13, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2274, 2, 3, 7, '23.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2275, 2, 3, 33, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2276, 2, 3, 65, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2277, 2, 4, 7, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2278, 2, 4, 33, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2279, 2, 4, 65, '26.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2280, 2, 3, 10, '13.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2281, 2, 3, 83, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2282, 2, 3, 146, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2283, 2, 3, 161, '33.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2284, 2, 4, 10, '22.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2285, 2, 4, 83, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2286, 2, 4, 146, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2287, 2, 4, 161, '28.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2288, 2, 3, 6, '21.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2289, 2, 3, 34, '48.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2290, 2, 3, 35, '36.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2291, 2, 3, 36, '48.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2292, 2, 3, 49, '35.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2293, 2, 3, 52, '42.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2294, 2, 3, 54, '13.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2295, 2, 3, 74, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2296, 2, 3, 105, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2297, 2, 3, 241, '24.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2298, 2, 4, 6, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2299, 2, 4, 34, '89.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2300, 2, 4, 35, '32.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2301, 2, 4, 36, '92.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2302, 2, 4, 49, '53.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2303, 2, 4, 52, '34.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2304, 2, 4, 54, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2305, 2, 4, 74, '24.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2306, 2, 4, 105, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2307, 2, 4, 241, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2308, 2, 3, 2, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2309, 2, 3, 61, '23.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2310, 2, 3, 70, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2311, 2, 3, 93, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2312, 2, 3, 145, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2313, 2, 4, 2, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2314, 2, 4, 61, '21.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2315, 2, 4, 70, '28.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2316, 2, 4, 93, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2317, 2, 4, 145, '55.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2318, 2, 3, 4, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2319, 2, 3, 8, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2320, 2, 3, 11, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2321, 2, 3, 12, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2322, 2, 3, 14, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2323, 2, 3, 15, '13.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2324, 2, 3, 20, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2325, 2, 3, 80, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2326, 2, 3, 82, '29.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2327, 2, 3, 141, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2328, 2, 4, 4, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2329, 2, 4, 8, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2330, 2, 4, 11, '23.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2331, 2, 4, 12, '32.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2332, 2, 4, 14, '26.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2333, 2, 4, 15, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2334, 2, 4, 20, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2335, 2, 4, 80, '43.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2336, 2, 4, 82, '53.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2337, 2, 4, 141, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2338, 2, 3, 28, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2339, 2, 3, 30, '19.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2340, 2, 3, 75, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2341, 2, 3, 78, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2342, 2, 3, 137, '24.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2343, 2, 3, 157, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2344, 2, 3, 180, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2345, 2, 4, 28, '22.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2346, 2, 4, 30, '22.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2347, 2, 4, 75, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2348, 2, 4, 78, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2349, 2, 4, 137, '62.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2350, 2, 4, 157, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2351, 2, 4, 180, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2352, 2, 3, 29, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2353, 2, 3, 43, '41.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2354, 2, 3, 58, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2355, 2, 3, 67, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2356, 2, 3, 81, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2357, 2, 3, 104, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2358, 2, 3, 155, '36.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2359, 2, 3, 183, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2360, 2, 3, 184, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2361, 2, 3, 201, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2362, 2, 4, 29, '36.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2363, 2, 4, 43, '76.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2364, 2, 4, 58, '22.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2365, 2, 4, 67, '26.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2366, 2, 4, 81, '59.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2367, 2, 4, 104, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2368, 2, 4, 155, '24.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2369, 2, 4, 183, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2370, 2, 4, 184, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2371, 2, 4, 201, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2372, 2, 3, 117, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2373, 2, 3, 125, '23.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2374, 2, 3, 26, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2375, 2, 3, 42, '41.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2376, 2, 3, 60, '54.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2377, 2, 3, 84, '35.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2378, 2, 3, 88, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2379, 2, 3, 101, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2380, 2, 3, 144, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2381, 2, 3, 152, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2382, 2, 4, 26, '31.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2383, 2, 4, 42, '59.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2384, 2, 4, 60, '54.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2385, 2, 4, 84, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2386, 2, 4, 88, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2387, 2, 4, 101, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2388, 2, 4, 144, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2389, 2, 4, 152, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2390, 2, 3, 3, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2391, 2, 3, 17, '13.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2392, 2, 3, 21, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2393, 2, 3, 31, '21.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2394, 2, 3, 56, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2395, 2, 3, 69, '21.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2396, 2, 3, 77, '11.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2397, 2, 3, 134, '36.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2398, 2, 3, 135, '24.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2399, 2, 3, 138, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2400, 2, 4, 3, '19.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2401, 2, 4, 17, '31.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2402, 2, 4, 21, '21.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2403, 2, 4, 31, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2404, 2, 4, 56, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2405, 2, 4, 69, '60.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2406, 2, 4, 77, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2407, 2, 4, 134, '32.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2408, 2, 4, 135, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2409, 2, 4, 138, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2410, 2, 3, 1, '15.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2411, 2, 3, 5, '26.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2412, 2, 3, 23, '13.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2413, 2, 3, 24, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2414, 2, 3, 73, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2415, 2, 3, 79, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2416, 2, 3, 87, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2417, 2, 3, 136, '28.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2418, 2, 4, 1, '27.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2419, 2, 4, 5, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2420, 2, 4, 23, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2421, 2, 4, 24, '34.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2422, 2, 4, 73, '21.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2423, 2, 4, 79, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2424, 2, 4, 87, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2425, 2, 4, 136, '23.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2426, 2, 3, 16, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2427, 2, 3, 22, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2428, 2, 3, 25, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2429, 2, 3, 27, '14.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2430, 2, 3, 32, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2431, 2, 3, 53, '31.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2432, 2, 3, 62, '54.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2433, 2, 3, 63, '60.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2434, 2, 3, 64, '23.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2435, 2, 4, 16, '33.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2436, 2, 4, 22, '32.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2437, 2, 4, 25, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2438, 2, 4, 27, '32.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2439, 2, 4, 32, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2440, 2, 4, 53, '45.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2441, 2, 4, 62, '43.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2442, 2, 4, 63, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (2443, 2, 4, 64, '22.00');


#
# TABLE STRUCTURE FOR: temp_holdinvoice
#

DROP TABLE IF EXISTS `temp_holdinvoice`;

CREATE TABLE `temp_holdinvoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `reference_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `item_qty` int(11) DEFAULT NULL,
  `item_price` double(10,2) DEFAULT NULL,
  `tax` double(10,2) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pos` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

SET foreign_key_checks = 1;
