SET foreign_key_checks = 0;
#
# TABLE STRUCTURE FOR: ac_accounts
#

DROP TABLE IF EXISTS `ac_accounts`;

CREATE TABLE `ac_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `sort_code` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  `account_name` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `account_code` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `balance` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1,
  `created_by` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `delete_bit` int(11) DEFAULT '0',
  `account_selection_name` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `paymenttypes_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `expense_id` int(11) DEFAULT NULL,
  `warehouse_id` int(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `paymenttypes_id` (`paymenttypes_id`),
  KEY `customer_id` (`customer_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `expense_id` (`expense_id`),
  CONSTRAINT `ac_accounts_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_2` FOREIGN KEY (`paymenttypes_id`) REFERENCES `db_paymenttypes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_4` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_5` FOREIGN KEY (`expense_id`) REFERENCES `db_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`, `warehouse_id`) VALUES (1, 1, 2, 0, '1', 'Current Account', 'AC/02/0001', '208.0100', '', 'Liwa', '2025-08-20', '09:27:34 am', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', 1, 0, NULL, NULL, NULL, NULL, NULL, 3);
INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`, `warehouse_id`) VALUES (2, 2, 2, 0, '2', 'Treasury account', 'AC/02/0002', '0.0000', '', 'Liwa', '2025-08-20', '09:29:09 am', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', 1, 0, NULL, NULL, NULL, NULL, NULL, 3);


#
# TABLE STRUCTURE FOR: ac_moneydeposits
#

DROP TABLE IF EXISTS `ac_moneydeposits`;

CREATE TABLE `ac_moneydeposits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `debit_account_id` int(11) DEFAULT NULL,
  `credit_account_id` int(11) DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneydeposits_ibfk_3` (`store_id`),
  CONSTRAINT `ac_moneydeposits_ibfk_1` FOREIGN KEY (`debit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneydeposits_ibfk_2` FOREIGN KEY (`credit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneydeposits_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `ac_moneydeposits` (`id`, `store_id`, `deposit_date`, `reference_no`, `debit_account_id`, `credit_account_id`, `amount`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`) VALUES (1, 2, '2025-08-20', '', NULL, 1, '44.0000', '', 'manager2', '2025-08-20', '10:14:33 am', '193.238.247.139', 'static-host-193-238-247-139.awasr.om', 1);


#
# TABLE STRUCTURE FOR: ac_moneytransfer
#

DROP TABLE IF EXISTS `ac_moneytransfer`;

CREATE TABLE `ac_moneytransfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL,
  `transfer_code` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `debit_account_id` int(11) DEFAULT NULL,
  `credit_account_id` int(11) DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneytransfer_ibfk_3` (`store_id`),
  CONSTRAINT `ac_moneytransfer_ibfk_1` FOREIGN KEY (`debit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneytransfer_ibfk_2` FOREIGN KEY (`credit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneytransfer_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_transactions
#

DROP TABLE IF EXISTS `ac_transactions`;

CREATE TABLE `ac_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `transaction_date` date DEFAULT NULL,
  `transaction_type` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  `debit_account_id` int(11) DEFAULT NULL,
  `credit_account_id` int(11) DEFAULT NULL,
  `debit_amt` double(20,4) DEFAULT NULL,
  `credit_amt` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1,
  `created_by` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `ref_accounts_id` int(11) DEFAULT NULL COMMENT 'reference table',
  `ref_moneytransfer_id` int(11) DEFAULT NULL COMMENT 'reference table',
  `ref_moneydeposits_id` int(11) DEFAULT NULL COMMENT 'reference table',
  `ref_salespayments_id` int(11) DEFAULT NULL,
  `ref_salespaymentsreturn_id` int(11) DEFAULT NULL,
  `ref_purchasepayments_id` int(11) DEFAULT NULL,
  `ref_purchasepaymentsreturn_id` int(11) DEFAULT NULL,
  `ref_expense_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_id` (`transaction_type`),
  KEY `account_id` (`debit_account_id`),
  KEY `store_id` (`store_id`),
  KEY `ac_accounts_id` (`ref_accounts_id`),
  KEY `ac_moneytransfer_id` (`ref_moneytransfer_id`),
  KEY `ac_moneydeposits_id` (`ref_moneydeposits_id`),
  KEY `customer_id` (`customer_id`),
  KEY `ref_salespayments_id` (`ref_salespayments_id`),
  KEY `ref_purchasepayments_id` (`ref_purchasepayments_id`),
  KEY `ref_purchasepaymentsreturn_id` (`ref_purchasepaymentsreturn_id`),
  KEY `ac_transactions_ibfk_9` (`ref_salespaymentsreturn_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `ref_expense_id` (`ref_expense_id`),
  CONSTRAINT `ac_transactions_ibfk_10` FOREIGN KEY (`ref_purchasepayments_id`) REFERENCES `db_purchasepayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_11` FOREIGN KEY (`ref_purchasepaymentsreturn_id`) REFERENCES `db_purchasepaymentsreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_12` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_13` FOREIGN KEY (`ref_expense_id`) REFERENCES `db_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_4` FOREIGN KEY (`ref_accounts_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_5` FOREIGN KEY (`ref_moneytransfer_id`) REFERENCES `ac_moneytransfer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_6` FOREIGN KEY (`ref_moneydeposits_id`) REFERENCES `ac_moneydeposits` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_7` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_8` FOREIGN KEY (`ref_salespayments_id`) REFERENCES `db_salespayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_9` FOREIGN KEY (`ref_salespaymentsreturn_id`) REFERENCES `db_salespaymentsreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (12, 2, '', '2025-08-20', 'OPENING BALANCE', NULL, 1, NULL, '0.0000', '', 'Liwa', '2025-08-20', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (13, 2, '', '2025-08-20', 'OPENING BALANCE', NULL, 2, NULL, '0.0000', '', 'Liwa', '2025-08-20', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (19, 2, '', '2025-08-20', 'DEPOSIT', NULL, 1, '44.0000', '44.0000', '', 'manager2', '2025-08-20', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (20, 2, 'SP/2025/01/0009', '2025-09-29', 'SALES PAYMENT', NULL, 1, NULL, '158.0100', 'Paid By Cash', 'sohar', '2025-09-29', NULL, NULL, NULL, 9, NULL, NULL, NULL, NULL, 2, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (21, 2, 'SP/2025/01/0047', '2025-10-01', 'SALES PAYMENT', NULL, 1, NULL, '6.0000', '', 'Liwa', '2025-10-01', NULL, NULL, NULL, 47, NULL, NULL, NULL, NULL, 2, NULL, NULL);


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) CHARACTER SET utf8 NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8 NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b6d4854c9f69cd5b3c69b5a5df854acc67aa8fd3', '5.21.141.146', 1759381603, '__ci_last_regenerate|i:1759381603;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:4:\"Liwa\";user_lname|s:5:\"Sales\";inv_userid|s:1:\"4\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:14:\"liwa@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0278935c681fda0fad8811bc2eb77e7d34e32616', '188.135.31.213', 1759380994, '__ci_last_regenerate|i:1759380994;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:6:\"Haroon\";user_lname|s:1:\" \";inv_userid|s:2:\"23\";logged_in|b:1;role_id|s:1:\"5\";role_name|s:18:\"Purchase Executive\";store_id|s:1:\"2\";email|s:16:\"haroon@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e29969fe1866b5aabc06a69a896f5fd6af2f81d3', '188.135.31.213', 1759381301, '__ci_last_regenerate|i:1759381301;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:6:\"Haroon\";user_lname|s:1:\" \";inv_userid|s:2:\"23\";logged_in|b:1;role_id|s:1:\"5\";role_name|s:18:\"Purchase Executive\";store_id|s:1:\"2\";email|s:16:\"haroon@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5f4af54422d55116ff264d6a2498a3d43e30c920', '188.135.31.213', 1759381797, '__ci_last_regenerate|i:1759381797;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:6:\"Haroon\";user_lname|s:1:\" \";inv_userid|s:2:\"23\";logged_in|b:1;role_id|s:1:\"5\";role_name|s:18:\"Purchase Executive\";store_id|s:1:\"2\";email|s:16:\"haroon@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2c266baeb1b2b1278cbbe12680fe5c6b7fd12493', '5.21.141.146', 1759381648, '__ci_last_regenerate|i:1759381603;currency|s:4:\"R.O.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";store_name|s:13:\"Quotation to \";inv_username|s:4:\"Liwa\";user_lname|s:5:\"Sales\";inv_userid|s:1:\"4\";logged_in|b:1;role_id|s:1:\"3\";role_name|s:5:\"sales\";store_id|s:1:\"2\";email|s:14:\"liwa@bedots.io\";language|s:7:\"English\";language_id|s:1:\"1\";');


#
# TABLE STRUCTURE FOR: db_brands
#

DROP TABLE IF EXISTS `db_brands`;

CREATE TABLE `db_brands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `brand_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_brands_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_brands_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (1, 2, NULL, 'JP', 'Jeery Pine', 1);


#
# TABLE STRUCTURE FOR: db_category
#

DROP TABLE IF EXISTS `db_category`;

CREATE TABLE `db_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create category Code',
  `category_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_category_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (53, 2, 1, 'CT/02/0001', 'General', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (54, 2, 54, 'CT/02/0054', 'Shoes', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (55, 2, 55, 'CT/02/0055', 'BAG', '', NULL, 1);


#
# TABLE STRUCTURE FOR: db_cobpayments
#

DROP TABLE IF EXISTS `db_cobpayments`;

CREATE TABLE `db_cobpayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` mediumtext COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_company
#

DROP TABLE IF EXISTS `db_company`;

CREATE TABLE `db_company` (
  `id` double DEFAULT NULL,
  `company_code` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_website` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `website` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_logo` text COLLATE utf8_unicode_ci,
  `logo` mediumtext COLLATE utf8_unicode_ci,
  `upi_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `upi_code` text COLLATE utf8_unicode_ci,
  `country` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gst_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vat_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pan_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bank_details` mediumtext COLLATE utf8_unicode_ci,
  `cid` int(11) DEFAULT NULL,
  `category_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `supplier_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_return_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_return_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expense_init` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `invoice_view` int(11) DEFAULT NULL COMMENT '1=Standard,2=Indian GST',
  `status` int(11) DEFAULT NULL,
  `sms_status` int(11) DEFAULT NULL COMMENT '1=Enable 0=Disable',
  `sales_terms_and_conditions` text COLLATE utf8_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_company` (`id`, `company_code`, `company_name`, `company_website`, `mobile`, `phone`, `email`, `website`, `company_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `invoice_view`, `status`, `sms_status`, `sales_terms_and_conditions`) VALUES ('1', '', 'Company Name', NULL, '9999999999', '', 'admin@example.com', '', 'company_logo.png', 'logo-0.png', NULL, NULL, 'India', 'Karnataka', 'Belgaum', 'Address Details', '', '', '', '', '', 1, 'CT', 'IT', 'SP', 'PU', 'PR', 'CU', 'SL', 'PR', 'EX', 1, 1, 0, NULL);


#
# TABLE STRUCTURE FOR: db_country
#

DROP TABLE IF EXISTS `db_country`;

CREATE TABLE `db_country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country` varchar(4050) COLLATE utf8_unicode_ci DEFAULT NULL,
  `added_on` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=207 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (1, 'Abkhazia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (2, 'Afghanistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (3, 'Albania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (4, 'Algeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (5, 'Andorra', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (6, 'Angola', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (7, 'Antigua and Barbuda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (8, 'Argentina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (9, 'Armenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (10, 'Australia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (11, 'Austria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (12, 'Azerbaijan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (13, 'Bahamas', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (14, 'Bahrain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (15, 'Bangladesh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (16, 'Barbados', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (17, 'Belarus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (18, 'Belgium', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (19, 'Belize', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (20, 'Benin', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (21, 'Bhutan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (22, 'Bolivia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (23, 'Bosnia and Herzegovina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (24, 'Botswana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (25, 'Brazil', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (26, 'Brunei', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (27, 'Bulgaria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (28, 'Burkina Faso', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (29, 'Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (30, 'Burundi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (31, 'Cambodia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (32, 'Cameroon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (33, 'Canada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (34, 'Cape Verde', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (35, 'Central African Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (36, 'Chad', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (37, 'Chile', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (38, 'China', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (39, 'Colombia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (40, 'Comoros', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (41, 'Congo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (42, 'Cook Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (43, 'Costa Rica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (44, 'Croatia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (45, 'Cuba', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (46, 'Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (47, 'Czech Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (48, 'C?te d\'Ivoire', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (49, 'Denmark', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (50, 'Djibouti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (51, 'Dominica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (52, 'Dominican Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (53, 'East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (54, 'Ecuador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (55, 'Egypt', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (56, 'El Salvador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (57, 'Equatorial Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (58, 'Eritrea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (59, 'Estonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (60, 'Ethiopia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (61, 'Fiji', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (62, 'Finland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (63, 'France', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (64, 'Gabon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (65, 'Gambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (66, 'Georgia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (67, 'Germany', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (68, 'Ghana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (69, 'Greece', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (70, 'Grenada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (71, 'Guatemala', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (72, 'Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (73, 'Guinea-Bissau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (74, 'Guyana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (75, 'Haiti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (76, 'Honduras', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (77, 'Hungary', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (78, 'Iceland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (79, 'India', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (80, 'Indonesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (81, 'Iran', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (82, 'Iraq', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (83, 'Ireland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (84, 'Israel', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (85, 'Italy', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (86, 'Ivory Coast', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (87, 'Jamaica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (88, 'Japan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (89, 'Jordan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (90, 'Kazakhstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (91, 'Kenya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (92, 'Kiribati', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (93, 'Korea, North', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (94, 'Korea, South', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (95, 'Kosovo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (96, 'Kuwait', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (97, 'Kyrgyzstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (98, 'Laos', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (99, 'Latvia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (100, 'Lebanon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (101, 'Lesotho', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (102, 'Liberia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (103, 'Libya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (104, 'Liechtenstein', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (105, 'Lithuania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (106, 'Luxembourg', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (107, 'Macedonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (108, 'Madagascar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (109, 'Malawi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (110, 'Malaysia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (111, 'Maldives', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (112, 'Mali', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (113, 'Malta', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (114, 'Marshall Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (115, 'Mauritania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (116, 'Mauritius', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (117, 'Mexico', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (118, 'Micronesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (119, 'Moldova', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (120, 'Monaco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (121, 'Mongolia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (122, 'Montenegro', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (123, 'Morocco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (124, 'Mozambique', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (125, 'Myanmar / Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (126, 'Nagorno-Karabakh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (127, 'Namibia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (128, 'Nauru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (129, 'Nepal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (130, 'Netherlands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (131, 'New Zealand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (132, 'Nicaragua', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (133, 'Niger', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (134, 'Nigeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (135, 'Niue', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (136, 'Northern Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (137, 'Norway', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (138, 'Oman', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (139, 'Pakistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (140, 'Palau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (141, 'Palestine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (142, 'Panama', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (143, 'Papua New Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (144, 'Paraguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (145, 'Peru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (146, 'Philippines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (147, 'Poland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (148, 'Portugal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (149, 'Qatar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (150, 'Romania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (151, 'Russia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (152, 'Rwanda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (153, 'Sahrawi Arab Democratic Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (154, 'Saint Kitts and Nevis', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (155, 'Saint Lucia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (156, 'Saint Vincent and the Grenadines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (157, 'Samoa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (158, 'San Marino', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (159, 'Saudi Arabia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (160, 'Senegal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (161, 'Serbia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (162, 'Seychelles', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (163, 'Sierra Leone', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (164, 'Singapore', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (165, 'Slovakia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (166, 'Slovenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (167, 'Solomon Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (168, 'Somalia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (169, 'Somaliland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (170, 'South Africa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (171, 'South Ossetia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (172, 'Spain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (173, 'Sri Lanka', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (174, 'Sudan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (175, 'Suriname', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (176, 'Swaziland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (177, 'Sweden', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (178, 'Switzerland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (179, 'Syria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (180, 'S?o Tom? and Pr?ncipe', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (181, 'Taiwan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (182, 'Tajikistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (183, 'Tanzania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (184, 'Thailand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (185, 'Timor-Leste / East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (186, 'Togo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (187, 'Tonga', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (188, 'Trinidad and Tobago', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (189, 'Tunisia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (190, 'Turkey', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (191, 'Turkmenistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (192, 'Tuvalu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (193, 'Uganda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (194, 'Ukraine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (195, 'United Arab Emirates', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (196, 'United Kingdom', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (197, 'United States', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (198, 'Uruguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (199, 'Uzbekistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (200, 'Vanuatu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (201, 'Vatican City', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (202, 'Venezuela', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (203, 'Vietnam', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (204, 'Yemen', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (205, 'Zambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (206, 'Zimbabwe', '2020-11-03', 1);


#
# TABLE STRUCTURE FOR: db_currency
#

DROP TABLE IF EXISTS `db_currency`;

CREATE TABLE `db_currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` blob,
  `symbol` mediumtext COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (1, 'Bulgaria-Bulgarian lev(BGN)', NULL, 'лв', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (2, 'Switzerland \r-Swiss franc (CHF)', NULL, 'CHF', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (3, 'Czechia-Czech koruna(CZK))', NULL, 'Kč ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (4, 'Denmark-Danish krone(DKK)', NULL, 'kr ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (5, 'Euro area countries -Euro(EUR)', NULL, '€ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (6, 'United Kingdom-Pounds sterling (GBP)', NULL, '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (7, 'Croatia -Croatian Kuna (HRK)', NULL, 'kn', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (8, 'Georgia -Georgian lari (GEL)', NULL, '&#8382;', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (9, 'Hungary -Hungarian forint (HUF)', NULL, 'ft', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (10, 'Norway -Norwegian krone (NOK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (11, 'Poland -Polish zloty (PLN)', NULL, 'zł ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (12, 'Russia -Russian ruble (RUB)', NULL, '&#8381; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (13, 'Romania -Romanian leu (RON)', NULL, 'lei', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (14, 'Sweden - Swedish krona (SEK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (15, 'Turkey -Turkish lira (TRY)', NULL, '&#8378; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (16, 'Ukraine - Ukrainian hryvna  (UAH)', NULL, '₴ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (17, 'UAE -Emirati dirham (AED)', NULL, 'د.إ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (18, 'Israel - Israeli shekel (ILS)', NULL, '&#8362; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (19, 'Kenya - Kenyan shilling(KES)', NULL, 'Ksh', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (20, 'Morocco - Moroccan dirham (MAD)', NULL, '.د.م ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (21, 'Nigeria - Nigerian naira (NGN)', NULL, '₦ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (22, 'South Africa -South african rand** (ZAR)', NULL, 'R', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (23, 'Brazil- Brazilian real(BRL)', NULL, 'R$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (24, 'Canada-Canadian dollars (CAD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (25, 'Chile -Chilean peso (CLP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (26, 'Colombia -Colombian peso (COP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (27, 'Mexico - Mexican peso (MXN)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (28, 'Peru -Peruvian sol(PEN)', NULL, 'S/. ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (29, 'USA -US dollar (USD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (30, 'Australia -Australian dollars (AUD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (31, 'Bangladesh -Bangladeshi taka (BDT) ', NULL, '&#2547; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (32, 'China - Chinese yuan (CNY)', NULL, '&#20803; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (33, 'Hong Kong - Hong Kong dollar(HKD)', NULL, '&#36; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (34, 'Indonesia - Indonesian rupiah (IDR)', NULL, 'Rp', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (35, 'India - Indian rupee', 'INR', '₹', '?', 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (36, 'Japan - Japanese yen (JPY)', NULL, '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (37, 'Malaysia - Malaysian ringgit (MYR)', NULL, 'RM', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (38, 'New Zealand - New Zealand dollar (NZD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (39, 'Philippines- Philippine peso (PHP)', NULL, '₱ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (40, 'Pakistan- Pakistani rupee (PKR)', NULL, 'Rs ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (41, 'Singapore - Singapore dollar (SGD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (42, 'South Korea - South Korean won (KRW)', NULL, '&#8361; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (43, 'Sri Lanka - Sri Lankan rupee (LKR)', NULL, 'Rs', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (44, 'Thailand- Thai baht (THB)', NULL, '&#3647; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (45, 'Vietnam - Vietnamese dong', 'VND', '₫', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (46, 'Bitcoin - BTC or XBT', 'BTC ', '₿', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (47, 'Ripples', 'XRP', 'XRP', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (48, 'Monero', 'XMR', 'ɱ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (49, 'Litecoin', 'LTC', 'Ł', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (50, 'Ethereum', 'ETH', 'Ξ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (51, 'Euro', 'EUR', '€', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (52, 'Pounds sterling', 'GBP', '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (53, 'US dollar', 'USD', '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (54, 'Japanese yen', 'JPY', '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (55, 'Omani rial', 'OMR', 'R.O.', NULL, 1);


#
# TABLE STRUCTURE FOR: db_custadvance
#

DROP TABLE IF EXISTS `db_custadvance`;

CREATE TABLE `db_custadvance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `amount` double(20,2) DEFAULT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `note` text CHARACTER SET utf8,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_ip` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(250) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_custadvance_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_custadvance_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customer_payments
#

DROP TABLE IF EXISTS `db_customer_payments`;

CREATE TABLE `db_customer_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `salespayment_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8,
  `system_ip` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `salespayment_id` (`salespayment_id`),
  CONSTRAINT `db_customer_payments_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_payments_ibfk_2` FOREIGN KEY (`salespayment_id`) REFERENCES `db_salespayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customers
#

DROP TABLE IF EXISTS `db_customers`;

CREATE TABLE `db_customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Customer Code',
  `customer_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gstin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vatin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opening_balance` double(20,4) DEFAULT NULL,
  `sales_due` double(20,4) DEFAULT NULL,
  `sales_return_due` double(20,4) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `city` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postcode` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_country_id` int(11) DEFAULT NULL,
  `ship_state_id` int(11) DEFAULT NULL,
  `ship_city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_postcode` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ship_address` text COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `location_link` text COLLATE utf8_unicode_ci,
  `attachment_1` text COLLATE utf8_unicode_ci,
  `price_level_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'Increase',
  `price_level` double(20,4) DEFAULT '0.0000',
  `delete_bit` int(11) DEFAULT '0',
  `tot_advance` double(20,4) DEFAULT NULL,
  `credit_limit` double(20,4) DEFAULT '-1.0000',
  `shippingaddress_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_customers_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (1, 1, NULL, 'CU0001', 'Walk-in customer', NULL, '', '', '', '', NULL, '0.0000', '0.0000', '0.0000', 1, NULL, NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2019-01-01', '10:55:54 pm', 'admin', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, NULL, '-1.0000', 1);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (2, 2, 1, 'CU/02/0001', 'Walk-in customer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '5.9400', '4.0000', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-02-12', '05:53:37 pm', '', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, '0.0000', '-1.0000', 2);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (3, 2, 3, 'CU/02/0003', 'TEST', '1122', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', NULL, NULL, NULL, NULL, NULL, '182.190.165.198', '182.190.165.198', '2025-06-03', '05:45:07 am', 'Admin', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', 9);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (4, 2, 4, 'CU/02/0004', 'Muhammed', '97759659', '', '', '', '', NULL, '0.0000', NULL, NULL, 0, NULL, '', '', '', NULL, NULL, NULL, NULL, NULL, '37.40.228.98', '37.40.228.98', '2025-06-18', '06:35:52 pm', 'Suwaiq', NULL, 1, '', NULL, 'Increase', '0.0000', 0, NULL, NULL, 10);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (5, 2, 5, 'CU/01/0005', 'Shoe Retailer - Sultanate of Oman', '+96897759659', '', '', '', '', NULL, '0.0000', '0.0000', NULL, NULL, NULL, '', '', '', NULL, NULL, NULL, NULL, NULL, '145.255.89.229', 'dynamic.isp.ooredoo.om', '2025-09-11', '01:01:33 am', 'manager2', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', NULL);


#
# TABLE STRUCTURE FOR: db_emailtemplates
#

DROP TABLE IF EXISTS `db_emailtemplates`;

CREATE TABLE `db_emailtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `key` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8_unicode_ci,
  `variables` text COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  `undelete_bit` int(11) DEFAULT NULL,
  `admin_only` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_emailtemplates_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (1, 1, 'SAAS_FORGOT_PASSWORD_EMAIL', 'Site forgot password email template', 'Hi {{user_name}},\r\n\r\nyour OTP is {{email_otp}}\r\n\r\nThank you\r\n{{saas_name}}', '{{user_name}}<br>\r\n{{saas_name}}<br>\r\n{{email_otp}}<br>', 1, 1, 1);
INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (2, 1, 'SAAS_WELCOME_EMAIL', 'Site welcome email', 'Hi {{user_name}},\r\nYour email id {{email_id}},\r\nwelcome to our {{saas_name}},\r\n\r\nThank you', '{{user_name}}<br>\r\n{{email_id}}<br>\r\n{{saas_name}}<br>', 1, 1, 1);


#
# TABLE STRUCTURE FOR: db_expense
#

DROP TABLE IF EXISTS `db_expense`;

CREATE TABLE `db_expense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Expense Code',
  `expense_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `expense_date` date DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expense_for` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expense_amt` double(20,4) DEFAULT NULL,
  `payment_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8_unicode_ci,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `account_id` (`account_id`),
  CONSTRAINT `db_expense_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_expense_ibfk_2` FOREIGN KEY (`account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_expense_category
#

DROP TABLE IF EXISTS `db_expense_category`;

CREATE TABLE `db_expense_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `category_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_expense_category_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (1, 2, 'EC0001', 'Travel Expense', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (2, 2, 'EC0002', 'BUY FOR SHOP', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (3, 2, 'EC0003', 'Salaries Advance', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (4, 2, 'EC0004', 'SALARIES PAID', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (5, 2, 'EC0005', 'WATER;ELECTRICITY AND WIFI BILLS', '', 'Admin', 1);
INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (7, 2, 'EC0006', 'Shop RENT', '', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_hold
#

DROP TABLE IF EXISTS `db_hold`;

CREATE TABLE `db_hold` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `reference_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Temprary',
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `sales_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text COLLATE utf8_unicode_ci,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_hold_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_hold_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_hold_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_holditems
#

DROP TABLE IF EXISTS `db_holditems`;

CREATE TABLE `db_holditems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `hold_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `sales_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`hold_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `db_holditems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_holditems_ibfk_2` FOREIGN KEY (`hold_id`) REFERENCES `db_hold` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_holditems_ibfk_3` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_instamojo
#

DROP TABLE IF EXISTS `db_instamojo`;

CREATE TABLE `db_instamojo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sandbox` int(11) DEFAULT NULL,
  `api_key` text CHARACTER SET utf8,
  `api_token` text CHARACTER SET utf8,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_instamojo_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_instamojo` (`id`, `store_id`, `sandbox`, `api_key`, `api_token`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_instamojopayments
#

DROP TABLE IF EXISTS `db_instamojopayments`;

CREATE TABLE `db_instamojopayments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(25) CHARACTER SET utf8 DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `buyer_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `amount` decimal(16,2) NOT NULL,
  `purpose` text CHARACTER SET utf8,
  `expires_at` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `send_sms` varchar(5) CHARACTER SET utf8 NOT NULL DEFAULT 'false',
  `send_email` varchar(5) CHARACTER SET utf8 NOT NULL DEFAULT 'false',
  `sms_status` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `email_status` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `shorturl` mediumtext CHARACTER SET utf8,
  `longurl` mediumtext CHARACTER SET utf8,
  `redirect_url` mediumtext CHARACTER SET utf8,
  `webhook` mediumtext CHARACTER SET utf8,
  `allow_repeated_payments` varchar(5) CHARACTER SET utf8 NOT NULL DEFAULT 'false',
  `customer_id` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `modified_at` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_items
#

DROP TABLE IF EXISTS `db_items`;

CREATE TABLE `db_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create ITEM Code',
  `item_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `sku` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hsn` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `alert_qty` int(11) DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `lot_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `price` double(20,4) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `purchase_price` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `profit_margin` double(20,2) DEFAULT NULL,
  `sales_price` double(20,4) DEFAULT NULL,
  `stock` double(20,2) DEFAULT NULL,
  `item_image` text COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `discount_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount` double(20,2) DEFAULT NULL,
  `service_bit` int(11) DEFAULT '0',
  `seller_points` double(20,2) DEFAULT '0.00',
  `custom_barcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `item_group` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `child_bit` int(11) DEFAULT '0',
  `mrp` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_items_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=499 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (1, 2, 1, 'SHO0001', '6147-G1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '56.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '06:41:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (2, 2, 2, 'SHO0002', '2289-333T', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '66.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:48:27 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (3, 2, 3, 'SHO0003', 'F89725-284', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '72.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:50:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (4, 2, 4, 'SHO0004', '135-72', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '38.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:54:11 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (5, 2, 5, 'SHO0005', '0855-190', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '61.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:55:18 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (6, 2, 6, 'SHO0006', '135-77', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '60.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:56:55 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (7, 2, 7, 'SHO0007', '136-92', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '52.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '07:59:42 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (8, 2, 8, 'SHO0008', 'M1-12', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '33.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:02:06 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (9, 2, 9, 'SHO0009', 'M1-11', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '11.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:03:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (10, 2, 10, 'SHO0010', 'M1-2', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '48.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:04:07 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (11, 2, 11, 'SHO0011', 'M1-4', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '58.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:05:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (12, 2, 12, 'SHO0012', 'M1-5', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '81.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:06:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (13, 2, 13, 'SHO0013', 'M1-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '25.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:08:34 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (14, 2, 14, 'SHO0014', 'F053986-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '81.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:09:45 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (15, 2, 15, 'SHO0015', 'M1-7', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '82.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:12:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (16, 2, 16, 'SHO0016', '6147-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '70.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:14:15 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (17, 2, 17, 'SHO0017', 'FD6466-66', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '87.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:15:28 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (18, 2, 18, 'SHO0018', 'M1-3', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '14.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:16:34 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (19, 2, 19, 'SHO0019', 'GN24L-638', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '29.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:18:21 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (20, 2, 20, 'SHO0020', 'GN24L-692', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '40.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:19:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (21, 2, 21, 'SHO0021', '8441-7', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '30.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:20:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (22, 2, 22, 'SHO0022', 'M1-9', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '33.33', '4.0000', '78.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:23:31 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (23, 2, 23, 'SHO0023', '8441-94', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '55.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:25:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (24, 2, 24, 'SHO0024', '8441-4', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '92.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:26:13 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (25, 2, 25, 'SHO0025', '9252-D51', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '69.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:27:04 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (26, 2, 26, 'SHO0026', '9252-10', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '85.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:27:43 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (27, 2, 27, 'SHO0027', '9252-A15', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '57.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:28:29 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (28, 2, 28, 'SHO0028', '8181-D90', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '55.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:29:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (29, 2, 29, 'SHO0029', '8441-1', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '91.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:30:11 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (30, 2, 30, 'SHO0030', '8181-G1', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '67.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:31:07 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (31, 2, 31, 'SHO0031', '8441-G1', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '28.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:32:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (32, 2, 32, 'SHO0032', 'M1-10', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '58.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:34:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (33, 2, 33, 'SHO0033', 'M1-1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '19.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:35:18 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (34, 2, 34, 'SHO0034', 'A09557', 54, '', '', 1, 0, 0, NULL, NULL, '4.8500', 151, '4.8500', 'Inclusive', '40.00', '7.0000', '268.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:43:59 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (35, 2, 35, 'SHO0035', '1281', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '41.41', '7.0000', '133.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:46:21 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (36, 2, 36, 'SHO0036', 'KV-02', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '76.32', '7.0000', '275.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:47:52 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (37, 2, 37, 'SHO0037', 'QS5571', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '7.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:52:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (38, 2, 38, 'SHO0038', 'R8621-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '42.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:53:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (39, 2, 39, 'SHO0039', 'CMF36072-145A', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '94.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:56:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (40, 2, 40, 'SHO0040', 'GQ-210', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:57:45 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (41, 2, 41, 'SHO0041', 'MY2056-2', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '46.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '08:58:50 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (42, 2, 42, 'SHO0042', 'MY3700-3', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '192.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:00:14 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (43, 2, 43, 'SHO0043', 'MY3700-2', 54, '', '', 1, 54, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '220.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:02:38 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (44, 2, 44, 'SHO0044', 'LX6095-17', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '12.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:04:43 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (45, 2, 45, 'SHO0045', 'LX969-8', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '20.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:06:29 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (46, 2, 46, 'SHO0046', 'LX2041-5', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '37.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:07:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (47, 2, 47, 'SHO0047', 'M2273-16', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '81.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:08:54 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (48, 2, 48, 'SHO0048', '2273-1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '44.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:09:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (49, 2, 49, 'SHO0049', '23041-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '205.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:11:39 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (50, 2, 50, 'SHO0050', '2944', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '87.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:12:20 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (51, 2, 51, 'SHO0051', '7793-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '126.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:12:54 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (52, 2, 52, 'SHO0052', '58825-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '117.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:13:59 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (53, 2, 53, 'SHO0053', 'A90458-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '169.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:15:10 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (54, 2, 54, 'SHO0054', 'A8602', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '61.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:17:15 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (55, 2, 55, 'SHO0055', '8042', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '17.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:18:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (56, 2, 56, 'SHO0056', '8602', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '12.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:19:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (57, 2, 57, 'SHO0057', '1098-3', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '29.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:20:15 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (58, 2, 58, 'SHO0058', '2577', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '86.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:20:49 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (59, 2, 59, 'SHO0059', '90458', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '7.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:22:19 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (60, 2, 60, 'SHO0060', '998', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '184.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:23:48 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (61, 2, 61, 'SHO0061', '8438-2', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '67.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:24:29 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (62, 2, 62, 'SHO0062', 'SP8108', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '192.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:25:42 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (63, 2, 63, 'SHO0063', 'SP8109', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '218.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:28:42 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (64, 2, 64, 'SHO0064', 'BL70-305', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '45.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:30:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (65, 2, 65, 'SHO0065', '5722-5', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '115.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:31:10 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (66, 2, 66, 'SHO0066', '52269', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '52.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:32:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (67, 2, 67, 'SHO0067', 'YC-452', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '97.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:33:40 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (68, 2, 68, 'SHO0068', '3317-3', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '13.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:34:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (69, 2, 69, 'SHO0069', 'TL-911', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '126.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:35:12 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (70, 2, 70, 'SHO0070', 'Z68141', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '44.00', NULL, '37.28.75.246', '37.28.75.246', '2025-09-26', '09:40:49 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (71, 2, 71, 'SHO0071', '2877', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '61.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:43:39 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (72, 2, 72, 'SHO0072', '8625-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '15.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:45:02 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (73, 2, 73, 'SHO0073', '0365-0910', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '78.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:45:51 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (74, 2, 74, 'SHO0074', 'ME1507', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '101.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:46:33 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (75, 2, 75, 'SHO0075', 'YC-442', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '17.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:56:46 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (76, 2, 76, 'SHO0076', '30-432', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '13.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:57:16 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (77, 2, 77, 'SHO0077', '30-428', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '42.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:57:56 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (78, 2, 78, 'SHO0078', '2020-2', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '55.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '01:58:48 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (79, 2, 79, 'SHO0079', 'SH-12', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '35.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:07:26 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (80, 2, 80, 'SHO0080', 'ME1501', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '96.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:08:59 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (81, 2, 81, 'SHO0081', 'ME1514', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '123.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:10:01 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (82, 2, 82, 'SHO0082', 'ME1502', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '140.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:11:03 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (83, 2, 83, 'SHO0083', '8895-68', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '49.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:12:04 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (84, 2, 84, 'SHO0084', '10041', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '77.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:13:02 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (85, 2, 85, 'SHO0085', '0909-25', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:14:48 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (86, 2, 86, 'SHO0086', '0909-27', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '7.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:15:44 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (87, 2, 87, 'SHO0087', '30-406', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '62.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:17:11 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (88, 2, 88, 'SHO0088', '80421-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '158.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:18:41 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (89, 2, 89, 'SHO0089', 'H38', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', '49.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:19:23 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (90, 2, 90, 'SHO0090', '6296-12', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '15.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:20:12 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (91, 2, 91, 'SHO0091', '15290', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '130.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:20:59 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (92, 2, 92, 'SHO0092', '6038', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '8.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:22:32 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (93, 2, 93, 'SHO0093', '2256-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '62.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:23:11 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (94, 2, 94, 'SHO0094', '37057-1', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '47.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:24:10 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (95, 2, 95, 'SHO0095', '37057', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '90.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:24:51 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (96, 2, 96, 'SHO0096', '91349-18', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '91.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:26:28 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (97, 2, 97, 'SHO0097', '2262-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '43.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:29:17 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (98, 2, 98, 'SHO0098', '2321', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '46.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:29:57 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (99, 2, 99, 'SHO0099', '5018', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '17.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:30:52 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (100, 2, 100, 'SHO0100', '8535-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '63.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:31:54 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (101, 2, 101, 'SHO0101', '8359', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '30.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:32:39 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (102, 2, 102, 'SHO0102', '8101-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '96.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:33:32 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (103, 2, 103, 'SHO0103', '52323', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '91.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:34:26 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (104, 2, 104, 'SHO0104', '09557', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '15.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:35:16 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (105, 2, 105, 'SHO0105', '8520', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '67.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:35:44 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (106, 2, 106, 'SHO0106', '7769-11', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '21.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:36:21 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (107, 2, 107, 'SHO0107', 'd1', 54, '', '', 1, 72, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '257.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:40:13 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (108, 2, 108, 'SHO0108', 'd2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '129.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:41:02 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (109, 2, 109, 'SHO0109', 'D3', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '82.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:41:40 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (110, 2, 110, 'SHO0110', 'D4', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '125.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:42:16 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (111, 2, 111, 'SHO0111', 'D8', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '96.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:42:52 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (112, 2, 112, 'SHO0112', 'D9', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '77.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:43:30 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (113, 2, 113, 'SHO0113', 'D10', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '148.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:44:07 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (114, 2, 114, 'SHO0114', 'D11', 54, '', '', 1, 90, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '163.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:44:43 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (115, 2, 115, 'SHO0115', 'D14', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '26.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:45:18 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (116, 2, 116, 'SHO0116', 'D15', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '195.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:46:00 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (117, 2, 117, 'SHO0117', 'D7', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '20.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:46:47 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (118, 2, 118, 'SHO0118', 'D12', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '6.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:47:28 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (119, 2, 119, 'SHO0119', 'D16', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '39.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:48:07 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (120, 2, 120, 'SHO0120', 'D17', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '1.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:48:45 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (121, 2, 121, 'SHO0121', 'D18', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '61.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:50:46 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (122, 2, 122, 'SHO0122', 'D19', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '143.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:51:17 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (123, 2, 123, 'SHO0123', 'D20 FLAT', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '160.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:52:19 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (124, 2, 124, 'SHO0124', 'D23', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '140.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:52:57 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (125, 2, 125, 'SHO0125', 'D24', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '129.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:53:32 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (126, 2, 126, 'SHO0126', 'D6', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '57.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:54:27 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (127, 2, 127, 'SHO0127', 'D15 FLAT', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '185.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:55:12 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (128, 2, 128, 'SHO0128', 'D21', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '108.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:55:50 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (129, 2, 129, 'SHO0129', '1801', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:58:09 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (130, 2, 130, 'SHO0130', '90047', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '10.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:59:09 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (131, 2, 131, 'SHO0131', '9318-14', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '3.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '02:59:52 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (132, 2, 132, 'SHO0132', 'E3402', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '9.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:00:32 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (133, 2, 133, 'SHO0133', '52140-2', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:01:20 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (134, 2, 134, 'SHO0134', 'OB-52', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', '113.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:03:28 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (135, 2, 135, 'SHO0135', 'OB-51', 55, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', '39.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:04:04 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (136, 2, 136, 'SHO0136', 'OB-53', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', '72.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:04:50 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (137, 2, 137, 'SHO0137', '2412-145', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '151.00', NULL, '37.40.228.35', '37.40.228.35', '2025-09-27', '03:05:23 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (138, 2, 138, 'SHO0138', 'ME1442', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '86.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '08:44:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (139, 2, 139, 'SHO0139', '30-256', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '08:46:14 pm', 'Liwa', NULL, 0, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (140, 2, 140, 'SHO0140', '30-255', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '24.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '08:48:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (141, 2, 141, 'SHO0141', 'Lw-96', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '65.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '08:50:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (142, 2, 142, 'SHO0142', 'QB-93', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '16.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:00:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (143, 2, 143, 'SHO0143', 'BK-480', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '15.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:01:49 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (144, 2, 144, 'SHO0144', '30-171', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '169.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:02:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (145, 2, 145, 'SHO0145', '0318-28', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '68.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:04:34 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (146, 2, 146, 'SHO0146', 'ME1477', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '25.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:05:33 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (147, 2, 147, 'SHO0147', '9263-4', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '12.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:06:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (148, 2, 148, 'SHO0148', 'S3377', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '14.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:07:22 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (149, 2, 149, 'SHO0149', '2123', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '17.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:08:13 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (150, 2, 150, 'SHO0150', '908-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:09:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (151, 2, 151, 'SHO0151', '518-1', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '0.00', '4.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:10:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (152, 2, 152, 'SHO0152', 'B6120', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '85.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:12:43 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (153, 2, 153, 'SHO0153', '6887-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:13:48 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (154, 2, 154, 'SHO0154', '60074-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '18.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:14:51 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (155, 2, 155, 'SHO0155', '58531-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '67.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:19:38 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (156, 2, 156, 'SHO0156', '2391', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:21:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (157, 2, 157, 'SHO0157', '810-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '11.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:22:00 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (158, 2, 158, 'SHO0158', '2022', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:22:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (159, 2, 159, 'SHO0159', '625-58', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '55.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:24:20 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (160, 2, 160, 'SHO0160', '90042', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '17.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:25:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (161, 2, 161, 'SHO0161', '90080', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '104.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:27:16 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (162, 2, 162, 'SHO0162', 'TL-752', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '44.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:28:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (163, 2, 163, 'SHO0163', '0365-6', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:29:35 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (164, 2, 164, 'SHO0164', '8758', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', '49.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:30:42 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (165, 2, 165, 'SHO0165', '3563-1', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', '53.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:31:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (166, 2, 166, 'SHO0166', '859', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '135.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:33:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (167, 2, 167, 'SHO0167', 'E3299', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '35.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:34:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (168, 2, 168, 'SHO0168', '52271', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '119.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:35:25 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (169, 2, 169, 'SHO0169', '025-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '70.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:36:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (170, 2, 170, 'SHO0170', 'M24614', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '14.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:37:12 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (171, 2, 171, 'SHO0171', '211', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '20.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:39:57 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (172, 2, 172, 'SHO0172', '3297', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '16.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:40:35 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (173, 2, 173, 'SHO0173', '2105', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '13.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:41:21 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (174, 2, 174, 'SHO0174', 'G693', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '53.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:44:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (175, 2, 175, 'SHO0175', 'G694', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '46.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:45:28 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (176, 2, 176, 'SHO0176', 'ZX-150', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '28.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:46:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (177, 2, 177, 'SHO0177', 'ZX-151', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '1.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:49:14 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (178, 2, 178, 'SHO0178', '8287', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:50:10 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (179, 2, 179, 'SHO0179', 'L24685', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '25.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:50:59 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (180, 2, 180, 'SHO0180', '8277', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '36.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:52:16 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (181, 2, 181, 'SHO0181', 'B2615', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:53:08 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (182, 2, 182, 'SHO0182', 'Y2316', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:53:56 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (183, 2, 183, 'SHO0183', 'A-7', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '36.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:54:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (184, 2, 184, 'SHO0184', 'A-4', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '13.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:55:43 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (185, 2, 185, 'SHO0185', '7569-16', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:56:50 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (186, 2, 186, 'SHO0186', '5500', 53, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '0.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:58:14 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (187, 2, 187, 'SHO0187', '6600', 53, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '0.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:59:01 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (188, 2, 188, 'SHO0188', '7700', 53, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '0.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '09:59:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (189, 2, 189, 'SHO0189', '8800', 53, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '0.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:00:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (190, 2, 190, 'SHO0190', 'MZAF-23', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '14.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:01:31 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (191, 2, 191, 'SHO0191', 'HT-90', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '15.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:10:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (192, 2, 192, 'SHO0192', '8586', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '30.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:11:19 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (193, 2, 193, 'SHO0193', 'A8588-10', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '58.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:12:05 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (194, 2, 194, 'SHO0194', '3312', 54, '', '', 1, 0, 0, NULL, NULL, '5.5000', 151, '5.5000', 'Inclusive', '36.36', '7.5000', '60.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:13:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (195, 2, 195, 'SHO0195', '68546', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '114.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:14:08 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (196, 2, 196, 'SHO0196', 'JX-08', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '17.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:14:56 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (197, 2, 197, 'SHO0197', 'MY0910-15', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '74.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:15:38 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (198, 2, 198, 'SHO0198', 'HT-62', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '32.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:16:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (199, 2, 199, 'SHO0199', 'FC008', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '9.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:16:59 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (200, 2, 200, 'SHO0200', '37057-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '13.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:17:53 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (201, 2, 201, 'SHO0201', '55-31', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '19.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:18:40 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (202, 2, 202, 'SHO0202', '8968', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:19:23 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (203, 2, 203, 'SHO0203', 'JYN-06', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '7.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:20:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (204, 2, 204, 'SHO0204', 'CM8907-4', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '24.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:21:30 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (205, 2, 205, 'SHO0205', '2032-10', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:22:14 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (206, 2, 206, 'SHO0206', '8520', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '9.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:23:22 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (207, 2, 207, 'SHO0207', 'YJ302', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '20.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:24:13 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (208, 2, 208, 'SHO0208', '5016', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '133.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:25:19 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (209, 2, 209, 'SHO0209', '21002', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '27.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:26:16 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (210, 2, 210, 'SHO0210', '30578', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '9.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:27:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (211, 2, 211, 'SHO0211', '3085', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:29:10 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (212, 2, 212, 'SHO0212', '002#', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:30:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (213, 2, 213, 'SHO0213', 'E47', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:32:53 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (214, 2, 214, 'SHO0214', 'E43', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '7.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:33:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (215, 2, 215, 'SHO0215', '4328Q', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:34:45 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (216, 2, 216, 'SHO0216', 'E3', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:35:24 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (217, 2, 217, 'SHO0217', 'E10', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '4.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:36:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (218, 2, 218, 'SHO0218', 'C183', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '18.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:37:26 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (219, 2, 219, 'SHO0219', '4045', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:38:17 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (220, 2, 220, 'SHO0220', 'E225', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:40:02 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (221, 2, 221, 'SHO0221', 'HD-088', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '30.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:41:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (222, 2, 222, 'SHO0222', '2131', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:42:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (223, 2, 223, 'SHO0223', '24756', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:43:36 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (224, 2, 224, 'SHO0224', '5001', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:44:47 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (225, 2, 225, 'SHO0225', '8744', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '17.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:45:53 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (226, 2, 226, 'SHO0226', 'PIN2#', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '33.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:48:57 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (227, 2, 227, 'SHO0227', '2133', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '66.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:50:44 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (228, 2, 228, 'SHO0228', '4009', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '64.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:51:46 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (229, 2, 229, 'SHO0229', '2065', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '59.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:52:32 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (230, 2, 230, 'SHO0230', 'GU055', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '25.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:53:15 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (231, 2, 231, 'SHO0231', '12065', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '13.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:54:03 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (232, 2, 232, 'SHO0232', '2340', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '2.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:54:39 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (233, 2, 233, 'SHO0233', '1140', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '19.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:55:22 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (234, 2, 234, 'SHO0234', 'KL-22', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '7.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:56:04 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (235, 2, 235, 'SHO0235', '30683', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '16.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:56:45 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (236, 2, 236, 'SHO0236', 'A068', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '221.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:57:21 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (237, 2, 237, 'SHO0237', 'GU59567', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '46.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:58:08 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (238, 2, 238, 'SHO0238', '2066', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:58:49 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (239, 2, 239, 'SHO0239', '6029', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '3.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '10:59:31 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (240, 2, 240, 'SHO0240', '5015', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '34.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '11:00:16 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (241, 2, 241, 'SHO0241', '6458-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '61.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-28', '11:02:01 pm', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (242, 2, 242, 'SHO0242', 'me1425', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '9.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:00:57 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (243, 2, 243, 'SHO0243', '8830-8', 54, '', '', 1, 0, 0, NULL, NULL, '6.5000', 151, '6.5000', 'Inclusive', '30.77', '8.5000', '87.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:05:04 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (244, 2, 244, 'SHO0244', '25L423', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '11.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:07:49 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (245, 2, 245, 'SHO0245', '14-919', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '40.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:09:30 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (246, 2, 246, 'SHO0246', 'p36-1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:13:19 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (247, 2, 247, 'SHO0247', 'A6038', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '29.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:14:44 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (248, 2, 248, 'SHO0248', '2203-2', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '6.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:16:12 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (249, 2, 249, 'SHO0249', 'Sp23-041', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '19.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:18:33 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (250, 2, 250, 'SHO0250', '2412-146', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '11.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:21:44 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (251, 2, 251, 'SHO0251', 'QB-94', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '11.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:25:30 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (252, 2, 252, 'SHO0252', '5637-1', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '10.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:27:55 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (253, 2, 253, 'SHO0253', 'W1047-m', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '10.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:29:23 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (254, 2, 254, 'SHO0254', 'TL-879', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '46.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:31:28 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (255, 2, 255, 'SHO0255', 'W1106-M', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '5.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:33:08 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (256, 2, 256, 'SHO0256', '5028-93', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '21.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:35:04 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (257, 2, 257, 'SHO0257', '12M-32070', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '2.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:36:25 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (258, 2, 258, 'SHO0258', '2289-328', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', '27.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:37:55 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (259, 2, 259, 'SHO0259', '20-754', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '36.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:39:12 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (260, 2, 260, 'SHO0260', '60038', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '107.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:40:24 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (261, 2, 261, 'SHO0261', 'M1127-2', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '8.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:43:20 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (262, 2, 262, 'SHO0262', 'M1129-2', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '15.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:44:15 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (263, 2, 263, 'SHO0263', 'H1130', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '7.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:45:30 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (264, 2, 264, 'SHO0264', 'M1126-2', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '10.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:46:46 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (265, 2, 265, 'SHO0265', '8005', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '3.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:48:43 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (266, 2, 266, 'SHO0266', '1389', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '10.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:50:35 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (267, 2, 267, 'SHO0267', '52323', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '46.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:52:12 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (268, 2, 268, 'SHO0268', 'TL-896', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '51.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:53:19 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (269, 2, 269, 'SHO0269', '39242-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '75.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:56:03 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (270, 2, 270, 'SHO0270', '625-59', 54, '', '', 1, 0, 0, NULL, NULL, '3.5000', 151, '3.5000', 'Inclusive', '57.14', '5.5000', '21.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:57:55 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (271, 2, 271, 'SHO0271', 'S3389', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '08:59:11 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (272, 2, 272, 'SHO0272', 'GP-436', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '6.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:00:18 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (273, 2, 273, 'SHO0273', 'ME1426', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '11.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:02:13 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (274, 2, 274, 'SHO0274', 'ME1385', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '5.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:03:12 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (275, 2, 275, 'SHO0275', 'A1098-3', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '97.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:05:31 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (276, 2, 276, 'SHO0276', 'B2626-37', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '12.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:09:02 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (277, 2, 277, 'SHO0277', 'H1120', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '3.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:10:05 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (278, 2, 278, 'SHO0278', 'N1133', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:11:16 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (279, 2, 279, 'SHO0279', 'M11371', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:15:13 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (280, 2, 280, 'SHO0280', '8441-42', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '28.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:18:40 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (281, 2, 281, 'SHO0281', '2273-2', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '10.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:20:45 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (282, 2, 282, 'SHO0282', 'LW-91', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '34.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:21:54 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (283, 2, 283, 'SHO0283', 'GP-437', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '7.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:23:19 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (284, 2, 284, 'SHO0284', '55-211', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '3.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:24:41 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (285, 2, 285, 'SHO0285', 'GN25L-1028', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '76.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:28:16 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (286, 2, 286, 'SHO0286', '1010', 54, '', '', 1, 0, 0, NULL, NULL, '8.0000', 151, '8.0000', 'Inclusive', '25.00', '10.0000', '378.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:30:25 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '8.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (287, 2, 287, 'SHO0287', '9090', 54, '', '', 1, 0, 0, NULL, NULL, '7.0000', 151, '7.0000', 'Inclusive', '28.57', '9.0000', '274.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:31:21 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '7.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (288, 2, 288, 'SHO0288', 'MY2506-2', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '234.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:38:47 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (289, 2, 289, 'SHO0289', '0152-88', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '14.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:40:17 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (290, 2, 290, 'SHO0290', '7026-8', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '14.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:41:29 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (291, 2, 291, 'SHO0291', '24L638-1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:45:32 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (292, 2, 292, 'SHO0292', '875', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '7.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:47:08 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (293, 2, 293, 'SHO0293', 'K5007', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '7.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:48:20 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (294, 2, 294, 'SHO0294', '1214', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '16.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:51:46 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (295, 2, 295, 'SHO0295', '1808', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '31.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:52:56 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (296, 2, 296, 'SHO0296', '2944', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '41.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:54:16 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (297, 2, 297, 'SHO0297', 'me1425', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '8.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:55:18 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (298, 2, 298, 'SHO0298', '9147', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '17.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:57:26 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (299, 2, 299, 'SHO0299', '20-670', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '35.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:58:33 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (300, 2, 300, 'SHO0300', '023', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '12.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '09:59:33 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (301, 2, 301, 'SHO0301', '0854-7', 54, '', '', 1, 0, 0, NULL, NULL, '2.5000', 151, '2.5000', 'Inclusive', '80.00', '4.5000', '16.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:00:49 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (302, 2, 302, 'SHO0302', '9203-A3', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '5.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:01:55 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (303, 2, 303, 'SHO0303', '1686', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '13.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:03:10 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (304, 2, 304, 'SHO0304', '2032-12', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '19.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:04:19 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (305, 2, 305, 'SHO0305', '5992', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '12.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:05:46 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (306, 2, 306, 'SHO0306', '9088', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '8.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:07:08 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (307, 2, 307, 'SHO0307', '3390', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '5.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:08:27 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (308, 2, 308, 'SHO0308', '9081-22', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '5.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:11:12 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (309, 2, 309, 'SHO0309', 'S3245', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '11.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:12:38 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (310, 2, 310, 'SHO0310', 'M11510', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '2.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:14:13 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (311, 2, 311, 'SHO0311', 'HT-57', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '6.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:15:07 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (312, 2, 312, 'SHO0312', '90032', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '11.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:16:08 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (313, 2, 313, 'SHO0313', '0909-23', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '13.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:17:19 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (314, 2, 314, 'SHO0314', 'HT-270', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '9.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:19:07 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (315, 2, 315, 'SHO0315', '9913-251', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', '40.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:20:29 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (316, 2, 316, 'SHO0316', 'S016', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '73.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:22:08 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (317, 2, 317, 'SHO0317', '9020', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '17.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:24:49 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (318, 2, 318, 'SHO0318', '599-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '9.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:26:01 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (319, 2, 319, 'SHO0319', 'GN25-423', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '25.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:27:25 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (320, 2, 320, 'SHO0320', '8321', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '5.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:28:49 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (321, 2, 321, 'SHO0321', '331', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '15.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:29:51 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (322, 2, 322, 'SHO0322', 'A-12081', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '4.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:31:04 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (323, 2, 323, 'SHO0323', '297', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '16.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:32:00 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (324, 2, 324, 'SHO0324', '13403', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '2.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:33:02 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (325, 2, 325, 'SHO0325', '40288', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '26.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:34:44 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (326, 2, 326, 'SHO0326', '2426', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '3.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:35:44 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (327, 2, 327, 'SHO0327', '377', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '11.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:36:39 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (328, 2, 328, 'SHO0328', 'E44', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '3.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:38:05 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (329, 2, 329, 'SHO0329', '2215', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '3.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:39:10 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (330, 2, 330, 'SHO0330', '1396', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '4.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:41:25 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (331, 2, 331, 'SHO0331', 'C001', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '19.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:43:16 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (332, 2, 332, 'SHO0332', '0464-10', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '9.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:44:55 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (333, 2, 333, 'SHO0333', 'A2340', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '2.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:46:07 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (334, 2, 334, 'SHO0334', '0691', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '6.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:47:46 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (335, 2, 335, 'SHO0335', 'CK5013', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '21.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:49:22 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (336, 2, 336, 'SHO0336', 'CK8105', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '56.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:50:13 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (337, 2, 337, 'SHO0337', 'CK6630', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '32.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:51:08 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (338, 2, 338, 'SHO0338', '20014', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '23.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:51:58 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (339, 2, 339, 'SHO0339', 'CK5511', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '50.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:52:39 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (340, 2, 340, 'SHO0340', '1035', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '2.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:53:30 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (341, 2, 341, 'SHO0341', '10610', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '10.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:54:22 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (342, 2, 342, 'SHO0342', 'CK8110', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '46.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:55:04 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (343, 2, 343, 'SHO0343', '6017', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '40.00', NULL, '5.37.109.80', '5.37.109.80', '2025-09-29', '10:55:39 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (345, 2, 345, 'SHO0345', 'GN25L423', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '30.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:25:37 am', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (346, 2, 346, 'SHO0346', '30-256', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '10.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:33:10 am', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (347, 2, 347, 'SHO0347', 'M12614', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '35.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:06:39 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (348, 2, 348, 'SHO0348', '2705', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '37.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:13:17 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (349, 2, 349, 'SHO0349', '9065', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '6.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-30', '11:08:45 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (350, 2, 350, 'SHO0350', '68141-1', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', '24.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-30', '11:27:06 am', 'Liwa', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (351, 2, 351, 'SHO0351', '2065', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '34.00', NULL, '37.28.67.43', 'dynamic.isp.ooredoo.om', '2025-09-30', '11:49:19 am', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (352, 2, 352, 'SHO0352', 'CK10610', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '22.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:05:05 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (353, 2, 353, 'SHO0353', 'CK21002', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:06:28 pm', 'Haroon', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (354, 2, 354, 'SHO0354', 'CK20614', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '16.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:17:05 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (355, 2, 355, 'SHO0355', 'ME1205', 53, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:19:00 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (356, 2, 356, 'SHO0356', '7592-22', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:20:21 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (357, 2, 357, 'SHO0357', '30-396', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:21:07 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (358, 2, 358, 'SHO0358', '2173-3', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:21:48 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (359, 2, 359, 'SHO0359', 'H1186', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:27:31 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (360, 2, 360, 'SHO0360', '90077', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:30:32 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (361, 2, 361, 'SHO0361', 'LT-858', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:35:17 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (362, 2, 362, 'SHO0362', '9318-M', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:37:07 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (363, 2, 363, 'SHO0363', 'ME1474', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '11.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:39:15 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (364, 2, 364, 'SHO0364', 'ME1389', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:40:34 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (365, 2, 365, 'SHO0365', 'ME1431', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:41:38 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (366, 2, 366, 'SHO0366', 'M11288', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:42:18 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (367, 2, 367, 'SHO0367', 'MY0910-1', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:46:08 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (368, 2, 368, 'SHO0368', 'MY39192', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:47:50 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (369, 2, 369, 'SHO0369', '2312', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '22.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:50:13 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (370, 2, 370, 'SHO0370', '3247', 55, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:51:43 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (371, 2, 371, 'SHO0371', 'MY0910-2', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:53:47 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (372, 2, 372, 'SHO0372', '91359', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '19.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:55:21 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (373, 2, 373, 'SHO0373', '52348', 53, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '09:57:42 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (374, 2, 374, 'SHO0374', 'M88', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:00:03 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (375, 2, 375, 'SHO0375', '721-1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:07:07 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (376, 2, 376, 'SHO0376', 'CM0152-88', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '8.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:07:50 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (377, 2, 377, 'SHO0377', '9264-4', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', '25.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:09:06 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (378, 2, 378, 'SHO0378', '6078', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '26.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:10:41 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (379, 2, 379, 'SHO0379', '1022', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:12:59 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (380, 2, 380, 'SHO0380', '3535', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:15:01 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (381, 2, 381, 'SHO0381', 'A39242', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '15.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:16:13 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (382, 2, 382, 'SHO0382', 'MY5028-15', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '34.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:18:56 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (383, 2, 383, 'SHO0383', '1920', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:19:52 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (384, 2, 384, 'SHO0384', '5021-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', '17.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:27:35 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (385, 2, 385, 'SHO0385', 'A1965', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:28:26 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (386, 2, 386, 'SHO0386', 'ZX-148', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', '4.00', NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:31:38 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (387, 2, 387, 'SHO0387', 'K6089-02', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.200.207.128', 'dynamic.isp.ooredoo.om', '2025-09-30', '10:34:08 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (388, 2, 388, 'SHO0388', 'Y2318', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:38:46 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (389, 2, 389, 'SHO0389', 'ME1189', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:40:04 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (390, 2, 390, 'SHO0390', 'S017', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:41:16 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (391, 2, 391, 'SHO0391', 'MF028', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '34.00', NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:42:50 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (392, 2, 392, 'SHO0392', '5028-12', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:43:42 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (393, 2, 393, 'SHO0393', 'MY910-8', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:47:38 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (394, 2, 394, 'SHO0394', '1733', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:48:44 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (395, 2, 395, 'SHO0395', '8888', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:51:06 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (396, 2, 396, 'SHO0396', 'QB-95', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:54:21 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (397, 2, 397, 'SHO0397', '8386-M', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:56:15 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (398, 2, 398, 'SHO0398', 'MY8508-22', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:58:08 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (399, 2, 399, 'SHO0399', '37072', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '10:59:18 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (400, 2, 400, 'SHO0400', '5021-2', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '37.40.238.100', '37.40.238.100', '2025-09-30', '11:00:08 pm', 'saham', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (401, 2, 401, 'SHO0401', '99270', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:25:45 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (402, 2, 402, 'SHO0402', '12M-3205', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:27:23 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (403, 2, 403, 'SHO0403', '68141', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:29:07 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (404, 2, 404, 'SHO0404', '36072', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:32:39 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (405, 2, 405, 'SHO0405', '9801-21', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:36:05 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (406, 2, 406, 'SHO0406', 'MY9248-1', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:39:11 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (407, 2, 407, 'SHO0407', '12M-32168', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:40:51 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (408, 2, 408, 'SHO0408', 'SP-1370-63', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:41:43 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (409, 2, 409, 'SHO0409', '9801-22', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:43:09 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (410, 2, 410, 'SHO0410', '33390-2', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:53:19 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (411, 2, 411, 'SHO0411', '2377', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:54:01 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (412, 2, 412, 'SHO0412', '2425', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:55:03 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (413, 2, 413, 'SHO0413', '888', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:56:16 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (414, 2, 414, 'SHO0414', '0124-1', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:57:11 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (415, 2, 415, 'SHO0415', '1032', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:58:46 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (416, 2, 416, 'SHO0416', '1041', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-01', '11:59:22 pm', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (417, 2, 417, 'SHO0417', '2027N', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:05:01 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (418, 2, 418, 'SHO0418', 'CK20014', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:05:51 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (419, 2, 419, 'SHO0419', '24025', 55, '', '', 1, 0, 0, NULL, NULL, '6.5000', 151, '6.5000', 'Inclusive', '30.77', '8.5000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:07:32 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (420, 2, 420, 'SHO0420', 'A6066', 55, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:08:38 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (421, 2, 421, 'SHO0421', '002#', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:09:55 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (422, 2, 422, 'SHO0422', 'J0620', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:11:06 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (423, 2, 423, 'SHO0423', 'J2134', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:11:50 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (424, 2, 424, 'SHO0424', 'J2132', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:14:59 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (425, 2, 425, 'SHO0425', '8149N', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:16:09 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (426, 2, 426, 'SHO0426', '8147N', 55, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:17:00 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (427, 2, 427, 'SHO0427', '9082', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:21:10 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (428, 2, 428, 'SHO0428', '5791B#', 55, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:21:56 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (429, 2, 429, 'SHO0429', 'CM7026-8', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:23:28 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (430, 2, 430, 'SHO0430', '2678-1', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:24:33 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (431, 2, 431, 'SHO0431', 'GZ6-19516', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:27:03 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (432, 2, 432, 'SHO0432', 'ME1412', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:27:53 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (433, 2, 433, 'SHO0433', '2412-158', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:29:01 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (434, 2, 434, 'SHO0434', 'GP-72', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:30:20 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (435, 2, 435, 'SHO0435', 'GP-294', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:32:03 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (436, 2, 436, 'SHO0436', 'BE5399', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:32:33 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (437, 2, 437, 'SHO0437', 'ME1392', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:34:28 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (438, 2, 438, 'SHO0438', 'ME1390', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:35:32 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (439, 2, 439, 'SHO0439', '30-271', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:36:45 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (440, 2, 440, 'SHO0440', 'CM58153-29', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:37:31 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (441, 2, 441, 'SHO0441', 'TL-715', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:38:13 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (442, 2, 442, 'SHO0442', '12M-32037', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:40:25 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (443, 2, 443, 'SHO0443', '9501', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:42:07 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (444, 2, 444, 'SHO0444', 'HT-203', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', '33.00', NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:43:09 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (445, 2, 445, 'SHO0445', 'C 7728-5', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:44:31 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (446, 2, 446, 'SHO0446', 'BE5395', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:45:25 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (447, 2, 447, 'SHO0447', '20-670', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:46:50 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (448, 2, 448, 'SHO0448', 'NH2025-61', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:47:45 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (449, 2, 449, 'SHO0449', 'LW-93', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '12:48:50 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (450, 2, 450, 'SHO0450', '0148-55', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:08:50 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (451, 2, 451, 'SHO0451', 'G699', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:10:42 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (452, 2, 452, 'SHO0452', '5009-2', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:12:21 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (453, 2, 453, 'SHO0453', 'TL-817', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:14:29 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (454, 2, 454, 'SHO0454', 'HA-35', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:16:17 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (455, 2, 455, 'SHO0455', 'ME1419', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:17:54 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (456, 2, 456, 'SHO0456', '8588-6', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:19:40 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (457, 2, 457, 'SHO0457', 'LY2485', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:26:17 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (458, 2, 458, 'SHO0458', 'CM5853-33', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:27:00 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (459, 2, 459, 'SHO0459', 'YC-153', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:27:32 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (460, 2, 460, 'SHO0460', 'MD2473-1', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:28:39 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (461, 2, 461, 'SHO0461', '8088-1', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:29:44 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (462, 2, 462, 'SHO0462', 'BE-1376', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:30:59 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (463, 2, 463, 'SHO0463', 'BE-1378', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:31:35 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (464, 2, 464, 'SHO0464', 'MY0910-7', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:32:32 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (465, 2, 465, 'SHO0465', '28-2705', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:34:23 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (466, 2, 466, 'SHO0466', 'CT02', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:35:30 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (467, 2, 467, 'SHO0467', 'YZ81', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:36:24 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (468, 2, 468, 'SHO0468', 'CT3313', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:37:43 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (469, 2, 469, 'SHO0469', 'SAR-015', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:39:19 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (470, 2, 470, 'SHO0470', 'MY0850-15', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:40:24 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (471, 2, 471, 'SHO0471', 'S-3', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:41:07 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (472, 2, 472, 'SHO0472', 'CT119', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:41:50 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (473, 2, 473, 'SHO0473', 'YZ-657', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '200.00', '3.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:42:40 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (474, 2, 474, 'SHO0474', 'YRY-8278-1', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:44:15 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (475, 2, 475, 'SHO0475', '99270', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:46:51 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (476, 2, 476, 'SHO0476', '7199', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:48:22 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (477, 2, 477, 'SHO0477', '12712', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:49:33 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (478, 2, 478, 'SHO0478', 'HT-78', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:50:25 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (479, 2, 479, 'SHO0479', '0318-28', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '0.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:51:32 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (480, 2, 480, 'SHO0480', '1503', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:52:17 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (481, 2, 481, 'SHO0481', '9296-12', 54, '', '', 1, 0, 0, NULL, NULL, '5.0000', 151, '5.0000', 'Inclusive', '40.00', '7.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:54:22 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '5.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (482, 2, 482, 'SHO0482', '12M-32137', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:56:05 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (483, 2, 483, 'SHO0483', '12M-32130', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:57:14 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (484, 2, 484, 'SHO0484', '12M-32138', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '50.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:58:03 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (485, 2, 485, 'SHO0485', 'YX-5009', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '100.00', '2.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '01:59:28 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (486, 2, 486, 'SHO0486', '1778-2', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '100.00', '2.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:00:18 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (487, 2, 487, 'SHO0487', 'F066', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '100.00', '2.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:00:56 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (488, 2, 488, 'SHO0488', '211', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '100.00', '2.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:01:41 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (489, 2, 489, 'SHO0489', 'M12702', 54, '', '', 1, 0, 0, NULL, NULL, '3.0000', 151, '3.0000', 'Inclusive', '66.67', '5.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:02:39 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '3.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (490, 2, 490, 'SHO0490', 'BOOM GIRL-38', 54, '', '', 1, 0, 0, NULL, NULL, '4.0000', 151, '4.0000', 'Inclusive', '100.00', '6.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:04:14 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (491, 2, 491, 'SHO0491', 'ME1413', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:05:13 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (492, 2, 492, 'SHO0492', '13769-1', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:06:32 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (493, 2, 493, 'SHO0493', '1999', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:07:10 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (494, 2, 494, 'SHO0494', 'MY1089-20', 54, '', '', 1, 0, 0, NULL, NULL, '4.5000', 151, '4.5000', 'Inclusive', '44.44', '6.5000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:08:27 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '4.5000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (495, 2, 495, 'SHO0495', '7199-2', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:09:36 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (496, 2, 496, 'SHO0496', 'RM-210', 54, '', '', 1, 0, 0, NULL, NULL, '2.0000', 151, '2.0000', 'Inclusive', '100.00', '4.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:10:47 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '2.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (497, 2, 497, 'SHO0497', '6287', 54, '', '', 1, 0, 0, NULL, NULL, '6.0000', 151, '6.0000', 'Inclusive', '33.33', '8.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:12:19 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '6.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (498, 2, 498, 'SHO0498', '1778-2', 54, '', '', 1, 0, 0, NULL, NULL, '1.0000', 151, '1.0000', 'Inclusive', '100.00', '2.0000', NULL, NULL, '5.162.211.142', 'dynamic.isp.ooredoo.om', '2025-10-02', '02:13:26 am', 'muscat', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '1.0000');


#
# TABLE STRUCTURE FOR: db_languages
#

DROP TABLE IF EXISTS `db_languages`;

CREATE TABLE `db_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (1, 'English', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (2, 'Russian', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (3, 'Spanish', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (4, 'Arabic', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (5, 'Bangla', 0);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (6, 'French', 0);


#
# TABLE STRUCTURE FOR: db_package
#

DROP TABLE IF EXISTS `db_package`;

CREATE TABLE `db_package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `package_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `package_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `package_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `monthly_price` double(20,2) DEFAULT NULL,
  `annual_price` double(20,2) DEFAULT NULL,
  `trial_days` int(11) DEFAULT NULL,
  `max_users` int(11) DEFAULT NULL,
  `max_items` int(11) DEFAULT NULL,
  `max_invoices` int(11) DEFAULT NULL,
  `max_warehouses` int(11) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_package_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_paymenttypes
#

DROP TABLE IF EXISTS `db_paymenttypes`;

CREATE TABLE `db_paymenttypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_paymenttypes_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (36, 2, 'Cash', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (37, 2, 'Visa', 1);
INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (39, 2, 'Bank Transfer', 1);


#
# TABLE STRUCTURE FOR: db_paypal
#

DROP TABLE IF EXISTS `db_paypal`;

CREATE TABLE `db_paypal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sandbox` int(11) DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_paypal_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_paypal` (`id`, `store_id`, `sandbox`, `email`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_paypalpaylog
#

DROP TABLE IF EXISTS `db_paypalpaylog`;

CREATE TABLE `db_paypalpaylog` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `txn_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `payment_gross` float(10,2) NOT NULL,
  `currency_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `payer_email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `payment_status` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_permissions
#

DROP TABLE IF EXISTS `db_permissions`;

CREATE TABLE `db_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `permissions` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_permissions_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8203 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4414, 1, 17, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4415, 1, 17, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4416, 1, 17, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4417, 1, 17, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4418, 1, 17, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4419, 1, 17, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4420, 1, 17, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4421, 1, 17, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4422, 1, 17, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4423, 1, 17, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4424, 1, 17, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4425, 1, 17, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4426, 1, 17, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4427, 1, 17, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4428, 1, 17, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4429, 1, 17, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4430, 1, 17, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4431, 1, 17, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4432, 1, 17, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4433, 1, 17, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4434, 1, 17, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4435, 1, 17, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4436, 1, 17, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4437, 1, 17, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4438, 1, 17, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4439, 1, 17, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4440, 1, 17, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4441, 1, 17, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4442, 1, 17, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4443, 1, 17, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4444, 1, 17, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4445, 1, 17, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4446, 1, 17, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4447, 1, 17, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4448, 1, 17, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4449, 1, 17, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4450, 1, 17, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4451, 1, 17, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4452, 1, 17, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4453, 1, 17, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4454, 1, 17, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4455, 1, 17, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4456, 1, 17, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4457, 1, 17, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4458, 1, 17, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4459, 1, 17, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4460, 1, 17, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4461, 1, 17, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4462, 1, 17, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4463, 1, 17, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4464, 1, 17, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4465, 1, 17, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4466, 1, 17, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4467, 1, 17, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4468, 1, 17, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4469, 1, 17, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4470, 1, 17, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4471, 1, 17, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4472, 1, 17, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4473, 1, 17, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4474, 1, 17, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4475, 1, 17, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4476, 1, 17, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4477, 1, 17, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4478, 1, 17, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4479, 1, 17, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4480, 1, 17, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4481, 1, 17, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4482, 1, 17, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4483, 1, 17, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4484, 1, 17, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4485, 1, 17, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4486, 1, 17, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4487, 1, 17, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4488, 1, 17, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4489, 1, 17, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4490, 1, 17, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4491, 1, 17, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4492, 1, 18, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4493, 1, 18, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4494, 1, 18, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4495, 1, 18, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4496, 1, 18, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4497, 1, 18, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4498, 1, 18, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4499, 1, 18, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4500, 1, 18, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4501, 1, 18, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4502, 1, 18, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4503, 1, 18, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4504, 1, 18, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4505, 1, 18, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4506, 1, 18, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4507, 1, 18, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4508, 1, 18, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4509, 1, 18, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4510, 1, 18, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4511, 1, 18, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4512, 1, 18, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4513, 1, 18, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4514, 1, 18, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4515, 1, 18, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4516, 1, 18, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4517, 1, 18, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4518, 1, 18, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4519, 1, 18, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4520, 1, 18, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4521, 1, 18, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4522, 1, 18, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4523, 1, 18, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4524, 1, 18, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4525, 1, 18, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4526, 1, 18, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4527, 1, 18, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4528, 1, 18, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4529, 1, 18, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4530, 1, 18, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4531, 1, 18, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4532, 1, 18, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4533, 1, 18, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4534, 1, 18, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4535, 1, 18, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4536, 1, 18, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4537, 1, 18, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4538, 1, 18, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4539, 1, 18, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4540, 1, 18, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4541, 1, 18, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4542, 1, 18, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4543, 1, 18, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4544, 1, 18, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4545, 1, 18, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4546, 1, 18, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4547, 1, 18, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4548, 1, 18, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4549, 1, 18, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4550, 1, 18, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4551, 1, 18, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4552, 1, 18, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4553, 1, 18, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4554, 1, 18, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4555, 1, 18, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4556, 1, 18, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4557, 1, 18, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4558, 1, 18, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4559, 1, 18, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4560, 1, 18, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4561, 1, 18, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4562, 1, 18, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4563, 1, 18, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4564, 1, 18, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4565, 1, 18, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4566, 1, 18, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4567, 1, 18, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4568, 1, 18, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4569, 1, 18, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4570, 1, 18, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4571, 1, 18, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4572, 1, 18, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4573, 1, 18, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4574, 1, 18, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4575, 1, 18, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4576, 1, 18, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4577, 1, 18, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4578, 1, 18, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4579, 1, 18, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4580, 1, 18, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5818, 1, 2, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5819, 1, 2, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5820, 1, 2, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5821, 1, 2, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5822, 1, 2, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5823, 1, 2, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5824, 1, 2, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5825, 1, 2, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5826, 1, 2, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5827, 1, 2, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5828, 1, 2, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5829, 1, 2, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5830, 1, 2, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5831, 1, 2, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5832, 1, 2, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5833, 1, 2, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5834, 1, 2, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5835, 1, 2, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5836, 1, 2, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5837, 1, 2, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5838, 1, 2, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5839, 1, 2, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5840, 1, 2, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5841, 1, 2, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5842, 1, 2, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5843, 1, 2, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5844, 1, 2, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5845, 1, 2, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5846, 1, 2, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5847, 1, 2, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5848, 1, 2, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5849, 1, 2, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5850, 1, 2, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5851, 1, 2, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5852, 1, 2, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5853, 1, 2, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5854, 1, 2, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5855, 1, 2, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5856, 1, 2, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5857, 1, 2, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5858, 1, 2, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5859, 1, 2, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5860, 1, 2, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5861, 1, 2, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5862, 1, 2, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5863, 1, 2, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5864, 1, 2, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5865, 1, 2, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5866, 1, 2, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5867, 1, 2, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5868, 1, 2, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5869, 1, 2, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5870, 1, 2, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5871, 1, 2, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5872, 1, 2, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5873, 1, 2, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5874, 1, 2, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5875, 1, 2, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5876, 1, 2, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5877, 1, 2, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5878, 1, 2, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5879, 1, 2, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5880, 1, 2, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5881, 1, 2, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5882, 1, 2, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5883, 1, 2, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5884, 1, 2, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5885, 1, 2, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5886, 1, 2, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5887, 1, 2, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5888, 1, 2, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5889, 1, 2, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5890, 1, 2, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5891, 1, 2, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5892, 1, 2, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5893, 1, 2, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5894, 1, 2, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5895, 1, 2, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5896, 1, 2, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5897, 1, 2, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5898, 1, 2, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5899, 1, 2, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5900, 1, 2, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5901, 1, 2, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5902, 1, 2, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5903, 1, 2, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5904, 1, 2, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5905, 1, 2, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5906, 1, 2, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5907, 1, 2, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5908, 1, 2, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5909, 1, 2, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5910, 1, 2, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5911, 1, 2, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5912, 1, 2, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5913, 1, 2, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5914, 1, 2, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5915, 1, 2, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5916, 1, 2, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5917, 1, 2, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5918, 1, 2, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5919, 1, 2, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5920, 1, 2, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5921, 1, 2, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5922, 1, 2, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5923, 1, 2, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5924, 1, 2, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5925, 1, 2, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5926, 1, 2, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5927, 1, 2, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5928, 1, 2, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5929, 1, 2, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5930, 1, 2, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5931, 1, 2, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5932, 1, 2, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5933, 1, 2, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5934, 1, 2, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5935, 1, 2, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5936, 1, 2, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5937, 1, 2, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5938, 1, 2, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5939, 1, 2, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5940, 1, 2, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5941, 1, 2, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5942, 1, 2, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5943, 1, 2, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5944, 1, 2, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5945, 1, 2, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5946, 1, 2, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5947, 1, 2, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5948, 1, 2, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5949, 1, 2, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5950, 1, 2, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5951, 1, 2, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5952, 1, 2, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5953, 1, 2, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5954, 1, 2, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5955, 1, 2, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5956, 1, 2, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5957, 1, 2, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5958, 1, 2, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5959, 1, 2, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5960, 1, 2, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5961, 1, 2, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5962, 1, 2, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5963, 1, 2, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5964, 1, 2, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5965, 1, 2, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5966, 1, 2, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5967, 1, 2, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5968, 1, 2, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5969, 1, 2, 'subscription');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5970, 1, 2, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5971, 1, 2, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5972, 1, 2, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5973, 1, 2, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5974, 1, 2, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5975, 1, 2, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5976, 1, 2, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5977, 1, 2, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5978, 1, 2, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5999, 2, 28, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6000, 2, 28, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6001, 2, 28, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6002, 2, 28, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6011, 2, 29, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6012, 2, 29, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6013, 2, 29, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6014, 2, 29, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6015, 2, 29, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6016, 2, 29, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6017, 2, 29, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6018, 2, 29, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6019, 2, 29, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6020, 2, 29, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6021, 2, 29, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6022, 2, 29, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6023, 2, 29, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6024, 2, 29, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6025, 2, 29, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6026, 2, 29, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6027, 2, 29, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6028, 2, 29, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6029, 2, 29, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6030, 2, 29, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6031, 2, 29, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6032, 2, 29, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6033, 2, 29, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6034, 2, 29, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6035, 2, 29, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6036, 2, 29, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6037, 2, 29, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6038, 2, 29, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6039, 2, 29, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6040, 2, 29, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6041, 2, 29, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6042, 2, 29, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6043, 2, 29, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6044, 2, 29, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6045, 2, 29, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6046, 2, 29, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6047, 2, 29, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6048, 2, 29, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6049, 2, 29, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6050, 2, 29, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6051, 2, 29, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6052, 2, 29, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6053, 2, 29, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6054, 2, 29, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6055, 2, 29, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6056, 2, 29, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6057, 2, 29, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6058, 2, 29, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6059, 2, 29, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6060, 2, 29, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6061, 2, 29, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6062, 2, 29, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6063, 2, 29, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6064, 2, 29, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6065, 2, 29, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6066, 2, 29, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6067, 2, 29, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6068, 2, 29, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6069, 2, 29, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6070, 2, 29, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6071, 2, 29, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6072, 2, 29, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6073, 2, 29, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6074, 2, 29, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6075, 2, 29, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6076, 2, 29, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6077, 2, 29, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6078, 2, 29, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6079, 2, 29, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6080, 2, 29, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6081, 2, 29, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6082, 2, 29, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6083, 2, 29, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6084, 2, 29, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6085, 2, 29, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6086, 2, 29, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6087, 2, 29, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6088, 2, 29, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6089, 2, 29, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6090, 2, 29, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6091, 2, 29, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6092, 2, 29, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6093, 2, 29, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6094, 2, 29, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6095, 2, 29, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6096, 2, 29, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6097, 2, 29, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6098, 2, 29, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6099, 2, 29, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6100, 2, 29, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6101, 2, 29, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6102, 2, 29, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6103, 2, 29, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6104, 2, 29, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6105, 2, 29, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6106, 2, 29, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6107, 2, 29, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6108, 2, 29, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6109, 2, 29, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6110, 2, 29, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6111, 2, 29, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6112, 2, 29, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6113, 2, 29, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6114, 2, 29, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6115, 2, 29, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6116, 2, 29, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6117, 2, 29, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6118, 2, 29, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6119, 2, 29, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6120, 2, 29, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6121, 2, 29, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6122, 2, 29, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6123, 2, 29, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6124, 2, 29, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6125, 2, 29, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6126, 2, 29, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6127, 2, 29, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6128, 2, 29, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6129, 2, 29, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6130, 2, 29, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6131, 2, 29, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6132, 2, 29, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6133, 2, 29, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6134, 2, 29, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6135, 2, 29, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6136, 2, 29, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6137, 2, 29, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6138, 2, 29, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6139, 2, 29, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6140, 2, 29, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6141, 2, 29, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6142, 2, 29, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6143, 2, 29, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6144, 2, 29, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6145, 2, 29, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6146, 2, 29, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6147, 2, 29, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6148, 2, 29, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6149, 2, 29, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6150, 2, 29, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6151, 2, 29, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6152, 2, 29, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6153, 2, 29, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6154, 2, 29, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6155, 2, 29, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6156, 2, 29, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6157, 2, 29, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6158, 2, 29, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6159, 2, 29, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6160, 2, 29, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6161, 2, 29, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6162, 2, 29, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6163, 2, 29, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6164, 2, 29, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6165, 2, 29, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6166, 2, 29, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6167, 2, 29, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6168, 2, 29, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6169, 2, 29, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6170, 2, 29, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6179, 1, 2, 'gstr_1_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6180, 1, 2, 'gstr_2_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6181, 1, 2, 'delivery_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6182, 1, 2, 'load_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6183, 1, 2, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6184, 1, 2, 'customer_orders_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7679, 2, 5, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7680, 2, 5, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7681, 2, 5, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7682, 2, 5, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7683, 2, 5, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7684, 2, 5, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7685, 2, 5, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7686, 2, 5, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7687, 2, 5, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7688, 2, 5, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7689, 2, 5, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7690, 2, 5, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7691, 2, 5, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7692, 2, 5, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7693, 2, 5, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7694, 2, 5, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7695, 2, 5, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7696, 2, 5, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7697, 2, 5, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7698, 2, 5, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7699, 2, 5, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7861, 2, 4, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7862, 2, 4, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7863, 2, 4, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7864, 2, 4, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7865, 2, 4, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7866, 2, 4, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7867, 2, 4, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7868, 2, 4, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7869, 2, 4, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7870, 2, 4, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7871, 2, 4, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7872, 2, 4, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7873, 2, 4, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7874, 2, 4, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7875, 2, 4, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7876, 2, 4, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7877, 2, 4, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7878, 2, 4, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7879, 2, 4, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7880, 2, 4, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7881, 2, 4, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7882, 2, 4, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7883, 2, 4, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7884, 2, 4, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7885, 2, 4, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7886, 2, 4, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7887, 2, 4, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7888, 2, 4, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7889, 2, 4, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7890, 2, 4, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7891, 2, 4, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7892, 2, 4, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7893, 2, 4, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7894, 2, 4, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7895, 2, 4, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7896, 2, 4, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7897, 2, 4, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7898, 2, 4, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7899, 2, 4, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7900, 2, 4, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7901, 2, 4, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7902, 2, 4, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7903, 2, 4, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7904, 2, 4, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7905, 2, 4, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7906, 2, 4, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7907, 2, 4, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7908, 2, 4, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7909, 2, 4, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7910, 2, 4, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7911, 2, 4, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7912, 2, 4, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7913, 2, 4, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7914, 2, 4, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7915, 2, 4, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7916, 2, 4, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7917, 2, 4, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7918, 2, 4, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7919, 2, 4, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7920, 2, 4, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7921, 2, 4, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7922, 2, 4, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7923, 2, 4, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7924, 2, 4, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7925, 2, 4, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7926, 2, 4, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7927, 2, 4, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7928, 2, 4, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7929, 2, 4, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7930, 2, 4, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7931, 2, 4, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7932, 2, 4, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7933, 2, 4, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7934, 2, 4, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7935, 2, 4, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7936, 2, 4, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7937, 2, 4, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7938, 2, 4, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7939, 2, 4, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7940, 2, 4, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7941, 2, 4, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7942, 2, 4, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7943, 2, 4, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7944, 2, 4, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7945, 2, 4, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7946, 2, 4, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7947, 2, 4, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7948, 2, 4, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7949, 2, 4, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7950, 2, 4, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7951, 2, 4, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7952, 2, 4, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7953, 2, 4, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7954, 2, 4, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7955, 2, 4, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7956, 2, 4, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7957, 2, 4, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7958, 2, 4, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7959, 2, 4, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7960, 2, 4, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7961, 2, 4, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7962, 2, 4, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7963, 2, 4, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7964, 2, 4, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7965, 2, 4, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7966, 2, 4, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7967, 2, 4, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7968, 2, 4, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7969, 2, 4, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7970, 2, 4, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7971, 2, 4, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7972, 2, 4, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7973, 2, 4, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7974, 2, 4, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7975, 2, 4, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7976, 2, 4, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7977, 2, 4, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7978, 2, 4, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7979, 2, 4, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7980, 2, 4, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7981, 2, 4, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7982, 2, 4, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7983, 2, 4, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7984, 2, 4, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7985, 2, 4, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7986, 2, 4, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7987, 2, 4, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7988, 2, 4, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7989, 2, 4, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7990, 2, 4, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7991, 2, 4, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7992, 2, 4, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7993, 2, 4, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7994, 2, 4, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7995, 2, 4, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7996, 2, 4, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7997, 2, 4, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7998, 2, 4, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (7999, 2, 4, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8000, 2, 4, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8001, 2, 4, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8002, 2, 4, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8003, 2, 4, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8004, 2, 4, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8005, 2, 4, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8006, 2, 4, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8007, 2, 4, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8008, 2, 4, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8009, 2, 4, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8010, 2, 4, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8011, 2, 4, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8012, 2, 4, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8013, 2, 4, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8014, 2, 4, 'gstr_1_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8015, 2, 4, 'gstr_2_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8016, 2, 4, 'customer_orders_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8017, 2, 4, 'load_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8018, 2, 4, 'delivery_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8019, 2, 4, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8143, 2, 3, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8144, 2, 3, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8145, 2, 3, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8146, 2, 3, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8147, 2, 3, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8148, 2, 3, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8149, 2, 3, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8150, 2, 3, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8151, 2, 3, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8152, 2, 3, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8153, 2, 3, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8154, 2, 3, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8155, 2, 3, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8156, 2, 3, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8157, 2, 3, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8158, 2, 3, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8159, 2, 3, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8160, 2, 3, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8161, 2, 3, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8162, 2, 3, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8163, 2, 3, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8164, 2, 3, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8165, 2, 3, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8166, 2, 3, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8167, 2, 3, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8168, 2, 3, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8169, 2, 3, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8170, 2, 3, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8171, 2, 3, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8172, 2, 3, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8173, 2, 3, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8174, 2, 3, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8175, 2, 3, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8176, 2, 3, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8177, 2, 3, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8178, 2, 3, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8179, 2, 3, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8180, 2, 3, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8181, 2, 3, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8182, 2, 3, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8183, 2, 3, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8184, 2, 3, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8185, 2, 3, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8186, 2, 3, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8187, 2, 3, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8188, 2, 3, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8189, 2, 3, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8190, 2, 3, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8191, 2, 3, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8192, 2, 3, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8193, 2, 3, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8194, 2, 3, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8195, 2, 3, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8196, 2, 3, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8197, 2, 3, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8198, 2, 3, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8199, 2, 3, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8200, 2, 3, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8201, 2, 3, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (8202, 2, 3, 'show_purchase_price');


#
# TABLE STRUCTURE FOR: db_purchase
#

DROP TABLE IF EXISTS `db_purchase`;

CREATE TABLE `db_purchase` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Purchase Code',
  `purchase_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `purchase_note` text COLLATE utf8_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'Purchase return raised',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchase_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchase_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (1, 2, 4, 1, 'PU/20250929/PO0001', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '18.0000', NULL, '18.0000', '', 'Unpaid', '0.0000', '2025-09-29', '04:54:22 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (2, 2, 4, 2, 'PU/20250929/PO0002', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '24.0000', NULL, '24.0000', '', 'Unpaid', '0.0000', '2025-09-29', '04:56:02 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (3, 2, 4, 3, 'PU/20250929/PO0003', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '150.0000', NULL, '150.0000', '', 'Unpaid', '0.0000', '2025-09-29', '04:57:39 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (4, 2, 4, 4, 'PU/20250929/PO0004', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '190.0000', NULL, '190.0000', '', 'Unpaid', '0.0000', '2025-09-29', '05:02:05 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (5, 2, 4, 5, 'PU/20250929/PO0005', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1810.2900', NULL, '1810.2900', '', 'Unpaid', '0.0000', '2025-09-29', '05:20:55 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (6, 2, 4, 6, 'PU/20250929/PO0006', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '502.0000', NULL, '502.0000', '', 'Unpaid', '0.0000', '2025-09-29', '05:24:03 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (7, 2, 4, 7, 'PU/20250929/PO0007', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '688.0000', NULL, '688.0000', '', 'Unpaid', '0.0000', '2025-09-29', '05:40:11 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (8, 2, 4, 8, 'PU/20250929/PO0008', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '400.0000', NULL, '400.0000', '', 'Unpaid', '0.0000', '2025-09-29', '05:49:11 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (9, 2, 4, 9, 'PU/20250929/PO0009', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '968.0000', NULL, '968.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:02:45 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (10, 2, 4, 10, 'PU/20250929/PO0010', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1077.0000', NULL, '1077.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:14:41 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (11, 2, 4, 11, 'PU/20250929/PO0011', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '502.0000', NULL, '502.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:22:05 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (12, 2, 4, 12, 'PU/20250929/PO0012', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '385.0000', NULL, '385.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:31:58 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (13, 2, 4, 13, 'PU/20250929/PO0013', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '907.0000', NULL, '907.0000', '', 'Unpaid', '0.0000', '2025-09-29', '06:36:06 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (14, 2, 4, 14, 'PU/20250929/PO0014', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '924.5000', NULL, '924.5000', '', 'Unpaid', '0.0000', '2025-09-29', '07:31:10 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (15, 2, 4, 15, 'PU/20250929/PO0015', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '680.0000', NULL, '680.0000', '', 'Unpaid', '0.0000', '2025-09-29', '07:39:36 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (16, 2, 4, 16, 'PU/20250929/PO0016', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '656.0000', NULL, '656.0000', '', 'Unpaid', '0.0000', '2025-09-29', '07:55:21 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (17, 2, 4, 17, 'PU/20250929/PO0017', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1025.0000', NULL, '1025.0000', '', 'Unpaid', '0.0000', '2025-09-29', '08:11:46 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (18, 2, 4, 18, 'PU/20250929/PO0018', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '4020.0000', NULL, '4020.0000', '', 'Unpaid', '0.0000', '2025-09-29', '08:25:10 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (19, 2, 4, 19, 'PU/20250929/PO0019', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '115.0000', NULL, '115.0000', '', 'Unpaid', '0.0000', '2025-09-29', '09:35:25 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (20, 2, 4, 20, 'PU/20250929/PO0020', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '265.0000', NULL, '265.0000', '', 'Unpaid', '0.0000', '2025-09-29', '09:36:57 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (21, 2, 4, 21, 'PU/20250929/PO0021', '', '2025-09-29', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '115.0000', NULL, '115.0000', '', 'Unpaid', '0.0000', '2025-09-29', '09:50:15 pm', 'manager2', '5.37.109.80', '5.37.109.80', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (22, 2, 3, 22, 'PU/20250930/PO0022', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '78.0000', NULL, '78.0000', '', 'Unpaid', '0.0000', '2025-09-30', '09:17:25 am', 'Haroon', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (23, 2, 3, 23, 'PU/20250930/PO0023', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '42.0000', NULL, '42.0000', '', 'Unpaid', '0.0000', '2025-09-30', '09:21:17 am', 'Haroon', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (24, 2, 3, 24, 'PU/20250930/PO0024', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '72.0000', NULL, '72.0000', '', 'Unpaid', '0.0000', '2025-09-30', '09:22:33 am', 'Haroon', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (25, 2, 3, 25, 'PU/20250930/PO0025', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '28.0000', NULL, '28.0000', '', 'Unpaid', '0.0000', '2025-09-30', '09:27:54 am', 'Haroon', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (26, 2, 3, 26, 'PU/20250930/PO0026', '', '2025-09-30', 'Received', 1, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '15.0000', NULL, '15.0000', '', 'Unpaid', '0.0000', '2025-09-30', '09:28:55 am', 'Haroon', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (27, 2, 3, 27, 'PU/20250930/PO0027', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '51.0000', NULL, '51.0000', '', 'Unpaid', '0.0000', '2025-09-30', '09:34:51 am', 'Haroon', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (28, 2, 4, 28, 'PU/20250930/PO0028', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '102.0000', NULL, '102.0000', '', 'Unpaid', '0.0000', '2025-09-30', '11:46:38 am', 'Haroon', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (29, 2, 6, 29, 'PU/20250930/PO0029', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '284.0000', NULL, '284.0000', '', 'Unpaid', '0.0000', '2025-09-30', '06:37:36 pm', 'Haroon', '37.40.238.100', '37.40.238.100', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (30, 2, 6, 30, 'PU/20250930/PO0030', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '253.0000', NULL, '253.0000', '', 'Unpaid', '0.0000', '2025-09-30', '06:43:54 pm', 'Haroon', '37.40.238.100', '37.40.238.100', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (31, 2, 6, 31, 'PU/20250930/PO0031', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '376.0000', NULL, '376.0000', '', 'Unpaid', '0.0000', '2025-09-30', '06:51:37 pm', 'Haroon', '37.40.238.100', '37.40.238.100', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (32, 2, 6, 32, 'PU/20250930/PO0032', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '376.0000', NULL, '376.0000', '', 'Unpaid', '0.0000', '2025-09-30', '06:52:04 pm', 'Haroon', '37.40.238.100', '37.40.238.100', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (33, 2, 6, 33, 'PU/20250930/PO0033', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '376.0000', NULL, '376.0000', '', 'Unpaid', '0.0000', '2025-09-30', '06:52:25 pm', 'Haroon', '37.40.238.100', '37.40.238.100', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (34, 2, 6, 34, 'PU/20250930/PO0034', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '571.0000', NULL, '571.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:00:56 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (35, 2, 6, 35, 'PU/20250930/PO0035', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '817.5000', NULL, '817.5000', '', 'Unpaid', '0.0000', '2025-09-30', '07:10:00 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (36, 2, 6, 36, 'PU/20250930/PO0036', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '514.0000', NULL, '514.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:14:38 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (37, 2, 6, 37, 'PU/20250930/PO0037', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '209.0000', NULL, '209.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:17:41 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (38, 2, 6, 38, 'PU/20250930/PO0038', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '357.0000', NULL, '357.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:21:15 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (39, 2, 6, 39, 'PU/20250930/PO0039', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '157.0000', NULL, '157.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:25:43 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (40, 2, 6, 40, 'PU/20250930/PO0040', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '128.0000', NULL, '128.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:29:31 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (41, 2, 6, 41, 'PU/20250930/PO0041', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '178.0000', NULL, '178.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:35:23 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (42, 2, 6, 42, 'PU/20250930/PO0042', '', '2025-09-30', 'Received', 3, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '450.0000', NULL, '450.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:40:06 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (43, 2, 6, 43, 'PU/20250930/PO0043', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '257.0000', NULL, '257.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:48:11 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (44, 2, 4, 44, 'PU/20250930/PO0044', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '280.0000', NULL, '280.0000', '', 'Unpaid', '0.0000', '2025-09-30', '07:56:03 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (45, 2, 6, 45, 'PU/20250930/PO0045', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '976.0000', NULL, '976.0000', '', 'Unpaid', '0.0000', '2025-09-30', '08:03:16 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (46, 2, 6, 46, 'PU/20250930/PO0046', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '972.0000', NULL, '972.0000', '', 'Unpaid', '0.0000', '2025-09-30', '08:14:58 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (47, 2, 6, 47, 'PU/20250930/PO0047', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '379.0000', NULL, '379.0000', '', 'Unpaid', '0.0000', '2025-09-30', '08:19:49 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (48, 2, 6, 48, 'PU/20250930/PO0048', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '665.6500', NULL, '665.6500', '', 'Unpaid', '0.0000', '2025-09-30', '08:24:01 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (49, 2, 6, 49, 'PU/20250930/PO0049', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '1206.0000', NULL, '1206.0000', '', 'Unpaid', '0.0000', '2025-09-30', '08:32:57 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (50, 2, 6, 50, 'PU/20250930/PO0050', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '985.4000', NULL, '985.4000', '', 'Unpaid', '0.0000', '2025-09-30', '08:37:00 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (51, 2, 6, 51, 'PU/20250930/PO0051', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '492.0000', NULL, '492.0000', '', 'Unpaid', '0.0000', '2025-09-30', '08:43:50 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (52, 2, 6, 52, 'PU/20250930/PO0052', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '336.0000', NULL, '336.0000', '', 'Unpaid', '0.0000', '2025-09-30', '08:52:03 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (53, 2, 6, 53, 'PU/20250930/PO0053', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '648.0000', NULL, '648.0000', '', 'Unpaid', '0.0000', '2025-09-30', '08:57:09 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (54, 2, 6, 54, 'PU/20250930/PO0054', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '117.0000', NULL, '117.0000', '', 'Unpaid', '0.0000', '2025-09-30', '09:01:08 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (55, 2, 6, 55, 'PU/20250930/PO0055', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '6.0000', NULL, '6.0000', '', 'Unpaid', '0.0000', '2025-09-30', '09:02:07 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (56, 2, 6, 56, 'PU/20250930/PO0056', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '6.0000', NULL, '6.0000', '', 'Unpaid', '0.0000', '2025-09-30', '09:03:21 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (57, 2, 6, 57, 'PU/20250930/PO0057', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '12.0000', NULL, '12.0000', '', 'Unpaid', '0.0000', '2025-09-30', '10:03:20 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (58, 2, 6, 58, 'PU/20250930/PO0058', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '140.0000', NULL, '140.0000', '', 'Unpaid', '0.0000', '2025-09-30', '10:23:42 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (59, 2, 6, 59, 'PU/20250930/PO0059', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '3.0000', NULL, '3.0000', '', 'Unpaid', '0.0000', '2025-09-30', '10:29:39 pm', 'Haroon', '37.200.207.128', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (60, 2, 6, 60, 'PU/20250930/PO0060', '', '2025-09-30', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '75.0000', NULL, '75.0000', '', 'Unpaid', '0.0000', '2025-09-30', '11:10:43 pm', 'Haroon', '37.200.207.92', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (61, 2, 8, 61, 'PU/20251001/PO0061', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '487.0000', NULL, '487.0000', '', 'Unpaid', '0.0000', '2025-10-01', '07:24:39 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (62, 2, 8, 62, 'PU/20251001/PO0062', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '552.5000', NULL, '552.5000', '', 'Unpaid', '0.0000', '2025-10-01', '07:31:10 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (63, 2, 8, 63, 'PU/20251001/PO0063', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '596.0000', NULL, '596.0000', '', 'Unpaid', '0.0000', '2025-10-01', '07:40:58 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (64, 2, 8, 64, 'PU/20251001/PO0064', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '496.0000', NULL, '496.0000', '', 'Unpaid', '0.0000', '2025-10-01', '07:44:00 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (65, 2, 8, 65, 'PU/20251001/PO0065', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '340.0000', NULL, '340.0000', '', 'Unpaid', '0.0000', '2025-10-01', '07:46:54 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (66, 2, 8, 66, 'PU/20251001/PO0066', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '293.0000', NULL, '293.0000', '', 'Unpaid', '0.0000', '2025-10-01', '07:56:45 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (67, 2, 8, 67, 'PU/20251001/PO0067', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '262.0000', NULL, '262.0000', '', 'Unpaid', '0.0000', '2025-10-01', '08:00:35 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (68, 2, 8, 68, 'PU/20251001/PO0068', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '829.0000', NULL, '829.0000', '', 'Unpaid', '0.0000', '2025-10-01', '08:12:42 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (69, 2, 8, 69, 'PU/20251001/PO0069', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '124.0000', NULL, '124.0000', '', 'Unpaid', '0.0000', '2025-10-01', '08:22:06 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (70, 2, 8, 70, 'PU/20251001/PO0070', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '581.0000', NULL, '581.0000', '', 'Unpaid', '0.0000', '2025-10-01', '08:57:10 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (71, 2, 8, 71, 'PU/20251001/PO0071', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '291.0000', NULL, '291.0000', '', 'Unpaid', '0.0000', '2025-10-01', '09:02:07 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (72, 2, 8, 72, 'PU/20251001/PO0072', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '341.0000', NULL, '341.0000', '', 'Unpaid', '0.0000', '2025-10-01', '09:07:56 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (73, 2, 8, 73, 'PU/20251001/PO0073', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '278.0000', NULL, '278.0000', '', 'Unpaid', '0.0000', '2025-10-01', '09:15:04 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (74, 2, 8, 74, 'PU/20251001/PO0074', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '64.0000', NULL, '64.0000', '', 'Unpaid', '0.0000', '2025-10-01', '09:18:54 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (75, 2, 8, 75, 'PU/20251001/PO0075', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '97.0000', NULL, '97.0000', '', 'Unpaid', '0.0000', '2025-10-01', '09:26:44 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (76, 2, 8, 76, 'PU/20251001/PO0076', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '836.0000', NULL, '836.0000', '', 'Unpaid', '0.0000', '2025-10-01', '09:32:38 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (77, 2, 8, 77, 'PU/20251001/PO0077', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '247.0000', NULL, '247.0000', '', 'Unpaid', '0.0000', '2025-10-01', '09:36:56 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (78, 2, 8, 78, 'PU/20251001/PO0078', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '80.0000', NULL, '80.0000', '', 'Unpaid', '0.0000', '2025-10-01', '09:38:39 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (79, 2, 8, 79, 'PU/20251001/PO0079', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '851.5000', NULL, '851.5000', '', 'Unpaid', '0.0000', '2025-10-01', '09:46:45 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (80, 2, 8, 80, 'PU/20251001/PO0080', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '597.0000', NULL, '597.0000', '', 'Unpaid', '0.0000', '2025-10-01', '09:53:24 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (81, 2, 8, 81, 'PU/20251001/PO0081', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '570.5000', NULL, '570.5000', '', 'Unpaid', '0.0000', '2025-10-01', '09:57:26 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (82, 2, 8, 82, 'PU/20251001/PO0082', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '571.0000', NULL, '571.0000', '', 'Unpaid', '0.0000', '2025-10-01', '10:02:45 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (83, 2, 8, 83, 'PU/20251001/PO0083', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '994.0000', NULL, '994.0000', '', 'Unpaid', '0.0000', '2025-10-01', '10:19:06 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (84, 2, 8, 84, 'PU/20251001/PO0084', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '5.0000', NULL, '5.0000', '', 'Unpaid', '0.0000', '2025-10-01', '10:23:29 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (85, 2, 8, 85, 'PU/20251001/PO0085', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '1096.7000', NULL, '1096.7000', '', 'Unpaid', '0.0000', '2025-10-01', '10:42:14 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (86, 2, 8, 86, 'PU/20251001/PO0086', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '1443.0000', NULL, '1443.0000', '', 'Unpaid', '0.0000', '2025-10-01', '10:45:37 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (87, 2, 8, 87, 'PU/20251001/PO0087', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '987.0000', NULL, '987.0000', '', 'Unpaid', '0.0000', '2025-10-01', '10:51:15 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (88, 2, 3, 88, 'PU/20251001/PO0088', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '148.0000', NULL, '148.0000', '', 'Unpaid', '0.0000', '2025-10-01', '10:56:51 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (89, 2, 8, 89, 'PU/20251001/PO0089', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '675.0000', NULL, '675.0000', '', 'Unpaid', '0.0000', '2025-10-01', '11:00:13 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (90, 2, 8, 90, 'PU/20251001/PO0090', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '569.0000', NULL, '569.0000', '', 'Unpaid', '0.0000', '2025-10-01', '11:06:48 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (91, 2, 8, 91, 'PU/20251001/PO0091', '', '2025-10-01', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '1779.0000', NULL, '1779.0000', '', 'Unpaid', '0.0000', '2025-10-01', '11:10:37 pm', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (92, 2, 8, 92, 'PU/20251002/PO0092', '', '2025-10-02', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '66.0000', NULL, '66.0000', '', 'Unpaid', '0.0000', '2025-10-02', '12:01:51 am', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (93, 2, 8, 93, 'PU/20251002/PO0093', '', '2025-10-02', 'Received', 3, NULL, 151, NULL, NULL, 'in_percentage', NULL, '42.0000', NULL, '42.0000', '', 'Unpaid', '0.0000', '2025-10-02', '01:23:40 am', 'Haroon', '5.162.211.142', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);


#
# TABLE STRUCTURE FOR: db_purchaseitems
#

DROP TABLE IF EXISTS `db_purchaseitems`;

CREATE TABLE `db_purchaseitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `purchase_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `purchase_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchaseitems_ibfk_1` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=621 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (88, 2, 1, 'Received', 19, '6.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (89, 2, 2, 'Received', 13, '8.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (90, 2, 3, 'Received', 33, '8.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (91, 2, 3, 'Received', 7, '12.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (92, 2, 3, 'Received', 65, '26.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '78.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (93, 2, 4, 'Received', 83, '11.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '22.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (94, 2, 4, 'Received', 10, '22.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '66.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (95, 2, 4, 'Received', 146, '9.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (96, 2, 4, 'Received', 161, '28.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '84.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (97, 2, 5, 'Received', 35, '32.00', '4.9500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.9500', '158.4000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (98, 2, 5, 'Received', 34, '89.00', '4.8500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.8500', '431.6500', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (99, 2, 5, 'Received', 105, '30.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (100, 2, 5, 'Received', 52, '34.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '170.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (101, 2, 5, 'Received', 36, '92.00', '3.9700', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.9700', '365.2400', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (102, 2, 5, 'Received', 49, '53.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '265.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (103, 2, 5, 'Received', 54, '16.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (104, 2, 5, 'Received', 241, '10.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (105, 2, 5, 'Received', 74, '24.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '72.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (106, 2, 5, 'Received', 6, '17.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '68.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (107, 2, 6, 'Received', 70, '28.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '140.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (108, 2, 6, 'Received', 93, '25.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '125.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (109, 2, 6, 'Received', 145, '55.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '110.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (110, 2, 6, 'Received', 61, '21.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '63.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (111, 2, 6, 'Received', 2, '16.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '64.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (112, 2, 7, 'Received', 14, '26.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '78.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (113, 2, 7, 'Received', 20, '9.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '27.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (114, 2, 7, 'Received', 141, '11.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '33.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (115, 2, 7, 'Received', 80, '43.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '86.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (116, 2, 7, 'Received', 12, '32.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '96.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (117, 2, 7, 'Received', 82, '53.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '106.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (118, 2, 7, 'Received', 4, '16.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '64.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (119, 2, 7, 'Received', 15, '25.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '75.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (120, 2, 7, 'Received', 11, '23.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '69.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (121, 2, 7, 'Received', 8, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (122, 2, 8, 'Received', 137, '62.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '124.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (123, 2, 8, 'Received', 180, '11.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '44.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (124, 2, 8, 'Received', 157, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (125, 2, 8, 'Received', 75, '7.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '21.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (126, 2, 8, 'Received', 30, '22.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '44.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (127, 2, 8, 'Received', 28, '22.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '44.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (128, 2, 8, 'Received', 78, '18.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '108.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (129, 2, 9, 'Received', 81, '59.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '118.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (130, 2, 9, 'Received', 67, '26.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '78.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (131, 2, 9, 'Received', 104, '7.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (132, 2, 9, 'Received', 183, '6.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (133, 2, 9, 'Received', 184, '5.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (134, 2, 9, 'Received', 155, '24.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (135, 2, 9, 'Received', 29, '36.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '72.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (136, 2, 9, 'Received', 58, '22.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '110.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (137, 2, 9, 'Received', 201, '11.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '22.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (138, 2, 9, 'Received', 43, '76.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '380.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (139, 2, 10, 'Received', 60, '54.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '324.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (140, 2, 10, 'Received', 88, '40.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '200.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (141, 2, 10, 'Received', 101, '6.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (142, 2, 10, 'Received', 144, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (143, 2, 10, 'Received', 26, '31.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '62.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (144, 2, 10, 'Received', 84, '8.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '40.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (145, 2, 10, 'Received', 42, '59.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '295.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (146, 2, 10, 'Received', 152, '18.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '72.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (147, 2, 11, 'Received', 31, '7.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '14.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (148, 2, 11, 'Received', 134, '32.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '32.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (149, 2, 11, 'Received', 135, '15.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (150, 2, 11, 'Received', 17, '31.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '93.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (151, 2, 11, 'Received', 69, '60.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '180.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (152, 2, 11, 'Received', 3, '19.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '57.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (153, 2, 11, 'Received', 56, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (154, 2, 11, 'Received', 77, '10.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (155, 2, 11, 'Received', 21, '21.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (156, 2, 11, 'Received', 138, '12.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (157, 2, 12, 'Received', 23, '25.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (158, 2, 12, 'Received', 87, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (159, 2, 12, 'Received', 24, '34.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '68.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (160, 2, 12, 'Received', 73, '21.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '63.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (161, 2, 12, 'Received', 79, '9.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (162, 2, 12, 'Received', 1, '27.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '81.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (163, 2, 12, 'Received', 136, '23.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '23.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (164, 2, 12, 'Received', 5, '7.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (165, 2, 13, 'Received', 16, '33.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '99.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (166, 2, 13, 'Received', 53, '45.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '225.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (167, 2, 13, 'Received', 62, '43.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '129.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (168, 2, 13, 'Received', 63, '50.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (169, 2, 13, 'Received', 64, '22.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '66.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (170, 2, 13, 'Received', 25, '25.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (171, 2, 13, 'Received', 27, '32.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '64.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (172, 2, 13, 'Received', 32, '30.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (173, 2, 13, 'Received', 22, '32.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '64.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (174, 2, 14, 'Received', 169, '12.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (175, 2, 14, 'Received', 71, '13.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '52.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (176, 2, 14, 'Received', 168, '47.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '235.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (177, 2, 14, 'Received', 167, '17.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '68.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (178, 2, 14, 'Received', 39, '20.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (179, 2, 14, 'Received', 195, '20.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (180, 2, 14, 'Received', 46, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (181, 2, 14, 'Received', 204, '17.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '51.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (182, 2, 14, 'Received', 162, '15.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (183, 2, 14, 'Received', 48, '8.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (184, 2, 14, 'Received', 194, '23.00', '5.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.5000', '126.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (185, 2, 15, 'Received', 102, '12.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (186, 2, 15, 'Received', 197, '9.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (187, 2, 15, 'Received', 76, '8.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (188, 2, 15, 'Received', 88, '16.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (189, 2, 15, 'Received', 176, '8.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '32.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (190, 2, 15, 'Received', 193, '31.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '155.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (191, 2, 15, 'Received', 47, '22.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '66.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (192, 2, 15, 'Received', 38, '9.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '27.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (193, 2, 15, 'Received', 166, '31.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '155.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (194, 2, 15, 'Received', 159, '12.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '36.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (195, 2, 16, 'Received', 179, '12.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '36.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (196, 2, 16, 'Received', 100, '11.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '55.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (197, 2, 16, 'Received', 97, '5.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '25.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (198, 2, 16, 'Received', 40, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (199, 2, 16, 'Received', 175, '22.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '66.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (200, 2, 16, 'Received', 174, '22.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '66.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (201, 2, 16, 'Received', 221, '12.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '72.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (202, 2, 16, 'Received', 230, '9.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (203, 2, 16, 'Received', 235, '9.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (204, 2, 16, 'Received', 238, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (205, 2, 16, 'Received', 226, '15.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '75.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (206, 2, 16, 'Received', 237, '21.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '126.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (207, 2, 16, 'Received', 229, '4.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (208, 2, 17, 'Received', 236, '63.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '378.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (209, 2, 17, 'Received', 225, '10.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (210, 2, 17, 'Received', 210, '7.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (211, 2, 17, 'Received', 214, '2.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '8.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (212, 2, 17, 'Received', 227, '9.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '27.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (213, 2, 17, 'Received', 209, '22.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '66.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (214, 2, 17, 'Received', 233, '13.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '52.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (215, 2, 17, 'Received', 218, '10.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (216, 2, 17, 'Received', 208, '33.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '132.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (217, 2, 17, 'Received', 228, '21.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '84.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (218, 2, 17, 'Received', 240, '9.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '36.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (219, 2, 17, 'Received', 229, '20.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (220, 2, 18, 'Received', 126, '34.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '170.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (221, 2, 18, 'Received', 117, '12.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (222, 2, 18, 'Received', 110, '49.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '245.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (223, 2, 18, 'Received', 111, '34.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '170.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (224, 2, 18, 'Received', 109, '41.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '205.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (225, 2, 18, 'Received', 113, '95.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '475.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (226, 2, 18, 'Received', 116, '69.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '345.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (227, 2, 18, 'Received', 114, '17.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '85.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (228, 2, 18, 'Received', 127, '67.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '268.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (229, 2, 18, 'Received', 128, '43.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '215.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (230, 2, 18, 'Received', 122, '69.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '345.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (231, 2, 18, 'Received', 108, '57.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '285.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (232, 2, 18, 'Received', 119, '9.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (233, 2, 18, 'Received', 112, '16.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (234, 2, 18, 'Received', 121, '23.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '115.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (235, 2, 18, 'Received', 107, '67.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '335.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (236, 2, 18, 'Received', 166, '11.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '55.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (237, 2, 18, 'Received', 125, '53.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '212.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (238, 2, 18, 'Received', 124, '62.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '310.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (239, 2, 19, 'Received', 51, '23.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '115.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (240, 2, 20, 'Received', 49, '53.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '265.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (241, 2, 21, 'Received', 275, '23.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '115.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (242, 2, 22, 'Received', 20, '26.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '78.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (243, 2, 23, 'Received', 19, '14.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (244, 2, 24, 'Received', 285, '24.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '72.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (245, 2, 25, 'Received', 138, '14.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (246, 2, 26, 'Received', 140, '5.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (247, 2, 27, 'Received', 141, '17.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '51.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (248, 2, 28, 'Received', 229, '17.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '102.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (249, 2, 29, 'Received', 347, '12.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (250, 2, 29, 'Received', 180, '9.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '36.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (251, 2, 29, 'Received', 52, '23.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '115.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (252, 2, 29, 'Received', 298, '6.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '36.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (253, 2, 29, 'Received', 254, '1.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '4.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (254, 2, 29, 'Received', 105, '9.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (255, 2, 30, 'Received', 169, '20.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '100.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (256, 2, 30, 'Received', 81, '7.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '14.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (257, 2, 30, 'Received', 88, '21.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '105.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (258, 2, 30, 'Received', 295, '3.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '9.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (259, 2, 30, 'Received', 134, '19.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '19.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (260, 2, 30, 'Received', 136, '6.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (261, 2, 31, 'Received', 316, '14.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (262, 2, 31, 'Received', 138, '9.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (263, 2, 31, 'Received', 259, '1.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '2.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (264, 2, 31, 'Received', 132, '2.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '8.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (265, 2, 31, 'Received', 195, '25.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (266, 2, 31, 'Received', 95, '24.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (267, 2, 31, 'Received', 84, '10.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (268, 2, 32, 'Received', 316, '14.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (269, 2, 32, 'Received', 138, '9.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (270, 2, 32, 'Received', 259, '1.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '2.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (271, 2, 32, 'Received', 132, '2.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '8.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (272, 2, 32, 'Received', 195, '25.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (273, 2, 32, 'Received', 95, '24.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (274, 2, 32, 'Received', 84, '10.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (275, 2, 33, 'Received', 316, '14.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (276, 2, 33, 'Received', 138, '9.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (277, 2, 33, 'Received', 259, '1.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '2.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (278, 2, 33, 'Received', 132, '2.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '8.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (279, 2, 33, 'Received', 195, '25.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (280, 2, 33, 'Received', 95, '24.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (281, 2, 33, 'Received', 84, '10.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (282, 2, 34, 'Received', 251, '1.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (283, 2, 34, 'Received', 249, '7.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (284, 2, 34, 'Received', 102, '32.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '160.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (285, 2, 34, 'Received', 53, '34.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '170.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (286, 2, 34, 'Received', 43, '42.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '210.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (287, 2, 35, 'Received', 243, '44.00', '6.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.5000', '286.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (288, 2, 35, 'Received', 58, '11.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '55.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (289, 2, 35, 'Received', 94, '21.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '126.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (290, 2, 35, 'Received', 166, '47.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '235.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (291, 2, 35, 'Received', 89, '13.00', '4.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.5000', '58.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (292, 2, 35, 'Received', 61, '19.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '57.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (293, 2, 36, 'Received', 91, '50.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '250.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (294, 2, 36, 'Received', 196, '13.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '39.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (295, 2, 36, 'Received', 49, '30.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (296, 2, 36, 'Received', 9, '1.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (297, 2, 36, 'Received', 5, '12.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (298, 2, 36, 'Received', 12, '8.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (299, 2, 37, 'Received', 11, '6.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (300, 2, 37, 'Received', 6, '8.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '32.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (301, 2, 37, 'Received', 18, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (302, 2, 37, 'Received', 13, '8.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (303, 2, 37, 'Received', 14, '13.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '39.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (304, 2, 37, 'Received', 10, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (305, 2, 37, 'Received', 1, '14.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (306, 2, 38, 'Received', 7, '20.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (307, 2, 38, 'Received', 2, '26.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '104.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (308, 2, 38, 'Received', 3, '7.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '21.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (309, 2, 38, 'Received', 15, '13.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '39.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (310, 2, 38, 'Received', 4, '4.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (311, 2, 38, 'Received', 176, '7.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (312, 2, 38, 'Received', 16, '23.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '69.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (313, 2, 39, 'Received', 8, '5.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (314, 2, 39, 'Received', 345, '6.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (315, 2, 39, 'Received', 22, '15.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (316, 2, 39, 'Received', 26, '11.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '22.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (317, 2, 39, 'Received', 24, '15.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (318, 2, 39, 'Received', 28, '7.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '14.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (319, 2, 39, 'Received', 32, '8.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (320, 2, 39, 'Received', 21, '3.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (321, 2, 40, 'Received', 27, '12.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (322, 2, 40, 'Received', 23, '7.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '14.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (323, 2, 40, 'Received', 25, '9.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (324, 2, 40, 'Received', 280, '2.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '4.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (325, 2, 40, 'Received', 30, '17.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '34.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (326, 2, 40, 'Received', 29, '17.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '34.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (327, 2, 41, 'Received', 19, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (328, 2, 41, 'Received', 20, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (329, 2, 41, 'Received', 17, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (330, 2, 41, 'Received', 152, '15.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (331, 2, 41, 'Received', 106, '11.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '33.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (332, 2, 41, 'Received', 79, '8.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (333, 2, 41, 'Received', 204, '3.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '9.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (334, 2, 42, 'Received', 314, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (335, 2, 42, 'Received', 148, '10.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (336, 2, 42, 'Received', 161, '26.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '78.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (337, 2, 42, 'Received', 67, '26.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '78.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (338, 2, 42, 'Received', 65, '28.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '84.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (339, 2, 42, 'Received', 87, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (340, 2, 42, 'Received', 74, '42.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '126.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (341, 2, 43, 'Received', 258, '4.00', '4.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.5000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (342, 2, 43, 'Received', 56, '2.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '10.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (343, 2, 43, 'Received', 268, '14.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (344, 2, 43, 'Received', 140, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (345, 2, 43, 'Received', 73, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (346, 2, 43, 'Received', 101, '14.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '70.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (347, 2, 43, 'Received', 78, '3.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (348, 2, 43, 'Received', 200, '9.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (349, 2, 44, 'Received', 123, '70.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '280.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (350, 2, 45, 'Received', 50, '11.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '55.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (351, 2, 45, 'Received', 168, '28.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '140.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (352, 2, 45, 'Received', 315, '20.00', '4.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.5000', '90.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (353, 2, 45, 'Received', 269, '11.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '55.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (354, 2, 45, 'Received', 154, '11.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '55.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (355, 2, 45, 'Received', 97, '25.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '125.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (356, 2, 45, 'Received', 103, '76.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '456.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (357, 2, 46, 'Received', 159, '17.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '51.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (358, 2, 46, 'Received', 350, '15.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '90.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (359, 2, 46, 'Received', 247, '7.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (360, 2, 46, 'Received', 260, '35.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '175.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (361, 2, 46, 'Received', 197, '43.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '215.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (362, 2, 46, 'Received', 60, '51.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '306.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (363, 2, 46, 'Received', 269, '20.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '100.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (364, 2, 47, 'Received', 54, '16.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (365, 2, 47, 'Received', 241, '16.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (366, 2, 47, 'Received', 39, '27.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '108.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (367, 2, 47, 'Received', 48, '6.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (368, 2, 47, 'Received', 281, '4.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (369, 2, 47, 'Received', 46, '4.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (370, 2, 47, 'Received', 47, '23.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '69.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (371, 2, 48, 'Received', 38, '10.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (372, 2, 48, 'Received', 288, '36.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '144.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (373, 2, 48, 'Received', 40, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (374, 2, 48, 'Received', 44, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (375, 2, 48, 'Received', 36, '45.00', '3.9700', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.9700', '178.6500', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (376, 2, 48, 'Received', 37, '4.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (377, 2, 48, 'Received', 93, '20.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '100.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (378, 2, 48, 'Received', 96, '30.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (379, 2, 48, 'Received', 88, '7.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (380, 2, 49, 'Received', 116, '28.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '140.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (381, 2, 49, 'Received', 123, '34.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '136.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (382, 2, 49, 'Received', 125, '28.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '112.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (383, 2, 49, 'Received', 128, '23.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '115.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (384, 2, 49, 'Received', 124, '28.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '140.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (385, 2, 49, 'Received', 127, '32.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '128.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (386, 2, 49, 'Received', 107, '87.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '435.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (387, 2, 50, 'Received', 63, '56.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '168.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (388, 2, 50, 'Received', 62, '42.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '126.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (389, 2, 50, 'Received', 35, '34.00', '4.9500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.9500', '168.3000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (390, 2, 50, 'Received', 34, '46.00', '4.8500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.8500', '223.1000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (391, 2, 50, 'Received', 42, '36.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '180.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (392, 2, 50, 'Received', 51, '24.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (393, 2, 51, 'Received', 71, '27.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '108.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (394, 2, 51, 'Received', 160, '1.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (395, 2, 51, 'Received', 48, '1.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (396, 2, 51, 'Received', 130, '1.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (397, 2, 51, 'Received', 174, '15.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (398, 2, 51, 'Received', 175, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (399, 2, 51, 'Received', 144, '94.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '282.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (400, 2, 52, 'Received', 77, '14.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (401, 2, 52, 'Received', 137, '45.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '90.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (402, 2, 52, 'Received', 70, '7.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (403, 2, 52, 'Received', 184, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (404, 2, 52, 'Received', 183, '3.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '9.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (405, 2, 52, 'Received', 83, '22.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '44.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (406, 2, 52, 'Received', 82, '31.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '62.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (407, 2, 52, 'Received', 145, '8.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (408, 2, 52, 'Received', 80, '16.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '32.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (409, 2, 53, 'Received', 236, '61.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '366.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (410, 2, 53, 'Received', 237, '10.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (411, 2, 53, 'Received', 351, '6.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (412, 2, 53, 'Received', 228, '13.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '52.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (413, 2, 53, 'Received', 226, '5.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '25.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (414, 2, 53, 'Received', 208, '13.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '52.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (415, 2, 53, 'Received', 336, '10.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (416, 2, 53, 'Received', 335, '4.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (417, 2, 53, 'Received', 342, '9.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '27.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (418, 2, 54, 'Received', 339, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (419, 2, 54, 'Received', 230, '10.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (420, 2, 54, 'Received', 337, '3.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '9.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (421, 2, 55, 'Received', 210, '1.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (422, 2, 56, 'Received', 221, '1.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (423, 2, 57, 'Received', 45, '4.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (424, 2, 58, 'Received', 275, '25.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '125.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (425, 2, 58, 'Received', 57, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (426, 2, 59, 'Received', 33, '1.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '3.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (427, 2, 60, 'Received', 111, '15.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '75.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (428, 2, 61, 'Received', 11, '23.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '69.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (429, 2, 61, 'Received', 376, '5.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (430, 2, 61, 'Received', 141, '20.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (431, 2, 61, 'Received', 268, '8.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (432, 2, 61, 'Received', 50, '50.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '250.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (433, 2, 61, 'Received', 161, '17.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '51.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (434, 2, 61, 'Received', 30, '9.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (435, 2, 62, 'Received', 14, '28.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '84.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (436, 2, 62, 'Received', 197, '10.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (437, 2, 62, 'Received', 61, '4.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (438, 2, 62, 'Received', 29, '21.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (439, 2, 62, 'Received', 165, '13.00', '4.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.5000', '58.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (440, 2, 62, 'Received', 88, '51.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '255.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (441, 2, 62, 'Received', 133, '3.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '9.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (442, 2, 62, 'Received', 22, '21.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (443, 2, 63, 'Received', 136, '16.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (444, 2, 63, 'Received', 134, '27.00', '1.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '1.0000', '27.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (445, 2, 63, 'Received', 42, '57.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '285.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (446, 2, 63, 'Received', 52, '18.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '90.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (447, 2, 63, 'Received', 6, '14.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '56.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (448, 2, 63, 'Received', 259, '7.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '14.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (449, 2, 63, 'Received', 382, '6.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (450, 2, 63, 'Received', 15, '32.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '96.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (451, 2, 64, 'Received', 18, '5.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (452, 2, 64, 'Received', 12, '23.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '69.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (453, 2, 64, 'Received', 60, '26.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '156.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (454, 2, 64, 'Received', 169, '16.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (455, 2, 64, 'Received', 17, '27.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '81.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (456, 2, 64, 'Received', 105, '19.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '95.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (457, 2, 65, 'Received', 45, '9.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '27.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (458, 2, 65, 'Received', 391, '13.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '26.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (459, 2, 65, 'Received', 162, '9.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '36.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (460, 2, 65, 'Received', 46, '6.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (461, 2, 65, 'Received', 38, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (462, 2, 65, 'Received', 44, '5.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (463, 2, 65, 'Received', 19, '5.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (464, 2, 65, 'Received', 166, '31.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '155.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (465, 2, 66, 'Received', 47, '15.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (466, 2, 66, 'Received', 167, '13.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '52.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (467, 2, 66, 'Received', 313, '9.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '27.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (468, 2, 66, 'Received', 377, '23.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '69.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (469, 2, 66, 'Received', 147, '6.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (470, 2, 66, 'Received', 299, '5.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '10.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (471, 2, 66, 'Received', 183, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (472, 2, 66, 'Received', 240, '6.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '24.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (473, 2, 67, 'Received', 342, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (474, 2, 67, 'Received', 337, '14.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (475, 2, 67, 'Received', 228, '22.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '88.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (476, 2, 67, 'Received', 214, '3.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (477, 2, 67, 'Received', 339, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (478, 2, 67, 'Received', 335, '4.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (479, 2, 68, 'Received', 227, '30.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '90.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (480, 2, 68, 'Received', 236, '67.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '402.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (481, 2, 68, 'Received', 226, '4.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (482, 2, 68, 'Received', 225, '5.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '25.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (483, 2, 68, 'Received', 234, '3.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '18.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (484, 2, 68, 'Received', 237, '1.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (485, 2, 68, 'Received', 351, '13.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '52.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (486, 2, 68, 'Received', 208, '48.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '192.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (487, 2, 68, 'Received', 349, '5.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (488, 2, 68, 'Received', 222, '3.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '9.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (489, 2, 69, 'Received', 219, '3.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (490, 2, 69, 'Received', 334, '4.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (491, 2, 69, 'Received', 221, '8.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (492, 2, 69, 'Received', 229, '8.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (493, 2, 70, 'Received', 251, '2.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (494, 2, 70, 'Received', 250, '6.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (495, 2, 70, 'Received', 71, '17.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '68.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (496, 2, 70, 'Received', 39, '21.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '84.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (497, 2, 70, 'Received', 63, '52.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '156.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (498, 2, 70, 'Received', 62, '57.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '171.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (499, 2, 70, 'Received', 67, '28.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '84.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (500, 2, 71, 'Received', 26, '26.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '52.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (501, 2, 71, 'Received', 58, '23.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '115.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (502, 2, 71, 'Received', 81, '34.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '68.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (503, 2, 71, 'Received', 272, '3.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (504, 2, 71, 'Received', 180, '5.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (505, 2, 71, 'Received', 176, '4.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (506, 2, 71, 'Received', 386, '2.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '8.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (507, 2, 72, 'Received', 137, '20.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '40.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (508, 2, 72, 'Received', 347, '11.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '44.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (509, 2, 72, 'Received', 78, '22.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '132.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (510, 2, 72, 'Received', 381, '7.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (511, 2, 72, 'Received', 195, '15.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '90.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (512, 2, 73, 'Received', 82, '28.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '56.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (513, 2, 73, 'Received', 23, '13.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '26.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (514, 2, 73, 'Received', 24, '31.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '62.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (515, 2, 73, 'Received', 28, '15.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (516, 2, 73, 'Received', 80, '20.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '40.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (517, 2, 73, 'Received', 83, '5.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '10.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (518, 2, 73, 'Received', 74, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (519, 2, 74, 'Received', 249, '4.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (520, 2, 74, 'Received', 73, '16.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '48.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (521, 2, 75, 'Received', 178, '3.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (522, 2, 75, 'Received', 180, '3.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (523, 2, 75, 'Received', 258, '2.00', '4.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.5000', '9.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (524, 2, 75, 'Received', 193, '2.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '10.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (525, 2, 75, 'Received', 198, '18.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '54.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (526, 2, 76, 'Received', 336, '24.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '72.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (527, 2, 76, 'Received', 352, '15.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (528, 2, 76, 'Received', 51, '10.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (529, 2, 76, 'Received', 288, '76.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '304.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (530, 2, 76, 'Received', 32, '15.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (531, 2, 76, 'Received', 298, '5.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (532, 2, 76, 'Received', 138, '20.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '40.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (533, 2, 76, 'Received', 69, '45.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '135.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (534, 2, 76, 'Received', 348, '26.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '130.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (535, 2, 77, 'Received', 95, '4.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (536, 2, 77, 'Received', 87, '12.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '36.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (537, 2, 77, 'Received', 245, '14.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (538, 2, 77, 'Received', 65, '31.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '93.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (539, 2, 77, 'Received', 363, '8.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '16.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (540, 2, 77, 'Received', 25, '21.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '42.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (541, 2, 77, 'Received', 146, '6.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '12.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (542, 2, 78, 'Received', 254, '20.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '80.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (543, 2, 79, 'Received', 36, '91.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '455.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (544, 2, 79, 'Received', 5, '16.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '64.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (545, 2, 79, 'Received', 100, '19.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '95.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (546, 2, 79, 'Received', 93, '7.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (547, 2, 79, 'Received', 285, '3.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '9.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (548, 2, 79, 'Received', 3, '40.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (549, 2, 79, 'Received', 280, '3.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '6.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (550, 2, 79, 'Received', 174, '12.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '36.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (551, 2, 79, 'Received', 315, '7.00', '4.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.5000', '31.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (552, 2, 80, 'Received', 304, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (553, 2, 80, 'Received', 97, '4.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (554, 2, 80, 'Received', 9, '3.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '9.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (555, 2, 80, 'Received', 300, '9.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (556, 2, 80, 'Received', 172, '2.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '10.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (557, 2, 80, 'Received', 51, '47.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '235.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (558, 2, 80, 'Received', 43, '43.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '215.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (559, 2, 80, 'Received', 79, '10.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (560, 2, 80, 'Received', 316, '14.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '28.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (561, 2, 81, 'Received', 49, '35.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '175.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (562, 2, 81, 'Received', 88, '9.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '45.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (563, 2, 81, 'Received', 54, '17.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '85.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (564, 2, 81, 'Received', 101, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (565, 2, 81, 'Received', 98, '8.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '40.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (566, 2, 81, 'Received', 384, '8.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '40.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (567, 2, 81, 'Received', 66, '26.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '130.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (568, 2, 81, 'Received', 164, '9.00', '4.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.5000', '40.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (569, 2, 82, 'Received', 102, '21.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '105.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (570, 2, 82, 'Received', 269, '25.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '125.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (571, 2, 82, 'Received', 96, '21.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '105.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (572, 2, 82, 'Received', 155, '7.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '35.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (573, 2, 82, 'Received', 144, '32.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '96.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (574, 2, 82, 'Received', 247, '18.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '90.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (575, 2, 82, 'Received', 70, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (576, 2, 83, 'Received', 241, '12.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '60.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (577, 2, 83, 'Received', 260, '45.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '225.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (578, 2, 83, 'Received', 53, '60.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '300.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (579, 2, 83, 'Received', 43, '20.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '100.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (580, 2, 83, 'Received', 152, '32.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '128.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (581, 2, 83, 'Received', 77, '7.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '21.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (582, 2, 83, 'Received', 168, '28.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '140.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (583, 2, 83, 'Received', 84, '4.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (584, 2, 84, 'Received', 43, '1.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (585, 2, 85, 'Received', 319, '13.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '52.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (586, 2, 85, 'Received', 372, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (587, 2, 85, 'Received', 173, '3.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (588, 2, 85, 'Received', 369, '4.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '20.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (589, 2, 85, 'Received', 91, '55.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '275.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (590, 2, 85, 'Received', 275, '34.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '170.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (591, 2, 85, 'Received', 378, '2.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '10.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (592, 2, 85, 'Received', 34, '92.00', '4.8500', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.8500', '446.2000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (593, 2, 85, 'Received', 194, '17.00', '5.5000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.5000', '93.5000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (594, 2, 86, 'Received', 123, '32.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '128.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (595, 2, 86, 'Received', 115, '21.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '105.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (596, 2, 86, 'Received', 114, '42.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '210.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (597, 2, 86, 'Received', 107, '34.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '170.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (598, 2, 86, 'Received', 116, '65.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '325.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (599, 2, 86, 'Received', 122, '47.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '235.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (600, 2, 86, 'Received', 124, '30.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '150.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (601, 2, 86, 'Received', 113, '24.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '120.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (602, 2, 87, 'Received', 126, '13.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '65.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (603, 2, 87, 'Received', 111, '36.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '180.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (604, 2, 87, 'Received', 112, '32.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '160.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (605, 2, 87, 'Received', 125, '33.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '132.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (606, 2, 87, 'Received', 114, '90.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '450.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (607, 2, 88, 'Received', 288, '37.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '148.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (608, 2, 89, 'Received', 110, '42.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '210.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (609, 2, 89, 'Received', 108, '47.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '235.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (610, 2, 89, 'Received', 112, '6.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '30.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (611, 2, 89, 'Received', 121, '22.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '110.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (612, 2, 89, 'Received', 119, '18.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '90.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (613, 2, 90, 'Received', 35, '33.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '165.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (614, 2, 90, 'Received', 159, '11.00', '3.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '3.0000', '33.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (615, 2, 90, 'Received', 127, '64.00', '4.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '4.0000', '256.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (616, 2, 90, 'Received', 128, '23.00', '5.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '5.0000', '115.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (617, 2, 91, 'Received', 287, '85.00', '7.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '7.0000', '595.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (618, 2, 91, 'Received', 286, '148.00', '8.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '8.0000', '1184.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (619, 2, 92, 'Received', 323, '11.00', '6.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '6.0000', '66.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (620, 2, 93, 'Received', 444, '21.00', '2.0000', 'Inclusive', 151, '0.0000', 'Percentage', '0.0000', '0.0000', '2.0000', '42.0000', NULL, NULL, 1, '');


#
# TABLE STRUCTURE FOR: db_purchaseitemsreturn
#

DROP TABLE IF EXISTS `db_purchaseitemsreturn`;

CREATE TABLE `db_purchaseitemsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `return_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `return_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchaseitemsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchaseitemsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_purchasereturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasepayments
#

DROP TABLE IF EXISTS `db_purchasepayments`;

CREATE TABLE `db_purchasepayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchasepayments_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepayments_ibfk_2` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepayments_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasepaymentsreturn
#

DROP TABLE IF EXISTS `db_purchasepaymentsreturn`;

CREATE TABLE `db_purchasepaymentsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text COLLATE utf8_unicode_ci,
  `system_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_purchasereturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasereturn
#

DROP TABLE IF EXISTS `db_purchasereturn`;

CREATE TABLE `db_purchasereturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Purchase Return Code',
  `warehouse_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `return_note` text COLLATE utf8_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchasereturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasereturn_ibfk_2` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotation
#

DROP TABLE IF EXISTS `db_quotation`;

CREATE TABLE `db_quotation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create quotation Code',
  `quotation_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quotation_date` date DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `quotation_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL,
  `round_off` double(20,4) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `quotation_note` text COLLATE utf8_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'quotation return raised',
  `customer_previous_due` double(20,4) DEFAULT NULL,
  `customer_total_due` double(20,4) DEFAULT NULL,
  `sales_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_quotation_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotation_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotation_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotationitems
#

DROP TABLE IF EXISTS `db_quotationitems`;

CREATE TABLE `db_quotationitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `quotation_id` int(11) DEFAULT NULL,
  `quotation_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `quotation_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `seller_points` double(20,4) DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `quotation_id` (`quotation_id`),
  CONSTRAINT `db_quotationitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotationitems_ibfk_2` FOREIGN KEY (`quotation_id`) REFERENCES `db_quotation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: db_roles
#

DROP TABLE IF EXISTS `db_roles`;

CREATE TABLE `db_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `role_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_roles_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (1, 1, 'Admin', 'All Rights Permitted.', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (2, 1, 'Store Admin', 'Note: Apply this role for New Store Admin. ', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (3, 2, 'sales', '', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (4, 2, 'Manager', '', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (5, 2, 'Purchase Executive', '', 1);


#
# TABLE STRUCTURE FOR: db_sales
#

DROP TABLE IF EXISTS `db_sales`;

CREATE TABLE `db_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `init_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `count_id` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Use to create Sales Code',
  `sales_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `sales_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text COLLATE utf8_unicode_ci,
  `payment_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'sales return raised',
  `customer_previous_due` double(20,2) DEFAULT NULL,
  `customer_total_due` double(20,2) DEFAULT NULL,
  `quotation_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_sales_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (1, 2, 3, NULL, '1', 'SL/0001', NULL, '2025-09-28', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-09-28', '09:17:55 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, 1, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (2, 2, 3, NULL, '2', 'SL/0002', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-29', '11:24:31 am', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (3, 2, 3, NULL, '3', 'SL/0003', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-09-29', '11:29:11 am', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (4, 2, 3, NULL, '4', 'SL/0004', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '19.00', '0.00', '19.0000', '', 'Paid', '19.0000', '2025-09-29', '06:08:31 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (5, 2, 3, NULL, '5', 'SL/0005', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-09-29', '07:32:26 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (6, 2, 3, NULL, '6', 'SL/0006', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-09-29', '08:26:01 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (7, 2, 3, NULL, '7', 'SL/0007', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-09-29', '08:29:14 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (8, 2, 4, NULL, '8', 'SL/0008', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-09-29', '11:11:19 pm', 'sohar', '188.66.242.180', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (9, 2, 4, NULL, '9', 'SL/0009', NULL, '2025-09-29', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '158.01', '0.00', '158.0100', '', 'Paid', '158.0100', '2025-09-29', '11:23:40 pm', 'sohar', '188.66.242.180', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (11, 2, 3, NULL, '11', 'SL/0011', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '10:07:01 am', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (12, 2, 4, NULL, '12', 'SL/0012', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-09-30', '10:08:56 am', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (13, 2, 4, NULL, '13', 'SL/0013', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '10:18:43 am', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (14, 2, 3, NULL, '14', 'SL/0014', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '10.00', '0.00', '10.0000', '', 'Paid', '10.0000', '2025-09-30', '11:15:33 am', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (15, 2, 4, NULL, '15', 'SL/0015', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-09-30', '11:52:06 am', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (16, 2, 3, NULL, '16', 'SL/0016', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '12.00', '0.00', '12.0000', '', 'Paid', '12.0000', '2025-09-30', '12:00:57 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (17, 2, 3, NULL, '17', 'SL/0017', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '35.00', '0.00', '35.0000', '', 'Paid', '35.0000', '2025-09-30', '12:28:17 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (18, 2, 4, NULL, '18', 'SL/0018', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '8.00', '0.00', '8.0000', '', 'Paid', '8.0000', '2025-09-30', '12:44:12 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (19, 2, 4, NULL, '19', 'SL/0019', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '12:58:28 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (20, 2, 4, NULL, '20', 'SL/0020', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '21.00', '0.00', '21.0000', '', 'Paid', '21.0000', '2025-09-30', '04:34:12 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (21, 2, 3, NULL, '21', 'SL/0021', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-09-30', '04:49:22 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (22, 2, 3, NULL, '22', 'SL/0022', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '05:50:23 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (23, 2, 4, NULL, '23', 'SL/0023', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '10.00', '0.00', '10.0000', '', 'Paid', '10.0000', '2025-09-30', '05:59:43 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (24, 2, 4, NULL, '24', 'SL/0024', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '17.00', '0.00', '17.0000', '', 'Paid', '17.0000', '2025-09-30', '06:01:05 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (25, 2, 4, NULL, '25', 'SL/0025', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-09-30', '06:07:22 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (26, 2, 3, NULL, '26', 'SL/0026', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-09-30', '06:38:04 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (27, 2, 3, NULL, '27', 'SL/0027', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-09-30', '06:42:52 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (28, 2, 4, NULL, '28', 'SL/0028', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-09-30', '06:58:11 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (29, 2, 3, NULL, '29', 'SL/0029', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '07:46:25 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (30, 2, 4, NULL, '30', 'SL/0030', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '07:52:47 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (31, 2, 3, NULL, '31', 'SL/0031', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '11.00', '0.00', '11.0000', '', 'Paid', '11.0000', '2025-09-30', '07:58:57 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (32, 2, 4, NULL, '32', 'SL/0032', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '07:59:44 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (33, 2, 3, NULL, '33', 'SL/0033', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-09-30', '08:01:54 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (34, 2, 3, NULL, '34', 'SL/0034', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '08:06:04 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (35, 2, 3, NULL, '35', 'SL/0035', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '13.00', '0.00', '13.0000', '', 'Paid', '13.0000', '2025-09-30', '08:27:53 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (36, 2, 4, NULL, '36', 'SL/0036', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '13.00', '0.00', '13.0000', '', 'Paid', '13.0000', '2025-09-30', '08:42:04 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (37, 2, 4, NULL, '37', 'SL/0037', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '08:48:16 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (38, 2, 3, NULL, '38', 'SL/0038', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '3.00', '0.00', '3.0000', '', 'Paid', '3.0000', '2025-09-30', '08:49:13 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (39, 2, 3, NULL, '39', 'SL/0039', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-09-30', '08:52:46 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (40, 2, 3, NULL, '40', 'SL/0040', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '14.00', '0.00', '14.0000', '', 'Paid', '14.0000', '2025-09-30', '09:16:20 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (41, 2, 3, NULL, '41', 'SL/0041', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '12.00', '0.00', '12.0000', '', 'Paid', '12.0000', '2025-09-30', '09:35:32 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (42, 2, 4, NULL, '42', 'SL/0042', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-09-30', '09:37:49 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (43, 2, 3, NULL, '43', 'SL/0043', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-09-30', '09:42:25 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (44, 2, 4, NULL, '44', 'SL/0044', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-09-30', '09:54:48 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (45, 2, 4, NULL, '45', 'SL/0045', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-09-30', '10:23:52 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (46, 2, 6, NULL, '46', 'SL/0046', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '58.00', '0.00', '58.0000', '', 'Paid', '58.0000', '2025-09-30', '11:09:36 pm', 'saham', '37.200.207.92', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (47, 2, 6, NULL, '47', 'SL/0047', NULL, '2025-09-30', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '13.00', '0.00', '13.0000', '', 'Paid', '13.0000', '2025-09-30', '11:11:51 pm', 'saham', '37.200.207.92', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (48, 2, 3, NULL, '48', 'SL/0048', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '09:51:58 am', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (49, 2, 4, NULL, '49', 'SL/0049', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-10-01', '10:26:49 am', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (50, 2, 4, NULL, '50', 'SL/0050', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '10:28:47 am', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (51, 2, 4, NULL, '51', 'SL/0051', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-10-01', '10:46:49 am', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (52, 2, 4, NULL, '52', 'SL/0052', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-10-01', '11:04:42 am', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (53, 2, 4, NULL, '53', 'SL/0053', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '14.00', '0.00', '14.0000', '', 'Paid', '14.0000', '2025-10-01', '11:12:23 am', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (54, 2, 3, NULL, '54', 'SL/0054', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-10-01', '11:22:26 am', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (55, 2, 4, NULL, '55', 'SL/0055', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '11.00', '0.00', '11.0000', '', 'Paid', '11.0000', '2025-10-01', '11:23:34 am', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (56, 2, 4, NULL, '56', 'SL/0056', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '10.00', '0.00', '10.0000', '', 'Paid', '10.0000', '2025-10-01', '12:04:57 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (57, 2, 6, NULL, '57', 'SL/0057', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '10.00', '0.00', '10.0000', '', 'Paid', '10.0000', '2025-10-01', '12:08:35 pm', 'saham', '37.200.207.92', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (58, 2, 3, NULL, '58', 'SL/0058', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '8.00', '0.00', '8.0000', '', 'Paid', '8.0000', '2025-10-01', '12:16:31 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (59, 2, 4, NULL, '59', 'SL/0059', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '12:17:04 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (60, 2, 6, NULL, '60', 'SL/0060', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-10-01', '12:22:26 pm', 'saham', '37.40.225.85', '37.40.225.85', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (61, 2, 6, NULL, '61', 'SL/0061', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-10-01', '12:23:48 pm', 'saham', '37.40.225.85', '37.40.225.85', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (62, 2, 6, NULL, '62', 'SL/0062', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-10-01', '12:36:38 pm', 'saham', '37.40.225.85', '37.40.225.85', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (63, 2, 4, NULL, '63', 'SL/0063', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '11.00', '0.00', '11.0000', '', 'Paid', '11.0000', '2025-10-01', '12:53:48 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (64, 2, 4, NULL, '64', 'SL/0064', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-10-01', '12:58:52 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (65, 2, 3, NULL, '65', 'SL/0065', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-10-01', '01:06:15 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (66, 2, 4, NULL, '66', 'SL/0066', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '05:15:15 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (67, 2, 4, NULL, '67', 'SL/0067', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '05:17:14 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (68, 2, 3, NULL, '68', 'SL/0068', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-10-01', '05:24:11 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (69, 2, 3, NULL, '69', 'SL/0069', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-10-01', '05:33:07 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (70, 2, 3, NULL, '70', 'SL/0070', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '05:58:13 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (71, 2, 3, NULL, '71', 'SL/0071', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '27.00', '0.00', '27.0000', '', 'Paid', '27.0000', '2025-10-01', '06:02:00 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (72, 2, 4, NULL, '72', 'SL/0072', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-10-01', '06:09:36 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (73, 2, 3, NULL, '73', 'SL/0073', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '06:26:20 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (74, 2, 6, NULL, '74', 'SL/0074', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-10-01', '06:31:00 pm', 'saham', '37.40.225.58', '37.40.225.58', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (75, 2, 4, NULL, '75', 'SL/0075', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '7.00', '0.00', '7.0000', '', 'Paid', '7.0000', '2025-10-01', '06:36:39 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (76, 2, 4, NULL, '76', 'SL/0076', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2025-10-01', '06:37:22 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (77, 2, 6, NULL, '77', 'SL/0077', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '06:59:26 pm', 'saham', '37.40.225.58', '37.40.225.58', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (78, 2, 4, NULL, '78', 'SL/0078', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '9.50', '0.00', '9.5000', '', 'Paid', '9.5000', '2025-10-01', '07:08:12 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (79, 2, 6, NULL, '79', 'SL/0079', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '4.00', '0.00', '4.0000', '', 'Paid', '4.0000', '2025-10-01', '07:11:01 pm', 'saham', '37.40.224.242', '37.40.224.242', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (80, 2, 4, NULL, '80', 'SL/0080', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '07:17:57 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (81, 2, 4, NULL, '81', 'SL/0081', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '07:19:44 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (82, 2, 6, NULL, '82', 'SL/0082', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '32.00', '0.00', '32.0000', '', 'Paid', '32.0000', '2025-10-01', '07:54:31 pm', 'saham', '37.40.224.242', '37.40.224.242', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (83, 2, 6, NULL, '83', 'SL/0083', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '17.00', '0.00', '17.0000', '', 'Paid', '17.0000', '2025-10-01', '08:02:04 pm', 'saham', '37.40.224.242', '37.40.224.242', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (84, 2, 4, NULL, '84', 'SL/0084', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '08:08:31 pm', 'sohar', '188.66.242.40', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (85, 2, 6, NULL, '85', 'SL/0085', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.00', '0.00', '2.0000', '', 'Paid', '2.0000', '2025-10-01', '08:14:40 pm', 'saham', '37.40.224.242', '37.40.224.242', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (86, 2, 6, NULL, '86', 'SL/0086', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '10.00', '0.00', '10.0000', '', 'Paid', '10.0000', '2025-10-01', '08:21:53 pm', 'saham', '37.40.224.242', '37.40.224.242', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (87, 2, 3, NULL, '87', 'SL/0087', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '10.00', '0.00', '10.0000', '', 'Paid', '10.0000', '2025-10-01', '08:35:16 pm', 'Liwa', '37.28.67.43', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`) VALUES (88, 2, 3, NULL, '88', 'SL/0088', NULL, '2025-10-01', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.00', '0.00', '6.0000', '', 'Paid', '6.0000', '2025-10-01', '08:35:58 pm', 'Liwa', '